#MotifLabModule
#Collection=Example Modules

#ModuleID = CRM1_immune_system
Motifs = NFkB,AP1,IRF
Ordered = false
MaxLength = 300
Motif(NFkB) = MA0778,M00208,M00194,MA0105,HM0800,HM0801,M00052,M00053,M00054,M00051,MA2264,HM1188
Motif(AP1) = MA1130,MA1131,MA1134,MA1135,MA1136,MA1137,MA1138,MA1139,MA1141,MA1142,MA1143,MA1144,MA1145,MA1126,MA1127,MA1128,MA1129,MA1951,M00173,M00174,HM0400,M00172,M00199,M00188,MA1448,M00517,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,MA0099,MA1858,HM1232,MA0478,MA0477,MA0476,HM0624,HM0625
Motif(IRF) = HM0592,HM0593,HM0594,HM0595,HM0596,HM0597,HM0598,HM0599,MA0772,MA0653,MA0652,MA1418,MA1419,MA1420,MA0050,MA0051,M00453,MA1509,MA1888,M00062,M00063,HM0605,HM0606,HM0607,HM0608,HM0600,HM0601,HM0602,HM0603,HM0604
$color=#FF0000
$color(NFkB)=#505050
$color(AP1)=#FFFF00
$color(IRF)=#60ADFF

#ModuleID = CRM2_muscle
Motifs = MyoD,MEF2,SRF,E47
Ordered = false
MaxLength = 300
Motif(MyoD) = M00184,M00001,HM0759,HM0758,MA0499
Motif(MEF2) = MA0773,M00231,M00232,M00233,MA0660,MA0052,M00403,M00405,M00406,M00407,M00006,HM0715,HM0716,HM0710,HM0711,HM0712,HM0713,HM0714,MA0497,MA2173
Motif(SRF) = M00215,M00152,M00186,MA0083,HM1132,MA2200
Motif(E47) = M00002,M00065,M00066,M00071,HM1198
$color=#60ADFF
$color(MyoD)=#E0D24F
$color(MEF2)=#9933FF
$color(SRF)=#0000FF
$color(E47)=#4FE0CF

#ModuleID = CRM3_pluripotency
Motifs = OCT4,SOX2,NANOG
Ordered = false
MaxLength = 300
Motif(OCT4) = MA0792,MA1115,MA0142,HM0957,HM0958,HM0956,HM0886
Motif(SOX2) = HM1085,HM1086,HM1087,HM1088,MA0143
Motif(NANOG) = MA2339,HM0763,HM0764,HM0765
$color=#00FF00
$color(OCT4)=#FFB600
$color(SOX2)=#E08922
$color(NANOG)=#66CCFF

#ModuleID = CRM4_neuronal
Motifs = CREB,SRF,MEF2
Ordered = false
MaxLength = 300
Motif(CREB) = MA0608,MA0638,M00177,M00178,M00179,MA1474,MA1475,HM0281,HM0282,MA0018,MA0839,MA0840,HM0280,HM0279,HM0036,MA1849,M00113,M00039,M00040,M00041,MA2209,MA2210
Motif(SRF) = M00215,M00152,M00186,MA0083,HM1132,MA2200
Motif(MEF2) = MA0773,M00231,M00232,M00233,MA0660,MA0052,M00403,M00405,M00406,M00407,M00006,HM0715,HM0716,HM0710,HM0711,HM0712,HM0713,HM0714,MA0497,MA2173
$color=#FFFF00
$color(CREB)=#FF0066
$color(SRF)=#2235E0
$color(MEF2)=#9933FF

#ModuleID = CRM5_erythroid 
Motifs = GATA1,TAL1,LMO2,E2A
Ordered = false
MaxLength = 300
Motif(GATA1) = M00346,M00347,HM0440,M00203,M00126,M00127,M00128,HM0439,MA2388,MA0035,M00075
Motif(TAL1) = MA0091,M00065,M00066,M00070,HM1146,HM1148,HM1147
Motif(LMO2) = M00277,M00278
Motif(E2A) = MA1923,MA0522,HM1198
$color=#FFCC00
$color(GATA1)=#00FF00
$color(TAL1)=#FFCA7B
$color(LMO2)=#00FFFF
$color(E2A)=#FF99FF

#ID = MA0778
#Short = NFKB2
#Long = Nuclear factor NF-kappa-B p100 subunit
#W = 11
#Class = 6.1.1.1.2
#Factors = NFKB2
#Organisms = human (Homo sapiens)
#Interactions = HM0800,HM0998,HM0999,HM1188,MA0101,MA0101_1,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA1117,MA1117_1,MA1117_2,MA1911,MA1911_1,MA1911_2,MA2264,MA2264_1
#Alternatives = HM0801,MA0778_2,MA0778_1
#UniProt = Q00653
#Jaspar = MA0778.2
#Evidence = HT-SELEX
#PubMed = 20066093
101.0	97.0	16291.0	4.0
1.0	1.0	16041.0	3.0
8.0	5.0	16055.0	565.0
2663.0	11.0	13129.0	987.0
8380.0	977.0	856.0	636.0
5182.0	60.0	51.0	5970.0
1173.0	1395.0	1077.0	10976.0
852.0	11011.0	19.0	1867.0
256.0	12673.0	1.0	44.0
2.0	12710.0	1.0	2.0
8.0	12888.0	3.0	23.0

#ID = M00208
#Short = V$NFKB_C
#Long = NF-kappaB (nuclear factor kappa-light-chain-enhancer of activated B cells)
#W = 12
#Factors = NF-kappaB1-p50,NF-kappaB,NF-kappaB2-p52
#Organisms = human (Homo sapiens),mouse (Mus musculus),rat (Rattus norvegicus)
#Interactions = HM0207,HM0208,HM0209,HM0210,HM0253,HM0254,HM0255,HM0279,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0800,HM0998,HM1104,HM1105,HM1106,HM1124,HM1125,HM1126,HM1188,M00008,M00033,M00040,M00041,M00051,M00052,M00053,M00054,M00109,M00114,M00115,M00116,M00117,M00159,M00179,M00190,M00191,M00192,M00194,M00196,M00201,M00205,M00208,M00249,M00339,M00513,M00531,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0061,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0605,MA0605_1,MA0605_2,MA0605_3,MA1849,MA1849_1,MA1849_2,MA1902,MA1902_1,MA1902_2,MA1911,MA1911_1,MA1911_2,MA1988,MA1988_1,MA1988_2,MA2193,MA2193_1,MA2264,MA2264_1,MA2279,MA2279_1
#Alternatives = M00194,MA1902,MA1902_1,MA1902_2
#Transfac class = C0020
5.81	2.92	9.86	3.31
0.0	0.0	22.49	0.0
0.0	0.0	22.49	0.0
0.0	0.0	22.49	0.0
22.49	0.0	0.0	0.0
4.03	12.56	0.0	5.31
1.41	0.0	0.0	21.08
0.0	5.94	0.0	16.55
0.0	6.9	0.0	15.59
1.21	20.68	0.0	0.0
0.78	21.71	0.0	0.0
13.1	4.81	2.6	1.98

#ID = M00194
#Short = V$NFKB_Q6
#Long = NF-kappaB (nuclear factor kappa-light-chain-enhancer of activated B cells)
#W = 14
#Factors = p98,NF-kappaB1-p50,IkappaB-gamma,p84,IkappaB-gamma1,p50,IkappaB-gamma2,NF-kappaB,p105,p105-4,NF-kappaB1
#Organisms = human (Homo sapiens),cattle (Bos taurus),mouse (Mus musculus),rat (Rattus norvegicus)
#Interactions = HM0207,HM0208,HM0209,HM0210,HM0253,HM0254,HM0255,HM0279,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0454,HM0455,HM0800,HM0998,HM1104,HM1105,HM1106,HM1124,HM1125,HM1126,HM1188,M00008,M00033,M00040,M00041,M00051,M00052,M00053,M00054,M00109,M00114,M00115,M00116,M00117,M00159,M00179,M00190,M00191,M00192,M00194,M00196,M00201,M00205,M00208,M00249,M00339,M00513,M00531,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0061,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0605,MA0605_1,MA0605_2,MA0605_3,MA1849,MA1849_1,MA1849_2,MA1902,MA1902_1,MA1902_2,MA1911,MA1911_1,MA1911_2,MA1988,MA1988_1,MA1988_2,MA2193,MA2193_1,MA2264,MA2264_1,MA2279,MA2279_1
#Alternatives = M00208,MA1902,MA1902_1,MA1902_2
#Transfac class = C0020
4.0	1.0	4.0	4.0
2.0	0.0	8.0	3.0
0.0	0.0	11.0	2.0
0.0	0.0	13.0	0.0
1.0	0.0	12.0	0.0
13.0	0.0	0.0	0.0
6.0	6.0	0.0	1.0
1.0	1.0	2.0	9.0
0.0	3.0	0.0	10.0
1.0	3.0	0.0	9.0
1.0	12.0	0.0	0.0
0.0	12.0	0.0	1.0
2.0	4.0	3.0	4.0
3.0	4.0	3.0	3.0

#ID = MA0105
#Short = NFKB1
#Long = Nuclear factor NF-kappa-B p105 subunit
#W = 13
#Class = 6.1.1.1.1
#Factors = NFKB1
#Organisms = human (Homo sapiens)
#Interactions = HM0361,HM0362,HM0800,HM0801,HM0998,HM0999,HM1188,M00008,M00024,M00033,M00040,M00041,M00043,M00050,M00051,M00052,M00053,M00054,M00056,M00062,M00109,M00114,M00115,M00116,M00117,M00120,M00139,M00159,M00172,M00179,M00190,M00191,M00192,M00193,M00194,M00196,M00201,M00205,M00208,M00216,M00235,M00237,M00242,M00243,M00249,M00252,M00302,M00340,M00428,M00430,M00431,M00432,M00471,M00513,M00516,M00517,M00518,MA0022,MA0022_1,MA0023,MA0023_1,MA0101,MA0101_1,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0778,MA0778_1,MA0778_2,MA1117,MA1117_1,MA1117_2,MA1457,MA1457_1,MA1457_2,MA1911,MA1911_1,MA1911_2,MA2108,MA2108_1,MA2213,MA2213_1,MA2264,MA2264_1
#Alternatives = HM0800,HM0998,HM1188,MA0101,MA0101_1,MA0105_4,MA0105_1,MA0105_2,MA0105_3,MA0107,MA0107_1,MA1911,MA1911_1,MA1911_2,MA2264,MA2264_1
#UniProt = P19838
#Jaspar = MA0105.4
#Evidence = HT-SELEX
#PubMed = 20066093
8441.0	2013.0	990.0	818.0
9.0	0.0	19047.0	5.0
0.0	3.0	19177.0	2.0
4.0	0.0	19167.0	318.0
229.0	3.0	19458.0	27.0
12004.0	62.0	821.0	27.0
7003.0	18.0	32.0	6744.0
22.0	1311.0	116.0	14372.0
17.0	9574.0	4.0	130.0
497.0	9536.0	1.0	3.0
4.0	9591.0	1.0	2.0
6.0	9642.0	2.0	8.0
1231.0	1293.0	3348.0	9386.0

#ID = HM0800
#Short = NFKB1
#Long = Nuclear factor NF-kappa-B p105 subunit
#W = 12
#Class = 6.1.1.1.1
#Factors = NFKB1,DNA-binding factor KBF1,EBP-1,Nuclear factor of kappa light polypeptide gene enhancer in B-cells 1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0361,HM0362,HM0800,HM0801,HM0998,HM0999,HM1188,M00008,M00024,M00033,M00040,M00041,M00043,M00050,M00051,M00052,M00053,M00054,M00056,M00062,M00109,M00114,M00115,M00116,M00117,M00120,M00139,M00159,M00172,M00179,M00190,M00191,M00192,M00193,M00194,M00196,M00201,M00205,M00208,M00216,M00235,M00237,M00242,M00243,M00249,M00252,M00302,M00340,M00428,M00430,M00431,M00432,M00471,M00513,M00516,M00517,M00518,MA0022,MA0022_1,MA0023,MA0023_1,MA0101,MA0101_1,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0778,MA0778_1,MA0778_2,MA1117,MA1117_1,MA1117_2,MA1457,MA1457_1,MA1457_2,MA1911,MA1911_1,MA1911_2,MA2108,MA2108_1,MA2213,MA2213_1,MA2264,MA2264_1
#Alternatives = HM0998,HM1188,MA0101,MA0101_1,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA1911,MA1911_1,MA1911_2,MA2264,MA2264_1
#HOCOMOCOv13 = NFKB1.H13CORE.0.PS.A
#UniProt = P19838,P25799
#HGNC = 7794
#GeneCards = NFKB1
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX
#Subtype = 0
#MGI = 97312
#Entrez = 4790,18033
368.0	84.0	257.0	162.0
16.0	8.0	819.0	28.0
5.0	0.0	858.0	8.0
6.0	0.0	857.0	8.0
641.0	5.0	222.0	3.0
806.0	28.0	34.0	3.0
841.0	19.0	10.0	1.0
132.0	123.0	237.0	379.0
50.0	368.0	9.0	444.0
75.0	788.0	1.0	7.0
10.0	855.0	2.0	4.0
45.0	793.0	21.0	12.0

#ID = HM0801
#Short = NFKB2
#Long = Nuclear factor NF-kappa-B p100 subunit
#W = 16
#Class = 6.1.1.1.2
#Factors = NFKB2,LYT10,DNA-binding factor KBF2,H2TF1,Lymphocyte translocation chromosome 10 protein,Nuclear factor of kappa light polypeptide gene enhancer in B-cells 2,Oncogene Lyt-10
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0800,HM0998,HM0999,HM1188,MA0101,MA0101_1,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA1117,MA1117_1,MA1117_2,MA1911,MA1911_1,MA1911_2,MA2264,MA2264_1
#Alternatives = MA0778,MA0778_1,MA0778_2
#HOCOMOCOv13 = NFKB2.H13CORE.0.PSM.A
#UniProt = Q00653,Q9WTK5
#HGNC = 7795
#GeneCards = NFKB2
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX,Methyl-HT-SELEX
#Subtype = 0
#MGI = 1099800
#Entrez = 4791,18034
2247.0	1641.0	2310.0	1826.0
3644.0	913.0	1724.0	1745.0
4697.0	585.0	1952.0	793.0
11.0	6.0	8004.0	6.0
1.0	1.0	8025.0	0.0
0.0	0.0	8002.0	25.0
2593.0	0.0	5410.0	24.0
7920.0	18.0	75.0	14.0
6302.0	120.0	92.0	1513.0
1334.0	493.0	1987.0	4213.0
871.0	3314.0	215.0	3627.0
2768.0	4937.0	110.0	212.0
145.0	7528.0	221.0	133.0
345.0	6357.0	767.0	558.0
1423.0	1374.0	1663.0	3564.0
1930.0	1730.0	1443.0	2922.0

#ID = M00052
#Short = V$NFKAPPAB65_01
#Long = NF-kappaB (nuclear factor kappa-light-chain-enhancer of activated B cells, p65)
#W = 10
#Factors = RelA-p65
#Organisms = rat (Rattus norvegicus),human (Homo sapiens),cattle (Bos taurus),mouse (Mus musculus)
#Interactions = HM0178,HM0194,HM0195,HM0253,HM0254,HM0255,HM0279,HM0320,HM0321,HM0334,HM0335,HM0336,HM0361,HM0362,HM0363,HM0364,HM0393,HM0394,HM0395,HM0454,HM0455,HM0502,HM0503,HM0624,HM0625,HM0800,HM0961,HM0962,HM0964,HM0965,HM0998,HM1026,HM1027,HM1028,HM1029,HM1104,HM1105,HM1106,HM1149,HM1188,HM1235,HM1236,M00008,M00024,M00033,M00040,M00041,M00050,M00051,M00052,M00053,M00054,M00056,M00109,M00116,M00117,M00139,M00159,M00172,M00173,M00174,M00179,M00188,M00190,M00191,M00192,M00193,M00194,M00196,M00199,M00201,M00205,M00208,M00216,M00235,M00236,M00237,M00242,M00243,M00245,M00246,M00249,M00252,M00311,M00320,M00425,M00426,M00427,M00428,M00430,M00431,M00432,M00471,M00512,M00515,M00516,M00517,M00518,M00528,M00539,MA0004,MA0004_1,MA0006,MA0006_1,MA0006_2,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0024,MA0024_1,MA0024_2,MA0024_3,MA0045,MA0061,MA0065,MA0065_1,MA0065_2,MA0065_3,MA0066,MA0066_1,MA0066_2,MA0074,MA0074_1,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0108,MA0108_1,MA0108_2,MA0108_3,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0115,MA0115_1,MA0133,MA0159,MA0159_1,MA0162,MA0162_1,MA0162_2,MA0162_3,MA0162_4,MA0162_5,MA0258,MA0258_1,MA0258_2,MA0259,MA0259_1,MA0259_2,MA0386,MA0386_1,MA0386_2,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0472,MA0472_1,MA0472_2,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0494,MA0494_1,MA0494_2,MA0512,MA0512_1,MA0512_2,MA0693_2,MA0732,MA0732_1,MA0732_2,MA0940,MA0940_1,MA1106,MA1106_1,MA1106_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1146,MA1146_1,MA1146_2,MA1147,MA1147_1,MA1147_2,MA1148,MA1148_1,MA1148_2,MA1849,MA1849_1,MA1849_2,MA1902,MA1902_1,MA1902_2,MA1911,MA1911_1,MA1911_2,MA1951,MA1951_1,MA1951_2,MA2264,MA2264_1,MA2279,MA2279_1,MA2338,MA2338_1
#Transfac class = C0020
0.0	4.0	10.0	4.0
0.0	0.0	18.0	0.0
0.0	0.0	18.0	0.0
11.0	0.0	7.0	0.0
10.0	3.0	3.0	2.0
2.0	0.0	0.0	16.0
0.0	0.0	0.0	18.0
0.0	3.0	0.0	15.0
0.0	18.0	0.0	0.0
0.0	18.0	0.0	0.0

#ID = M00053
#Short = V$CREL_01
#Long = c-Rel (c-Rel proto-oncogene protein, REL=reticuloendotheliosis viral oncogene) an (NF-kB family member)
#W = 10
#Class = 6.1.1.2.3
#Factors = c-Rel
#Organisms = clawed frog (Xenopus laevis),chick (Gallus gallus),human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0253,HM0254,HM0255,HM0279,HM0367,HM0368,HM0369,HM0370,HM0388,HM0393,HM0394,HM0395,HM0592,HM0593,HM0603,HM0604,HM0624,HM0625,HM0777,HM0778,HM0779,HM0780,HM0781,HM0800,HM0998,HM1124,HM1125,HM1126,HM1149,HM1188,M00041,M00051,M00052,M00053,M00054,M00062,M00063,M00109,M00116,M00117,M00172,M00173,M00174,M00188,M00194,M00199,M00208,M00216,M00252,M00258,M00302,M00311,M00320,M00339,M00340,M00453,M00471,M00517,M00531,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0045,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0051,MA0051_1,MA0051_2,MA0061,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0108,MA0108_1,MA0108_2,MA0108_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0386,MA0386_1,MA0386_2,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0772,MA0772_1,MA0772_2,MA0940,MA0940_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1484,MA1484_1,MA1484_2,MA1849,MA1849_1,MA1849_2,MA1902,MA1902_1,MA1902_2,MA1911,MA1911_1,MA1911_2,MA1951,MA1951_1,MA1951_2,MA2264,MA2264_1
#Transfac class = C0020
0.0	5.0	8.0	4.0
0.0	0.0	16.0	1.0
1.0	0.0	15.0	1.0
5.0	1.0	9.0	2.0
6.0	5.0	3.0	3.0
5.0	1.0	1.0	10.0
1.0	0.0	0.0	16.0
2.0	0.0	0.0	15.0
0.0	15.0	0.0	2.0
1.0	16.0	0.0	0.0

#ID = M00054
#Short = V$NFKAPPAB_01
#Long = NF-kappaB (nuclear factor kappa-light-chain-enhancer of activated B cells)
#W = 10
#Factors = NF-kappaB,NF-kappaB1-p50,RelA-p65
#Organisms = human (Homo sapiens),rat (Rattus norvegicus),mouse (Mus musculus)
#Interactions = HM0178,HM0194,HM0195,HM0207,HM0208,HM0209,HM0210,HM0253,HM0254,HM0255,HM0279,HM0320,HM0321,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0393,HM0394,HM0395,HM0454,HM0455,HM0502,HM0503,HM0624,HM0625,HM0800,HM0961,HM0962,HM0964,HM0965,HM0998,HM1026,HM1027,HM1028,HM1029,HM1104,HM1105,HM1106,HM1124,HM1125,HM1126,HM1149,HM1188,HM1235,HM1236,M00008,M00024,M00033,M00040,M00041,M00050,M00051,M00052,M00053,M00054,M00056,M00109,M00116,M00117,M00139,M00159,M00172,M00173,M00174,M00179,M00188,M00190,M00191,M00192,M00193,M00194,M00196,M00199,M00201,M00205,M00208,M00216,M00235,M00236,M00237,M00242,M00249,M00252,M00311,M00320,M00339,M00425,M00426,M00427,M00428,M00430,M00431,M00471,M00512,M00513,M00515,M00516,M00517,M00518,M00528,M00531,M00539,MA0004,MA0004_1,MA0006,MA0006_1,MA0006_2,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0024,MA0024_1,MA0024_2,MA0024_3,MA0045,MA0061,MA0065,MA0065_1,MA0065_2,MA0065_3,MA0066,MA0066_1,MA0066_2,MA0074,MA0074_1,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0108,MA0108_1,MA0108_2,MA0108_3,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0115,MA0115_1,MA0133,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0159,MA0159_1,MA0258,MA0258_1,MA0258_2,MA0259,MA0259_1,MA0259_2,MA0386,MA0386_1,MA0386_2,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0494,MA0494_1,MA0494_2,MA0512,MA0512_1,MA0512_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0693_2,MA0940,MA0940_1,MA1106,MA1106_1,MA1106_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1146,MA1146_1,MA1146_2,MA1147,MA1147_1,MA1147_2,MA1148,MA1148_1,MA1148_2,MA1849,MA1849_1,MA1849_2,MA1902,MA1902_1,MA1902_2,MA1911,MA1911_1,MA1911_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2193,MA2193_1,MA2264,MA2264_1,MA2279,MA2279_1,MA2338,MA2338_1
#Transfac class = C0020
0.0	0.0	40.0	0.0
0.0	0.0	40.0	0.0
1.0	0.0	39.0	0.0
27.0	0.0	13.0	0.0
21.0	13.0	1.0	5.0
8.0	1.0	3.0	28.0
1.0	2.0	2.0	35.0
2.0	18.0	0.0	20.0
3.0	36.0	0.0	1.0
0.0	38.0	0.0	2.0

#ID = M00051
#Short = V$NFKAPPAB50_01
#Long = NF-kappaB (nuclear factor kappa-light-chain-enhancer of activated B cells, p50)
#W = 10
#Factors = NF-kappaB1-p50
#Organisms = human (Homo sapiens)
#Interactions = HM0207,HM0208,HM0209,HM0210,HM0253,HM0254,HM0255,HM0279,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0800,HM0998,HM1124,HM1125,HM1126,HM1188,M00040,M00041,M00051,M00052,M00053,M00054,M00109,M00116,M00117,M00159,M00179,M00190,M00191,M00194,M00201,M00208,M00249,M00339,M00513,M00531,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0061,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0605,MA0605_1,MA0605_2,MA0605_3,MA1849,MA1849_1,MA1849_2,MA1902,MA1902_1,MA1902_2,MA1911,MA1911_1,MA1911_2,MA1988,MA1988_1,MA1988_2,MA2193,MA2193_1,MA2264,MA2264_1
#Transfac class = C0020
0.0	0.0	18.0	0.0
0.0	0.0	18.0	0.0
0.0	0.0	18.0	0.0
2.0	0.0	16.0	0.0
16.0	1.0	0.0	1.0
0.0	0.0	3.0	15.0
0.0	7.0	1.0	10.0
0.0	16.0	0.0	2.0
0.0	18.0	0.0	0.0
0.0	17.0	1.0	0.0

#ID = MA2264
#Short = Rel
#Long = Nuclear factor NF-kappa-B p110 subunit
#W = 11
#Class = 6.1.1.2.3
#Factors = Rel,NFKB1
#Organisms = fruit fly (Drosophila melanogaster)
#Interactions = HM0031,HM0084,HM0094,HM0225,HM0226,HM0227,HM0236,HM0309,HM0358,HM0360,HM0432,HM0771,HM0772,HM0801,HM0998,HM1046,HM1047,HM1188,HM1217,HM1261,HM1300,HM1301,HM1302,HM1407,HM1455,HM1465,HM1536,HM1590,HM1591,M00008,M00024,M00033,M00040,M00041,M00043,M00050,M00051,M00052,M00053,M00054,M00056,M00062,M00109,M00114,M00115,M00116,M00117,M00120,M00139,M00159,M00172,M00179,M00190,M00191,M00192,M00193,M00194,M00196,M00201,M00205,M00208,M00216,M00235,M00237,M00242,M00243,M00249,M00252,M00302,M00340,M00428,M00430,M00431,M00432,M00448,M00471,M00472,M00476,M00513,M00516,M00517,M00518,MA0022,MA0022_1,MA0023,MA0023_1,MA0101,MA0101_1,MA0107,MA0107_1,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0463,MA0463_1,MA0463_2,MA0463_3,MA0592,MA0592_1,MA0592_2,MA0592_3,MA0592_4,MA0610,MA0610_1,MA0610_2,MA0635,MA0635_1,MA0635_2,MA0643,MA0643_1,MA0643_2,MA0696,MA0696_1,MA0778,MA0778_1,MA0778_2,MA0848,MA0848_1,MA1024,MA1024_1,MA1024_2,MA1118,MA1118_1,MA1118_2,MA1457,MA1457_1,MA1457_2,MA1716,MA1716_1,MA1716_2,MA1727,MA1727_1,MA1727_2,MA1911,MA1911_1,MA1911_2,MA2108,MA2108_1,MA2213,MA2213_1,MA2264,MA2264_1
#Alternatives = HM0800,HM0998,HM1188,MA0101,MA0101_1,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA1911,MA1911_1,MA1911_2,MA2264_1
#UniProt = Q94527
#Jaspar = MA2264.1
#Evidence = SELEX
#PubMed = 14585984
5.0	26.0	910.0	57.0
7.0	0.0	992.0	0.0
0.0	9.0	936.0	54.0
0.0	1.0	993.0	5.0
118.0	17.0	856.0	6.0
64.0	1.0	0.0	933.0
0.0	0.0	0.0	1000.0
3.0	986.0	6.0	4.0
37.0	962.0	0.0	0.0
4.0	995.0	0.0	0.0
5.0	983.0	0.0	11.0

#ID = HM1188
#Short = TF65
#Long = Transcription factor p65
#W = 13
#Class = 6.1.1.2.1
#Factors = TF65,NFKB3,Nuclear factor NF-kappa-B p65 subunit,Nuclear factor of kappa light polypeptide gene enhancer in B-cells 3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0027,HM0207,HM0208,HM0209,HM0210,HM0361,HM0362,HM0456,HM0599,HM0600,HM0621,HM0622,HM0654,HM0655,HM0771,HM0772,HM0800,HM0801,HM0854,HM0855,HM0998,HM0999,HM1048,HM1049,HM1050,HM1066,HM1140,HM1188,M00008,M00024,M00033,M00040,M00041,M00050,M00051,M00052,M00053,M00054,M00056,M00062,M00109,M00114,M00115,M00116,M00117,M00139,M00159,M00172,M00179,M00190,M00191,M00192,M00193,M00194,M00196,M00201,M00205,M00208,M00216,M00225,M00235,M00237,M00242,M00243,M00249,M00250,M00252,M00302,M00340,M00428,M00430,M00431,M00432,M00471,M00497,M00513,M00516,M00517,M00518,MA0038,MA0038_1,MA0038_2,MA0038_3,MA0101,MA0101_1,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0160,MA0160_1,MA0160_2,MA0160_3,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0778,MA0778_1,MA0778_2,MA0830,MA0830_1,MA0830_2,MA0830_3,MA1112,MA1112_1,MA1112_2,MA1112_3,MA1117,MA1117_1,MA1117_2,MA1119,MA1119_1,MA1119_2,MA1420,MA1420_1,MA1517,MA1517_1,MA1517_2,MA1558,MA1558_1,MA1558_2,MA1911,MA1911_1,MA1911_2,MA1988,MA1988_1,MA1988_2,MA2154,MA2154_1,MA2193,MA2193_1,MA2264,MA2264_1
#Alternatives = HM0800,HM0998,MA0101,MA0101_1,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA1911,MA1911_1,MA1911_2,MA2264,MA2264_1
#HOCOMOCOv13 = TF65.H13CORE.0.P.B
#UniProt = Q04206,Q04207
#HGNC = 9955
#GeneCards = RELA
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 103290
#Entrez = 5970,19697
174.0	360.0	169.0	296.0
79.0	83.0	558.0	279.0
16.0	4.0	971.0	8.0
20.0	4.0	908.0	67.0
661.0	19.0	287.0	32.0
476.0	222.0	160.0	141.0
0.0	37.0	0.0	962.0
4.0	43.0	37.0	915.0
9.0	272.0	14.0	704.0
6.0	973.0	4.0	16.0
7.0	969.0	5.0	18.0
256.0	566.0	69.0	108.0
362.0	169.0	285.0	183.0

#ID = MA1130
#Short = FOSL2::JUN
#Long = Transcription factor Jun::Fos-related antigen 2
#W = 9
#Class = 1.1.1.1.1
#Factors = JUN,FOSL2
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0203,HM0204,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0221,HM0222,HM0231,HM0232,HM0233,HM0234,HM0235,HM0260,HM0261,HM0262,HM0280,HM0281,HM0282,HM0295,HM0367,HM0368,HM0393,HM0394,HM0395,HM0399,HM0400,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0678,HM0679,HM0706,HM0707,HM0725,HM0771,HM0772,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM1058,HM1059,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00490,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0604,MA0604_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0624,MA0624_1,MA0624_2,MA0624_3,MA0638,MA0638_1,MA0638_2,MA0705,MA0705_1,MA0705_2,MA0706,MA0706_1,MA0706_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1101,MA1101_1,MA1101_2,MA1101_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1470,MA1470_1,MA1470_2,MA1522,MA1522_1,MA1522_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1951,MA1951_1,MA1951_2,MA1964,MA1964_1,MA1964_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0400,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130_2,MA1130_1,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1141,MA1141_1,MA1141_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1951,MA1951_1,MA1951_2
#UniProt = P05412,P15408
#Jaspar = MA1130.2
#DimerClass = 1.1.2.1.4
#Evidence = SMiLE-seq
#PubMed = 11988758
542.0	121.0	282.0	55.0
1.0	1.0	1.0	998.0
1.0	1.0	840.0	158.0
847.0	123.0	1.0	29.0
103.0	141.0	698.0	58.0
1.0	1.0	1.0	998.0
20.0	979.0	1.0	1.0
998.0	0.0	1.0	1.0
19.0	299.0	93.0	589.0

#ID = MA1131
#Short = FOSL2::JUN
#Long = Transcription factor Jun::Fos-related antigen 2
#W = 10
#Class = 1.1.1.1.1
#Factors = JUN,FOSL2
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0203,HM0204,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0221,HM0222,HM0231,HM0232,HM0233,HM0234,HM0235,HM0260,HM0261,HM0262,HM0280,HM0281,HM0282,HM0295,HM0367,HM0368,HM0393,HM0394,HM0395,HM0399,HM0400,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0678,HM0679,HM0706,HM0707,HM0725,HM0771,HM0772,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM1058,HM1059,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00490,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0604,MA0604_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0624,MA0624_1,MA0624_2,MA0624_3,MA0638,MA0638_1,MA0638_2,MA0705,MA0705_1,MA0705_2,MA0706,MA0706_1,MA0706_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1101,MA1101_1,MA1101_2,MA1101_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1470,MA1470_1,MA1470_2,MA1522,MA1522_1,MA1522_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1951,MA1951_1,MA1951_2,MA1964,MA1964_1,MA1964_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0400,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131_2,MA1131_1,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1141,MA1141_1,MA1141_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1951,MA1951_1,MA1951_2
#UniProt = P05412,P15408
#Jaspar = MA1131.2
#DimerClass = 1.1.2.1.4
#Evidence = SMiLE-seq
#PubMed = 11988758
633.0	30.0	323.0	15.0
6.0	8.0	8.0	978.0
7.0	14.0	917.0	62.0
963.0	6.0	9.0	23.0
11.0	906.0	22.0	61.0
92.0	45.0	845.0	17.0
14.0	70.0	9.0	908.0
351.0	625.0	16.0	8.0
961.0	10.0	13.0	15.0
38.0	218.0	166.0	578.0

#ID = MA1134
#Short = FOS::JUNB
#Long = Protein c-Fos::Transcription factor JunB
#W = 9
#Class = 1.1.2.1.1
#Factors = FOS,JUNB
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0253,HM0260,HM0261,HM0262,HM0281,HM0282,HM0295,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,HM0400,HM0623,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0643,HM0644,HM0694,HM0695,HM0706,HM0707,HM0841,HM0842,HM0843,HM1137,HM1138,HM1324,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0029,MA0029_1,MA0029_2,MA0099_2,MA0099_3,MA0099_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0517,MA0517_1,MA0517_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0655,MA0655_1,MA0656,MA0656_1,MA0656_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1513,MA1513_1,MA1513_2,MA1522,MA1522_1,MA1522_2,MA1534,MA1534_1,MA1534_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1858,MA1858_1,MA1858_2,MA1890,MA1890_1,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0624,HM0625,HM0626,HM0627,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0490,MA0490_1,MA0490_2,MA0490_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134_2,MA1134_1,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#UniProt = P01100,P17275
#Jaspar = MA1134.2
#DimerClass = 1.1.1.1.2
#Evidence = SMiLE-seq
#PubMed = 11988758
593.0	105.0	267.0	36.0
1.0	1.0	1.0	998.0
1.0	1.0	868.0	131.0
965.0	30.0	1.0	4.0
48.0	309.0	618.0	25.0
1.0	1.0	3.0	996.0
27.0	971.0	1.0	1.0
998.0	1.0	1.0	1.0
7.0	284.0	51.0	658.0

#ID = MA1135
#Short = FOSB::JUNB
#Long = Transcription factor JunB::Protein FosB
#W = 9
#Class = 1.1.1.1.2
#Factors = JUNB,FOSB
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0281,HM0282,HM0295,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,HM0400,HM0436,HM0467,HM0623,HM0626,HM0627,HM0771,HM0772,HM0960,HM1217,HM1239,HM1240,M00513,M00514,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0655,MA0655_1,MA0656,MA0656_1,MA0656_2,MA0736,MA0736_1,MA0793,MA0793_1,MA0793_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA0850,MA0850_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1578,MA1578_1,MA1578_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1858,MA1858_1,MA1858_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0396,HM0397,HM0398,HM0626,HM0627,MA0490,MA0490_1,MA0490_2,MA0490_3,MA1127,MA1127_1,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135_2,MA1135_1,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3
#UniProt = P17275,P53539
#Jaspar = MA1135.2
#DimerClass = 1.1.2.1.2
#Evidence = SMiLE-seq
#PubMed = 11988758
598.0	61.0	321.0	20.0
1.0	0.0	1.0	998.0
1.0	0.0	980.0	19.0
997.0	1.0	1.0	1.0
34.0	596.0	309.0	61.0
2.0	1.0	39.0	958.0
191.0	808.0	1.0	1.0
998.0	0.0	1.0	1.0
37.0	259.0	126.0	578.0

#ID = MA1136
#Short = FOSB::JUNB
#Long = Transcription factor JunB::Protein FosB
#W = 10
#Class = 1.1.1.1.2
#Factors = JUNB,FOSB
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0281,HM0282,HM0295,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,HM0400,HM0436,HM0467,HM0623,HM0626,HM0627,HM0771,HM0772,HM0960,HM1217,HM1239,HM1240,M00513,M00514,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0655,MA0655_1,MA0656,MA0656_1,MA0656_2,MA0736,MA0736_1,MA0793,MA0793_1,MA0793_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA0850,MA0850_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1578,MA1578_1,MA1578_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1858,MA1858_1,MA1858_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0396,HM0397,HM0398,HM0626,HM0627,MA0490,MA0490_1,MA0490_2,MA0490_3,MA1127,MA1127_1,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3
#UniProt = P17275,P53539
#Jaspar = MA1136.1
#DimerClass = 1.1.2.1.2
#Evidence = SMiLE-seq
#PubMed = 11988758
561.0	59.0	368.0	12.0
30.0	36.0	16.0	917.0
13.0	46.0	700.0	242.0
869.0	44.0	60.0	28.0
30.0	842.0	27.0	101.0
52.0	35.0	893.0	20.0
56.0	80.0	28.0	836.0
173.0	776.0	36.0	15.0
923.0	16.0	30.0	31.0
11.0	260.0	65.0	664.0

#ID = MA1137
#Short = FOSL1::JUNB
#Long = Fos-related antigen 1::Transcription factor JunB
#W = 9
#Class = 1.1.2.1.3
#Factors = FOSL1,JUNB
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0281,HM0282,HM0295,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,HM0400,HM0623,HM0624,HM0625,HM0626,HM0627,HM1231,M00513,M00514,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0655,MA0655_1,MA0656,MA0656_1,MA0656_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1858,MA1858_1,MA1858_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0399,HM0626,HM0627,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137_2,MA1137_1,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2
#UniProt = P15407,P17275
#Jaspar = MA1137.2
#DimerClass = 1.1.1.1.2
#Evidence = SMiLE-seq
#PubMed = 11988758
566.0	100.0	287.0	47.0
23.0	16.0	16.0	945.0
36.0	21.0	880.0	63.0
917.0	20.0	21.0	42.0
63.0	626.0	198.0	113.0
59.0	23.0	115.0	803.0
271.0	683.0	9.0	37.0
904.0	21.0	38.0	37.0
53.0	225.0	170.0	552.0

#ID = MA1138
#Short = FOSL2::JUNB
#Long = Fos-related antigen 2::Transcription factor JunB
#W = 9
#Class = 1.1.2.1.4
#Factors = FOSL2,JUNB
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0221,HM0222,HM0231,HM0232,HM0233,HM0234,HM0235,HM0281,HM0282,HM0295,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,HM0400,HM0623,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0678,HM0679,HM0725,HM0771,HM0772,M00490,M00513,M00514,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0655,MA0655_1,MA0656,MA0656_1,MA0656_2,MA0705,MA0705_1,MA0705_2,MA0706,MA0706_1,MA0706_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1101,MA1101_1,MA1101_2,MA1101_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1470,MA1470_1,MA1470_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1858,MA1858_1,MA1858_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0400,HM0626,HM0627,MA0478,MA0478_1,MA0478_2,MA0490,MA0490_1,MA0490_2,MA0490_3,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138_2,MA1138_1,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2
#UniProt = P15408,P17275
#Jaspar = MA1138.2
#DimerClass = 1.1.1.1.2
#Evidence = SMiLE-seq
#PubMed = 11988758
621.0	53.0	314.0	13.0
0.0	0.0	0.0	999.0
0.0	0.0	985.0	14.0
999.0	0.0	0.0	0.0
54.0	568.0	292.0	85.0
1.0	0.0	26.0	973.0
168.0	831.0	0.0	0.0
999.0	0.0	0.0	0.0
35.0	251.0	112.0	602.0

#ID = MA1139
#Short = FOSL2::JUNB
#Long = Fos-related antigen 2::Transcription factor JunB
#W = 10
#Class = 1.1.2.1.4
#Factors = FOSL2,JUNB
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0221,HM0222,HM0231,HM0232,HM0233,HM0234,HM0235,HM0281,HM0282,HM0295,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,HM0400,HM0623,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0678,HM0679,HM0725,HM0771,HM0772,M00490,M00513,M00514,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0655,MA0655_1,MA0656,MA0656_1,MA0656_2,MA0705,MA0705_1,MA0705_2,MA0706,MA0706_1,MA0706_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1101,MA1101_1,MA1101_2,MA1101_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1470,MA1470_1,MA1470_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1858,MA1858_1,MA1858_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0400,HM0626,HM0627,MA0478,MA0478_1,MA0478_2,MA0490,MA0490_1,MA0490_2,MA0490_3,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139_2,MA1139_1,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2
#UniProt = P15408,P17275
#Jaspar = MA1139.2
#DimerClass = 1.1.1.1.2
#Evidence = SMiLE-seq
#PubMed = 11988758
638.0	65.0	268.0	29.0
8.0	17.0	6.0	969.0
12.0	21.0	780.0	187.0
972.0	5.0	13.0	10.0
10.0	899.0	17.0	74.0
74.0	16.0	900.0	10.0
10.0	12.0	6.0	972.0
186.0	778.0	23.0	13.0
968.0	5.0	19.0	8.0
28.0	266.0	67.0	639.0

#ID = MA1141
#Short = FOS::JUND
#Long = Protein c-Fos::Transcription factor JunD
#W = 9
#Class = 1.1.2.1.1
#Factors = FOS,JUND
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0253,HM0260,HM0261,HM0262,HM0281,HM0282,HM0295,HM0393,HM0394,HM0395,HM0400,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0643,HM0644,HM0694,HM0695,HM0706,HM0707,HM0841,HM0842,HM0843,HM1137,HM1138,HM1324,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0029,MA0029_1,MA0029_2,MA0099_2,MA0099_3,MA0099_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0517,MA0517_1,MA0517_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1513,MA1513_1,MA1513_2,MA1522,MA1522_1,MA1522_2,MA1534,MA1534_1,MA1534_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1890,MA1890_1,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0624,HM0625,HM0628,HM0629,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141_2,MA1141_1,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1951,MA1951_1,MA1951_2
#UniProt = P01100,P17535
#Jaspar = MA1141.2
#DimerClass = 1.1.1.1.3
#Evidence = SMiLE-seq
#PubMed = 11988758
593.0	104.0	266.0	38.0
0.0	1.0	0.0	999.0
0.0	0.0	871.0	129.0
894.0	91.0	0.0	15.0
75.0	40.0	867.0	19.0
0.0	0.0	0.0	999.0
29.0	970.0	0.0	0.0
999.0	0.0	0.0	0.0
21.0	290.0	77.0	612.0

#ID = MA1142
#Short = FOSL1::JUND
#Long = Fos-related antigen 1::Transcription factor JunD
#W = 8
#Class = 1.1.2.1.3
#Factors = FOSL1,JUND
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0281,HM0282,HM0393,HM0394,HM0395,HM0400,HM0624,HM0625,HM0626,HM0627,HM1231,M00513,M00514,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0399,HM0628,HM0629,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1137,MA1137_1,MA1137_2,MA1141,MA1141_1,MA1141_2,MA1142_2,MA1142_1,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2
#UniProt = P15407,P17535
#Jaspar = MA1142.2
#DimerClass = 1.1.1.1.3
#Evidence = SMiLE-seq
#PubMed = 11988758
551.0	127.0	282.0	40.0
30.0	23.0	34.0	913.0
22.0	61.0	777.0	140.0
864.0	12.0	82.0	41.0
49.0	581.0	191.0	180.0
98.0	45.0	187.0	669.0
270.0	641.0	25.0	64.0
912.0	40.0	17.0	31.0

#ID = MA1143
#Short = FOSL1::JUND
#Long = Fos-related antigen 1::Transcription factor JunD
#W = 9
#Class = 1.1.2.1.3
#Factors = FOSL1,JUND
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0281,HM0282,HM0393,HM0394,HM0395,HM0400,HM0624,HM0625,HM0626,HM0627,HM1231,M00513,M00514,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0399,HM0628,HM0629,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1137,MA1137_1,MA1137_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143_2,MA1143_1,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2
#UniProt = P15407,P17535
#Jaspar = MA1143.2
#DimerClass = 1.1.1.1.3
#Evidence = SMiLE-seq
#PubMed = 11988758
561.0	75.0	324.0	40.0
36.0	50.0	44.0	870.0
39.0	101.0	777.0	82.0
870.0	45.0	41.0	44.0
32.0	835.0	64.0	68.0
116.0	59.0	649.0	176.0
117.0	262.0	39.0	582.0
546.0	330.0	83.0	41.0
645.0	66.0	100.0	188.0

#ID = MA1144
#Short = FOSL2::JUND
#Long = Fos-related antigen 2::Transcription factor JunD
#W = 9
#Class = 1.1.2.1.4
#Factors = FOSL2,JUND
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0216,HM0221,HM0222,HM0231,HM0232,HM0233,HM0234,HM0235,HM0281,HM0282,HM0295,HM0393,HM0394,HM0395,HM0400,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0678,HM0679,HM0725,HM0771,HM0772,M00490,M00513,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0705,MA0705_1,MA0705_2,MA0706,MA0706_1,MA0706_2,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1101,MA1101_1,MA1101_2,MA1101_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1470,MA1470_1,MA1470_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0400,HM0628,HM0629,MA0478,MA0478_1,MA0478_2,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144_2,MA1144_1,MA1145,MA1145_1,MA1145_2
#UniProt = P15408,P17535
#Jaspar = MA1144.2
#DimerClass = 1.1.1.1.3
#Evidence = SMiLE-seq
#PubMed = 11988758
634.0	60.0	291.0	14.0
0.0	0.0	0.0	999.0
0.0	0.0	990.0	10.0
998.0	1.0	0.0	0.0
46.0	604.0	292.0	58.0
6.0	0.0	60.0	934.0
140.0	860.0	0.0	0.0
999.0	0.0	0.0	0.0
38.0	266.0	113.0	583.0

#ID = MA1145
#Short = FOSL2::JUND
#Long = Fos-related antigen 2::Transcription factor JunD
#W = 10
#Class = 1.1.2.1.4
#Factors = FOSL2,JUND
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0216,HM0221,HM0222,HM0231,HM0232,HM0233,HM0234,HM0235,HM0281,HM0282,HM0295,HM0393,HM0394,HM0395,HM0400,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0678,HM0679,HM0725,HM0771,HM0772,M00490,M00513,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0705,MA0705_1,MA0705_2,MA0706,MA0706_1,MA0706_2,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1101,MA1101_1,MA1101_2,MA1101_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1470,MA1470_1,MA1470_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0400,HM0628,HM0629,MA0478,MA0478_1,MA0478_2,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145_2,MA1145_1
#UniProt = P15408,P17535
#Jaspar = MA1145.2
#DimerClass = 1.1.1.1.3
#Evidence = SMiLE-seq
#PubMed = 11988758
559.0	45.0	340.0	57.0
26.0	27.0	10.0	937.0
7.0	46.0	678.0	268.0
943.0	6.0	31.0	20.0
12.0	911.0	35.0	41.0
135.0	15.0	823.0	28.0
28.0	12.0	10.0	950.0
33.0	942.0	15.0	11.0
972.0	6.0	11.0	11.0
23.0	345.0	55.0	577.0

#ID = MA1126
#Short = FOS::JUN
#Long = Protein c-Fos::Transcription factor Jun
#W = 10
#Class = 1.1.2.1.1
#Factors = FOS,JUN
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0203,HM0204,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0253,HM0260,HM0261,HM0262,HM0280,HM0281,HM0282,HM0295,HM0367,HM0368,HM0393,HM0394,HM0395,HM0399,HM0400,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0643,HM0644,HM0694,HM0695,HM0706,HM0707,HM0771,HM0772,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM0841,HM0842,HM0843,HM1058,HM1059,HM1137,HM1138,HM1324,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0029,MA0029_1,MA0029_2,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099_2,MA0099_3,MA0099_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0517,MA0517_1,MA0517_2,MA0604,MA0604_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0624,MA0624_1,MA0624_2,MA0624_3,MA0638,MA0638_1,MA0638_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1513,MA1513_1,MA1513_2,MA1522,MA1522_1,MA1522_2,MA1534,MA1534_1,MA1534_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1890,MA1890_1,MA1951,MA1951_1,MA1951_2,MA1964,MA1964_1,MA1964_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126_2,MA1126_1,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#UniProt = P01100,P05412
#Jaspar = MA1126.2
#DimerClass = 1.1.1.1.1
#Evidence = SMiLE-seq
#PubMed = 11988758
556.0	45.0	369.0	30.0
47.0	74.0	62.0	816.0
42.0	112.0	655.0	191.0
748.0	31.0	135.0	86.0
80.0	838.0	41.0	41.0
131.0	114.0	722.0	34.0
40.0	23.0	32.0	905.0
53.0	846.0	44.0	57.0
907.0	24.0	36.0	33.0
30.0	234.0	60.0	676.0

#ID = MA1127
#Short = FOSB::JUN
#Long = Transcription factor Jun::Protein FosB
#W = 11
#Class = 1.1.1.1.1
#Factors = JUN,FOSB
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0203,HM0204,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0260,HM0261,HM0262,HM0280,HM0281,HM0282,HM0367,HM0368,HM0393,HM0394,HM0395,HM0399,HM0400,HM0436,HM0467,HM0624,HM0625,HM0626,HM0627,HM0706,HM0707,HM0771,HM0772,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM0960,HM1058,HM1059,HM1217,HM1239,HM1240,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0604,MA0604_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0624,MA0624_1,MA0624_2,MA0624_3,MA0638,MA0638_1,MA0638_2,MA0736,MA0736_1,MA0793,MA0793_1,MA0793_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA0850,MA0850_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1522,MA1522_1,MA1522_2,MA1578,MA1578_1,MA1578_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1951,MA1951_1,MA1951_2,MA1964,MA1964_1,MA1964_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#UniProt = P05412,P53539
#Jaspar = MA1127.1
#DimerClass = 1.1.2.1.2
#Evidence = SMiLE-seq
#PubMed = 11988758
193.0	70.0	575.0	162.0
649.0	87.0	216.0	48.0
12.0	10.0	12.0	965.0
17.0	10.0	872.0	100.0
954.0	8.0	17.0	20.0
48.0	886.0	25.0	42.0
75.0	14.0	897.0	14.0
25.0	57.0	14.0	904.0
247.0	697.0	20.0	36.0
949.0	16.0	14.0	21.0
92.0	261.0	53.0	593.0

#ID = MA1128
#Short = FOSL1::JUN
#Long = Transcription factor Jun::Fos-related antigen 1
#W = 9
#Class = 1.1.1.1.1
#Factors = JUN,FOSL1
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0203,HM0204,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0260,HM0261,HM0262,HM0280,HM0281,HM0282,HM0367,HM0368,HM0393,HM0394,HM0395,HM0399,HM0400,HM0624,HM0625,HM0626,HM0627,HM0706,HM0707,HM0771,HM0772,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM1058,HM1059,HM1231,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0604,MA0604_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0624,MA0624_1,MA0624_2,MA0624_3,MA0638,MA0638_1,MA0638_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1522,MA1522_1,MA1522_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1951,MA1951_1,MA1951_2,MA1964,MA1964_1,MA1964_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0399,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128_2,MA1128_1,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1137,MA1137_1,MA1137_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1951,MA1951_1,MA1951_2
#UniProt = P05412,P15407
#Jaspar = MA1128.2
#DimerClass = 1.1.2.1.3
#Evidence = SMiLE-seq
#PubMed = 11988758
602.0	89.0	283.0	26.0
1.0	2.0	1.0	996.0
3.0	2.0	957.0	38.0
994.0	2.0	2.0	3.0
26.0	826.0	51.0	97.0
33.0	2.0	140.0	826.0
159.0	835.0	2.0	4.0
984.0	4.0	9.0	4.0
57.0	245.0	119.0	579.0

#ID = MA1129
#Short = FOSL1::JUN
#Long = Transcription factor Jun::Fos-related antigen 1
#W = 10
#Class = 1.1.1.1.1
#Factors = JUN,FOSL1
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0203,HM0204,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0260,HM0261,HM0262,HM0280,HM0281,HM0282,HM0367,HM0368,HM0393,HM0394,HM0395,HM0399,HM0400,HM0624,HM0625,HM0626,HM0627,HM0706,HM0707,HM0771,HM0772,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM1058,HM1059,HM1231,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0604,MA0604_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0624,MA0624_1,MA0624_2,MA0624_3,MA0638,MA0638_1,MA0638_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1522,MA1522_1,MA1522_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1951,MA1951_1,MA1951_2,MA1964,MA1964_1,MA1964_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0399,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1137,MA1137_1,MA1137_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1951,MA1951_1,MA1951_2
#UniProt = P05412,P15407
#Jaspar = MA1129.1
#DimerClass = 1.1.2.1.3
#Evidence = SMiLE-seq
#PubMed = 11988758
639.0	69.0	266.0	26.0
28.0	30.0	24.0	919.0
33.0	56.0	672.0	240.0
825.0	26.0	106.0	43.0
22.0	845.0	38.0	95.0
93.0	36.0	847.0	24.0
41.0	105.0	27.0	827.0
238.0	670.0	58.0	35.0
917.0	22.0	31.0	30.0
24.0	264.0	71.0	641.0

#ID = MA1951
#Short = FOS
#Long = Protein c-Fos
#W = 13
#Class = 1.1.2.1.1
#Factors = FOS
#Organisms = human (Homo sapiens)
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0253,HM0260,HM0261,HM0262,HM0281,HM0282,HM0295,HM0363,HM0364,HM0393,HM0394,HM0395,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0643,HM0644,HM0694,HM0695,HM0706,HM0707,HM0841,HM0842,HM0843,HM1137,HM1138,HM1324,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0029,MA0029_1,MA0029_2,MA0099_2,MA0099_3,MA0099_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0258,MA0258_1,MA0258_2,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0517,MA0517_1,MA0517_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1513,MA1513_1,MA1513_2,MA1522,MA1522_1,MA1522_2,MA1534,MA1534_1,MA1534_2,MA1632,MA1632_1,MA1632_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1890,MA1890_1,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1951_2,MA1951_1
#UniProt = P01100
#Jaspar = MA1951.2
#Evidence = HT-SELEX
#PubMed = 2511004
262.0	364.0	1283.0	394.0
1519.0	77.0	517.0	33.0
3.0	10.0	16.0	1675.0
39.0	38.0	1647.0	60.0
1672.0	14.0	35.0	4.0
10.0	1663.0	2.0	80.0
50.0	2.0	1666.0	14.0
24.0	0.0	29.0	1669.0
110.0	1634.0	22.0	30.0
1671.0	0.0	18.0	0.0
19.0	345.0	49.0	1549.0
253.0	1515.0	152.0	145.0
847.0	73.0	805.0	51.0

#ID = M00173
#Short = V$AP1_Q2
#Long = AP-1 (activator protein 1)
#W = 11
#Quality = 2
#Factors = AP-1
#Organisms = gibbon ape (Hylobates lar),human (Homo sapiens),clawed frog (Xenopus),hamster (Cricetulus sp),mouse (Mus musculus),chick (Gallus gallus),rat (Rattus norvegicus),monkey (Cercopithecus aethiops)
#Interactions = HM0367,HM0368,HM0369,HM0370,HM0388,HM0454,HM0455,HM1018,HM1124,HM1125,HM1126,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00042,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00311,M00320,M00338,M00339,M00340,M00396,M00418,M00447,M00454,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00531,M00538,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0554,MA0554_1,MA0554_2,MA0555,MA0555_1,MA0555_2,MA0563,MA0563_1,MA0563_2,MA0584,MA0584_1,MA0584_2,MA1035,MA1035_1,MA1062,MA1062_1,MA1062_2,MA1062_3,MA1283,MA1283_1,MA1283_2,MA1484,MA1484_1,MA1484_2,MA2286,MA2286_1
#Alternatives = M00174,M00188,M00199,M00517,MA0940,MA0940_1
#Transfac class = C0008
6.0	1.0	7.0	0.0
3.0	5.0	6.0	0.0
0.0	0.0	0.0	14.0
0.0	0.0	14.0	0.0
14.0	0.0	0.0	0.0
0.0	13.0	0.0	1.0
2.0	1.0	2.0	9.0
4.0	6.0	2.0	2.0
8.0	4.0	1.0	1.0
2.0	2.0	7.0	3.0
6.0	1.0	1.0	6.0

#ID = M00174
#Short = V$AP1_Q6
#Long = AP-1 (activator protein 1)
#W = 11
#Factors = AP-1
#Organisms = gibbon ape (Hylobates lar),human (Homo sapiens),clawed frog (Xenopus),hamster (Cricetulus sp),mouse (Mus musculus),chick (Gallus gallus),rat (Rattus norvegicus),monkey (Cercopithecus aethiops)
#Interactions = HM0367,HM0368,HM0369,HM0370,HM0388,HM0454,HM0455,HM1018,HM1124,HM1125,HM1126,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00042,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00311,M00320,M00338,M00339,M00340,M00396,M00418,M00447,M00454,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00531,M00538,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0554,MA0554_1,MA0554_2,MA0555,MA0555_1,MA0555_2,MA0563,MA0563_1,MA0563_2,MA0584,MA0584_1,MA0584_2,MA1035,MA1035_1,MA1062,MA1062_1,MA1062_2,MA1062_3,MA1283,MA1283_1,MA1283_2,MA1484,MA1484_1,MA1484_2,MA2286,MA2286_1
#Alternatives = M00173,M00188,M00199,M00517,MA0940,MA0940_1
#Transfac class = C0008
14.0	12.0	23.0	7.0
18.0	17.0	18.0	3.0
0.0	0.0	0.0	56.0
0.0	0.0	56.0	0.0
55.0	1.0	0.0	0.0
3.0	44.0	5.0	4.0
4.0	5.0	7.0	40.0
13.0	30.0	5.0	8.0
38.0	10.0	5.0	3.0
11.0	13.0	18.0	14.0
11.0	15.0	10.0	20.0

#ID = HM0400
#Short = FOSL2
#Long = Fos-related antigen 2
#W = 12
#Class = 1.1.2.1.4
#Factors = FOSL2,FRA2,Fra-2
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0205,HM0206,HM0216,HM0221,HM0222,HM0281,HM0282,HM0295,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0678,HM0679,HM0725,HM0771,HM0772,M00490,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0705,MA0705_1,MA0705_2,MA0706,MA0706_1,MA0706_2,MA0834,MA0834_1,MA0834_2,MA0840,MA0840_1,MA0840_2,MA1101,MA1101_1,MA1101_2,MA1101_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1470,MA1470_1,MA1470_2,MA1632,MA1632_1,MA1632_2,MA2127,MA2127_1,MA2192,MA2192_1
#Alternatives = MA0478,MA0478_1,MA0478_2,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2
#HOCOMOCOv13 = FOSL2.H13CORE.0.P.B
#UniProt = P15408,P47930
#HGNC = 3798
#GeneCards = FOSL2
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 102858
#Entrez = 2355,14284
190.0	211.0	419.0	181.0
232.0	176.0	433.0	160.0
488.0	152.0	346.0	15.0
0.0	3.0	2.0	996.0
2.0	1.0	982.0	16.0
986.0	6.0	0.0	9.0
48.0	0.0	953.0	0.0
0.0	1.0	0.0	1000.0
5.0	995.0	1.0	0.0
998.0	1.0	0.0	2.0
10.0	372.0	131.0	488.0
164.0	451.0	145.0	241.0

#ID = M00172
#Short = V$AP1FJ_Q2
#Long = AP-1 (activator protein 1)
#W = 11
#Quality = 2
#Factors = c-Fos,c-Jun,AP-1
#Organisms = Japanese pufferfish (Fugu rubripes),gibbon ape (Hylobates lar),human (Homo sapiens),cattle (Bos taurus),Japanese quail (Coturnix coturnix japonica),dog (Canis familiaris (Canis canis)),hamster (Cricetulus sp),mouse (Mus musculus),chick (Gallus gallus),monkey (Cercopithecus aethiops),domestic pig (Sus scrofa),rat (Rattus norvegicus),sheep (Ovis aries),rabbit (Oryctolagus cuniculus)
#Interactions = HM0178,HM0185,HM0186,HM0187,HM0194,HM0195,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0253,HM0254,HM0255,HM0269,HM0270,HM0279,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0369,HM0370,HM0388,HM0393,HM0394,HM0395,HM0439,HM0440,HM0454,HM0455,HM0484,HM0485,HM0502,HM0503,HM0509,HM0510,HM0512,HM0521,HM0624,HM0625,HM0694,HM0695,HM0770,HM0777,HM0778,HM0779,HM0780,HM0781,HM0800,HM0961,HM0962,HM0964,HM0965,HM0998,HM1018,HM1026,HM1027,HM1028,HM1029,HM1072,HM1073,HM1074,HM1085,HM1086,HM1087,HM1088,HM1095,HM1101,HM1102,HM1103,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1133,HM1134,HM1137,HM1138,HM1140,HM1141,HM1146,HM1147,HM1148,HM1149,HM1188,HM1198,HM1223,HM1224,HM1231,HM1247,HM1248,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00039,M00040,M00041,M00042,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00113,M00116,M00117,M00121,M00122,M00148,M00155,M00158,M00159,M00160,M00172,M00173,M00174,M00177,M00178,M00179,M00184,M00187,M00188,M00190,M00191,M00192,M00196,M00199,M00201,M00205,M00216,M00217,M00223,M00224,M00225,M00236,M00242,M00249,M00251,M00252,M00259,M00260,M00271,M00284,M00302,M00311,M00320,M00338,M00339,M00340,M00396,M00410,M00418,M00447,M00454,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00531,M00538,M00539,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0004,MA0004_1,MA0006,MA0006_1,MA0006_2,MA0007,MA0007_1,MA0007_2,MA0007_3,MA0007_4,MA0017,MA0017_1,MA0017_2,MA0017_3,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0027,MA0027_1,MA0027_2,MA0027_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0043,MA0043_1,MA0043_2,MA0043_3,MA0043_4,MA0045,MA0055,MA0061,MA0065,MA0065_1,MA0065_2,MA0065_3,MA0066,MA0066_1,MA0066_2,MA0077,MA0077_1,MA0077_2,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0084,MA0084_1,MA0084_2,MA0087,MA0087_1,MA0087_2,MA0087_3,MA0089,MA0089_1,MA0089_2,MA0089_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0108,MA0108_1,MA0108_2,MA0108_3,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0114,MA0114_1,MA0114_2,MA0114_3,MA0114_4,MA0114_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0133,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0201,MA0201_1,MA0220,MA0220_1,MA0258,MA0258_1,MA0258_2,MA0259,MA0259_1,MA0259_2,MA0386,MA0386_1,MA0386_2,MA0414,MA0414_1,MA0414_2,MA0442,MA0442_1,MA0442_2,MA0442_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0494,MA0494_1,MA0494_2,MA0512,MA0512_1,MA0512_2,MA0517,MA0517_1,MA0517_2,MA0518,MA0518_1,MA0518_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0844,MA0844_1,MA0844_2,MA0940,MA0940_1,MA1106,MA1106_1,MA1106_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1484,MA1484_1,MA1484_2,MA1494,MA1494_1,MA1494_2,MA1537,MA1537_1,MA1537_2,MA1538,MA1538_1,MA1849,MA1849_1,MA1849_2,MA1911,MA1911_1,MA1911_2,MA1926,MA1926_1,MA1926_2,MA1951,MA1951_1,MA1951_2,MA1962,MA1962_1,MA1988,MA1988_1,MA1988_2,MA2156,MA2156_1,MA2168,MA2168_1,MA2193,MA2193_1,MA2264,MA2264_1,MA2279,MA2279_1,MA2290,MA2290_1,MA2293,MA2293_1,MA2338,MA2338_1,MA2388,MA2388_1
#Transfac class = C0008
6.0	2.0	8.0	1.0
3.0	5.0	9.0	0.0
0.0	0.0	0.0	17.0
0.0	0.0	17.0	0.0
17.0	0.0	0.0	0.0
0.0	16.0	0.0	1.0
3.0	2.0	3.0	9.0
4.0	7.0	2.0	4.0
9.0	6.0	1.0	1.0
4.0	3.0	7.0	3.0
6.0	3.0	1.0	7.0

#ID = M00199
#Short = V$AP1_C
#Long = AP-1 (AP-1 binding site)
#W = 9
#Factors = AP-1
#Organisms = gibbon ape (Hylobates lar),human (Homo sapiens),clawed frog (Xenopus),hamster (Cricetulus sp),mouse (Mus musculus),chick (Gallus gallus),rat (Rattus norvegicus),monkey (Cercopithecus aethiops),fruit fly (Drosophila melanogaster)
#Interactions = HM0367,HM0368,HM0369,HM0370,HM0388,HM0454,HM0455,HM1018,HM1124,HM1125,HM1126,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00042,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00311,M00320,M00338,M00339,M00340,M00396,M00418,M00447,M00454,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00531,M00538,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0554,MA0554_1,MA0554_2,MA0555,MA0555_1,MA0555_2,MA0563,MA0563_1,MA0563_2,MA0584,MA0584_1,MA0584_2,MA1035,MA1035_1,MA1062,MA1062_1,MA1062_2,MA1062_3,MA1283,MA1283_1,MA1283_2,MA1484,MA1484_1,MA1484_2,MA2286,MA2286_1
#Alternatives = M00173,M00174,M00188,M00517,MA0940,MA0940_1
#Transfac class = C0008
4.79	2.3	3.06	1.3
0.0	0.0	0.0	12.15
0.0	0.0	9.83	2.32
11.28	0.0	0.0	0.87
1.28	4.71	6.16	0.0
0.0	0.0	0.0	12.15
1.46	10.7	0.0	0.0
12.15	0.0	0.0	0.0
0.89	1.22	5.91	2.17

#ID = M00188
#Short = V$AP1_Q4
#Long = AP-1 (activator protein 1)
#W = 11
#Quality = 4
#Factors = AP-1
#Organisms = gibbon ape (Hylobates lar),human (Homo sapiens),clawed frog (Xenopus),hamster (Cricetulus sp),mouse (Mus musculus),chick (Gallus gallus),rat (Rattus norvegicus),monkey (Cercopithecus aethiops)
#Interactions = HM0367,HM0368,HM0369,HM0370,HM0388,HM0454,HM0455,HM1018,HM1124,HM1125,HM1126,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00042,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00311,M00320,M00338,M00339,M00340,M00396,M00418,M00447,M00454,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00531,M00538,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0554,MA0554_1,MA0554_2,MA0555,MA0555_1,MA0555_2,MA0563,MA0563_1,MA0563_2,MA0584,MA0584_1,MA0584_2,MA1035,MA1035_1,MA1062,MA1062_1,MA1062_2,MA1062_3,MA1283,MA1283_1,MA1283_2,MA1484,MA1484_1,MA1484_2,MA2286,MA2286_1
#Alternatives = M00173,M00174,M00199,M00517,MA0940,MA0940_1
#Transfac class = C0008
10.0	2.0	10.0	1.0
5.0	6.0	12.0	0.0
0.0	0.0	0.0	23.0
0.0	0.0	23.0	0.0
22.0	0.0	1.0	0.0
0.0	21.0	0.0	2.0
2.0	2.0	2.0	17.0
9.0	9.0	3.0	2.0
16.0	5.0	1.0	1.0
3.0	6.0	10.0	4.0
6.0	4.0	3.0	10.0

#ID = MA1448
#Short = fos-1
#Long = Transcription factor fos-1
#W = 7
#Class = 1.1.2
#Factors = fos-1,FOS1
#Organisms = roundworm (Caenorhabditis elegans)
#Interactions = MA2135,MA2135_1
#Alternatives = MA1448_1
#UniProt = G5ECG2
#Jaspar = MA1448.1
#Evidence = PBM
#PubMed = 19570917
4.0	4.0	4.0	985.0
4.0	4.0	985.0	4.0
985.0	4.0	4.0	4.0
4.0	985.0	4.0	4.0
4.0	4.0	4.0	985.0
4.0	985.0	4.0	4.0
985.0	4.0	4.0	4.0

#ID = M00517
#Short = V$AP1_01
#Long = AP-1 (Activator protein 1)
#W = 13
#Class = 1.1.1.1.2
#Factors = c-Fos,JunB,FosB,JunD,c-Jun,AP-1,Fra-1
#Organisms = Japanese pufferfish (Fugu rubripes),gibbon ape (Hylobates lar),human (Homo sapiens),cattle (Bos taurus),Japanese quail (Coturnix coturnix japonica),dog (Canis familiaris (Canis canis)),hamster (Cricetulus sp),mouse (Mus musculus),chick (Gallus gallus),domestic pig (Sus scrofa),rat (Rattus norvegicus),monkey (Cercopithecus aethiops),sheep (Ovis aries),rabbit (Oryctolagus cuniculus)
#Interactions = HM0178,HM0185,HM0186,HM0187,HM0194,HM0195,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0253,HM0254,HM0255,HM0269,HM0270,HM0279,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0369,HM0370,HM0388,HM0393,HM0394,HM0395,HM0439,HM0440,HM0454,HM0455,HM0484,HM0485,HM0502,HM0503,HM0509,HM0510,HM0512,HM0521,HM0624,HM0625,HM0694,HM0695,HM0770,HM0777,HM0778,HM0779,HM0780,HM0781,HM0800,HM0961,HM0962,HM0964,HM0965,HM0998,HM1018,HM1026,HM1027,HM1028,HM1029,HM1072,HM1073,HM1074,HM1085,HM1086,HM1087,HM1088,HM1095,HM1101,HM1102,HM1103,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1133,HM1134,HM1137,HM1138,HM1140,HM1141,HM1146,HM1147,HM1148,HM1149,HM1188,HM1198,HM1223,HM1224,HM1231,HM1247,HM1248,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00039,M00040,M00041,M00042,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00113,M00116,M00117,M00121,M00122,M00148,M00155,M00158,M00159,M00160,M00172,M00173,M00174,M00177,M00178,M00179,M00184,M00187,M00188,M00190,M00191,M00192,M00196,M00199,M00201,M00205,M00216,M00217,M00223,M00224,M00225,M00236,M00242,M00249,M00251,M00252,M00259,M00260,M00271,M00284,M00302,M00311,M00320,M00338,M00339,M00340,M00396,M00410,M00418,M00447,M00454,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00531,M00538,M00539,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0004,MA0004_1,MA0006,MA0006_1,MA0006_2,MA0007,MA0007_1,MA0007_2,MA0007_3,MA0007_4,MA0017,MA0017_1,MA0017_2,MA0017_3,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0027,MA0027_1,MA0027_2,MA0027_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0043,MA0043_1,MA0043_2,MA0043_3,MA0043_4,MA0045,MA0055,MA0061,MA0065,MA0065_1,MA0065_2,MA0065_3,MA0066,MA0066_1,MA0066_2,MA0077,MA0077_1,MA0077_2,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0084,MA0084_1,MA0084_2,MA0087,MA0087_1,MA0087_2,MA0087_3,MA0089,MA0089_1,MA0089_2,MA0089_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0108,MA0108_1,MA0108_2,MA0108_3,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0114,MA0114_1,MA0114_2,MA0114_3,MA0114_4,MA0114_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0133,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0201,MA0201_1,MA0220,MA0220_1,MA0258,MA0258_1,MA0258_2,MA0259,MA0259_1,MA0259_2,MA0386,MA0386_1,MA0386_2,MA0414,MA0414_1,MA0414_2,MA0442,MA0442_1,MA0442_2,MA0442_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0494,MA0494_1,MA0494_2,MA0512,MA0512_1,MA0512_2,MA0517,MA0517_1,MA0517_2,MA0518,MA0518_1,MA0518_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0554,MA0554_1,MA0554_2,MA0555,MA0555_1,MA0555_2,MA0563,MA0563_1,MA0563_2,MA0584,MA0584_1,MA0584_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0844,MA0844_1,MA0844_2,MA0940,MA0940_1,MA1035,MA1035_1,MA1062,MA1062_1,MA1062_2,MA1062_3,MA1106,MA1106_1,MA1106_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1283,MA1283_1,MA1283_2,MA1484,MA1484_1,MA1484_2,MA1494,MA1494_1,MA1494_2,MA1537,MA1537_1,MA1537_2,MA1538,MA1538_1,MA1849,MA1849_1,MA1849_2,MA1911,MA1911_1,MA1911_2,MA1926,MA1926_1,MA1926_2,MA1951,MA1951_1,MA1951_2,MA1962,MA1962_1,MA1988,MA1988_1,MA1988_2,MA2156,MA2156_1,MA2168,MA2168_1,MA2193,MA2193_1,MA2264,MA2264_1,MA2279,MA2279_1,MA2286,MA2286_1,MA2290,MA2290_1,MA2293,MA2293_1,MA2338,MA2338_1,MA2388,MA2388_1
#Alternatives = M00173,M00174,M00188,M00199,MA0940,MA0940_1
#Transfac class = C0008
6.0	15.0	19.0	7.0
14.0	12.0	13.0	8.0
19.0	3.0	16.0	9.0
4.0	2.0	5.0	36.0
4.0	2.0	33.0	8.0
36.0	4.0	2.0	5.0
3.0	13.0	29.0	2.0
0.0	0.0	0.0	47.0
2.0	44.0	0.0	1.0
47.0	0.0	0.0	0.0
2.0	8.0	24.0	13.0
10.0	24.0	5.0	8.0
15.0	12.0	11.0	9.0

#ID = HM0393
#Short = FOS
#Long = Proto-oncogene c-Fos
#W = 11
#Class = 1.1.2.1.1
#Factors = FOS,G0S7,Cellular oncogene fos,G0/G1 switch regulatory protein 7
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0253,HM0260,HM0261,HM0262,HM0281,HM0282,HM0295,HM0363,HM0364,HM0393,HM0394,HM0395,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0643,HM0644,HM0694,HM0695,HM0706,HM0707,HM0841,HM0842,HM0843,HM1137,HM1138,HM1324,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0029,MA0029_1,MA0029_2,MA0099_2,MA0099_3,MA0099_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0258,MA0258_1,MA0258_2,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0517,MA0517_1,MA0517_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1513,MA1513_1,MA1513_2,MA1522,MA1522_1,MA1522_2,MA1534,MA1534_1,MA1534_2,MA1632,MA1632_1,MA1632_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1890,MA1890_1,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0394,HM0395,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#HOCOMOCOv13 = FOS.H13CORE.0.P.B
#UniProt = P01100,P01101
#HGNC = 3796
#GeneCards = FOS
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 95574
#Entrez = 2353,14281
271.0	242.0	280.0	216.0
25.0	7.0	20.0	957.0
9.0	35.0	858.0	107.0
767.0	121.0	12.0	109.0
164.0	0.0	843.0	2.0
43.0	62.0	31.0	873.0
71.0	892.0	33.0	13.0
993.0	6.0	2.0	8.0
64.0	359.0	259.0	327.0
246.0	387.0	159.0	217.0
281.0	242.0	253.0	233.0

#ID = HM0394
#Short = FOS
#Long = Proto-oncogene c-Fos
#W = 10
#Class = 1.1.2.1.1
#Factors = FOS,G0S7,Cellular oncogene fos,G0/G1 switch regulatory protein 7
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0253,HM0260,HM0261,HM0262,HM0281,HM0282,HM0295,HM0363,HM0364,HM0393,HM0394,HM0395,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0643,HM0644,HM0694,HM0695,HM0706,HM0707,HM0841,HM0842,HM0843,HM1137,HM1138,HM1324,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0029,MA0029_1,MA0029_2,MA0099_2,MA0099_3,MA0099_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0258,MA0258_1,MA0258_2,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0517,MA0517_1,MA0517_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1513,MA1513_1,MA1513_2,MA1522,MA1522_1,MA1522_2,MA1534,MA1534_1,MA1534_2,MA1632,MA1632_1,MA1632_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1890,MA1890_1,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0395,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#HOCOMOCOv13 = FOS.H13CORE.1.S.C
#UniProt = P01100,P01101
#HGNC = 3796
#GeneCards = FOS
#HMQuality = C
#Evidence = HT-SELEX
#Subtype = 1
#MGI = 95574
#Entrez = 2353,14281
1684.0	2497.0	2307.0	2084.0
2895.0	1470.0	3002.0	1205.0
371.0	5350.0	611.0	2241.0
568.0	252.0	7719.0	34.0
0.0	1.0	0.0	8572.0
18.0	8555.0	0.0	0.0
8417.0	155.0	1.0	0.0
54.0	1490.0	57.0	6972.0
1175.0	4253.0	1450.0	1692.0
2802.0	2502.0	2122.0	1145.0

#ID = HM0395
#Short = FOS
#Long = Proto-oncogene c-Fos
#W = 14
#Class = 1.1.2.1.1
#Factors = FOS,G0S7,Cellular oncogene fos,G0/G1 switch regulatory protein 7
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0253,HM0260,HM0261,HM0262,HM0281,HM0282,HM0295,HM0363,HM0364,HM0393,HM0394,HM0395,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0643,HM0644,HM0694,HM0695,HM0706,HM0707,HM0841,HM0842,HM0843,HM1137,HM1138,HM1324,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0029,MA0029_1,MA0029_2,MA0099_2,MA0099_3,MA0099_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0258,MA0258_1,MA0258_2,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0517,MA0517_1,MA0517_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1513,MA1513_1,MA1513_2,MA1522,MA1522_1,MA1522_2,MA1534,MA1534_1,MA1534_2,MA1632,MA1632_1,MA1632_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1890,MA1890_1,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#HOCOMOCOv13 = FOS.H13CORE.2.S.C
#UniProt = P01100,P01101
#HGNC = 3796
#GeneCards = FOS
#HMQuality = C
#Evidence = HT-SELEX
#Subtype = 2
#MGI = 95574
#Entrez = 2353,14281
100.0	115.0	179.0	110.0
295.0	18.0	177.0	16.0
10.0	4.0	17.0	476.0
14.0	25.0	422.0	46.0
480.0	1.0	25.0	1.0
0.0	500.0	0.0	7.0
0.0	0.0	507.0	0.0
0.0	0.0	0.0	507.0
0.0	507.0	0.0	0.0
507.0	0.0	0.0	0.0
0.0	2.0	0.0	505.0
45.0	420.0	14.0	28.0
287.0	52.0	129.0	36.0
97.0	174.0	105.0	130.0

#ID = HM0396
#Short = FOSB
#Long = Protein fosB
#W = 9
#Class = 1.1.2.1.2
#Factors = FOSB,G0S3,G0/G1 switch regulatory protein 3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0205,HM0206,HM0281,HM0282,HM0436,HM0467,HM0626,HM0627,HM0771,HM0772,HM0960,HM1217,HM1239,HM1240,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0736,MA0736_1,MA0793,MA0793_1,MA0793_2,MA0840,MA0840_1,MA0840_2,MA0850,MA0850_1,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1578,MA1578_1,MA1578_2,MA1632,MA1632_1,MA1632_2,MA2127,MA2127_1,MA2192,MA2192_1
#Alternatives = HM0397,HM0398,MA1127,MA1127_1,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1858,MA1858_1,MA1858_2
#HOCOMOCOv13 = FOSB.H13CORE.0.P.B
#UniProt = P53539,P13346
#HGNC = 3797
#GeneCards = FOSB
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 95575
#Entrez = 2354,14282
427.0	229.0	276.0	71.0
8.0	4.0	9.0	982.0
6.0	20.0	875.0	102.0
921.0	13.0	3.0	66.0
187.0	0.0	816.0	0.0
25.0	17.0	17.0	944.0
45.0	944.0	13.0	1.0
980.0	5.0	4.0	14.0
47.0	373.0	188.0	395.0

#ID = HM0397
#Short = FOSB
#Long = Protein fosB
#W = 16
#Class = 1.1.2.1.2
#Factors = FOSB,G0S3,G0/G1 switch regulatory protein 3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0205,HM0206,HM0281,HM0282,HM0436,HM0467,HM0626,HM0627,HM0771,HM0772,HM0960,HM1217,HM1239,HM1240,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0736,MA0736_1,MA0793,MA0793_1,MA0793_2,MA0840,MA0840_1,MA0840_2,MA0850,MA0850_1,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1578,MA1578_1,MA1578_2,MA1632,MA1632_1,MA1632_2,MA2127,MA2127_1,MA2192,MA2192_1
#Alternatives = HM0396,HM0398,MA1127,MA1127_1,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1858,MA1858_1,MA1858_2
#HOCOMOCOv13 = FOSB.H13CORE.2.M.C
#UniProt = P53539,P13346
#HGNC = 3797
#GeneCards = FOSB
#HMQuality = C
#Evidence = Methyl-HT-SELEX
#Subtype = 2
#MGI = 95575
#Entrez = 2354,14282
110.0	141.0	147.0	150.0
110.0	88.0	224.0	125.0
385.0	26.0	111.0	26.0
37.0	11.0	24.0	476.0
21.0	46.0	409.0	72.0
476.0	14.0	57.0	1.0
4.0	489.0	2.0	53.0
11.0	0.0	537.0	0.0
0.0	0.0	0.0	548.0
0.0	548.0	0.0	0.0
548.0	0.0	0.0	0.0
0.0	0.0	0.0	548.0
60.0	445.0	20.0	23.0
302.0	47.0	191.0	8.0
80.0	202.0	81.0	185.0
113.0	163.0	119.0	151.0

#ID = HM0398
#Short = FOSB
#Long = Protein fosB
#W = 11
#Class = 1.1.2.1.2
#Factors = FOSB,G0S3,G0/G1 switch regulatory protein 3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0205,HM0206,HM0281,HM0282,HM0436,HM0467,HM0626,HM0627,HM0771,HM0772,HM0960,HM1217,HM1239,HM1240,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0736,MA0736_1,MA0793,MA0793_1,MA0793_2,MA0840,MA0840_1,MA0840_2,MA0850,MA0850_1,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1578,MA1578_1,MA1578_2,MA1632,MA1632_1,MA1632_2,MA2127,MA2127_1,MA2192,MA2192_1
#Alternatives = HM0396,HM0397,MA1127,MA1127_1,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1858,MA1858_1,MA1858_2
#HOCOMOCOv13 = FOSB.H13CORE.1.M.C
#UniProt = P53539,P13346
#HGNC = 3797
#GeneCards = FOSB
#HMQuality = C
#Evidence = Methyl-HT-SELEX
#Subtype = 1
#MGI = 95575
#Entrez = 2354,14282
1580.0	1888.0	2543.0	2346.0
3077.0	1426.0	2717.0	1139.0
1656.0	4440.0	473.0	1790.0
521.0	284.0	7552.0	2.0
0.0	0.0	0.0	8359.0
10.0	8349.0	0.0	0.0
8242.0	117.0	0.0	0.0
0.0	502.0	8.0	7849.0
1546.0	5068.0	668.0	1077.0
3402.0	1729.0	2574.0	651.0
1638.0	2900.0	1490.0	2330.0

#ID = HM0399
#Short = FOSL1
#Long = Fos-related antigen 1
#W = 11
#Class = 1.1.2.1.3
#Factors = FOSL1,FRA1,FRA-1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0205,HM0206,HM0211,HM0212,HM0213,HM0233,HM0234,HM0235,HM0281,HM0282,HM0624,HM0625,HM0626,HM0627,HM1231,M00514,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1632,MA1632_1,MA1632_2,MA2127,MA2127_1,MA2192,MA2192_1
#Alternatives = MA0477,MA0477_1,MA0477_2,MA0477_3,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1137,MA1137_1,MA1137_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2
#HOCOMOCOv13 = FOSL1.H13CORE.0.P.B
#UniProt = P15407,P48755
#HGNC = 13718
#GeneCards = FOSL1
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 107179
#Entrez = 8061,14283
467.0	225.0	276.0	32.0
1.0	0.0	3.0	996.0
0.0	0.0	948.0	52.0
990.0	3.0	1.0	6.0
0.0	0.0	945.0	55.0
0.0	0.0	0.0	1000.0
12.0	987.0	1.0	0.0
995.0	3.0	1.0	1.0
24.0	336.0	166.0	474.0
248.0	329.0	180.0	243.0
231.0	331.0	281.0	157.0

#ID = MA0099
#Short = FOS::JUN
#Long = Protein c-Fos::Transcription factor Jun
#W = 9
#Class = 1.1.2.1.1
#Factors = FOS,JUN
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0075,HM0203,HM0204,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0253,HM0260,HM0261,HM0262,HM0280,HM0281,HM0282,HM0295,HM0367,HM0368,HM0393,HM0394,HM0395,HM0399,HM0400,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0643,HM0644,HM0694,HM0695,HM0706,HM0707,HM0771,HM0772,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM0841,HM0842,HM0843,HM1058,HM1059,HM1137,HM1138,HM1324,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0029,MA0029_1,MA0029_2,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099_2,MA0099_3,MA0099_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0517,MA0517_1,MA0517_2,MA0604,MA0604_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0624,MA0624_1,MA0624_2,MA0624_3,MA0638,MA0638_1,MA0638_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1513,MA1513_1,MA1513_2,MA1522,MA1522_1,MA1522_2,MA1534,MA1534_1,MA1534_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1890,MA1890_1,MA1951,MA1951_1,MA1951_2,MA1964,MA1964_1,MA1964_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0624,HM0625,MA0099_4,MA0099_1,MA0099_2,MA0099_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#UniProt = P01100,P05412
#Jaspar = MA0099.4
#DimerClass = 1.1.1.1.1
#Evidence = SMiLE-seq
#PubMed = 11988758
592.0	111.0	257.0	40.0
3.0	5.0	2.0	990.0
7.0	1.0	824.0	168.0
820.0	131.0	4.0	45.0
78.0	180.0	688.0	54.0
5.0	2.0	2.0	991.0
30.0	963.0	3.0	4.0
992.0	2.0	2.0	4.0
24.0	313.0	95.0	568.0

#ID = MA1858
#Short = Fos-b
#Long = Transcription factor protein
#W = 10
#Class = 1.1.2
#Factors = Fos-b,Q4H3J9
#Organisms = vase tunicate (Ciona intestinalis)
#Interactions = HM0205,HM0206,HM0281,HM0282,HM0436,HM0467,HM0626,HM0627,HM0771,HM0772,HM0960,HM1217,HM1239,HM1240,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0736,MA0736_1,MA0793,MA0793_1,MA0793_2,MA0840,MA0840_1,MA0840_2,MA0850,MA0850_1,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1578,MA1578_1,MA1578_2,MA1632,MA1632_1,MA1632_2,MA2127,MA2127_1,MA2192,MA2192_1
#Alternatives = HM0396,HM0397,HM0398,MA1858_2,MA1858_1
#UniProt = Q4H3J9
#Jaspar = MA1858.2
#Evidence = SELEX
#PubMed = 26684323
848.0	46.0	76.0	31.0
7.0	7.0	8.0	979.0
12.0	12.0	955.0	21.0
978.0	5.0	9.0	8.0
8.0	973.0	6.0	12.0
14.0	6.0	969.0	11.0
13.0	30.0	9.0	947.0
58.0	876.0	31.0	35.0
913.0	23.0	25.0	40.0
38.0	74.0	54.0	835.0

#ID = HM1232
#Short = USF2
#Long = Upstream stimulatory factor 2
#W = 18
#Class = 1.2.6.2.2
#Factors = USF2,BHLHB12,Class B basic helix-loop-helix protein 12,FOS-interacting protein,FIP,Major late transcription factor 2,Upstream transcription factor 2
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0393,HM0394,HM0395,HM1137,HM1138,HM1176,M00224,M00492,M00496,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0476,MA0476_1,MA0476_2,MA1121,MA1121_1,MA1121_2,MA1951,MA1951_1,MA1951_2
#Alternatives = MA0526,MA0526_1,MA0526_2,MA0526_3,MA0526_4,MA0526_5
#HOCOMOCOv13 = USF2.H13CORE.0.PSM.A
#UniProt = Q15853,Q64705
#HGNC = 12594
#GeneCards = USF2
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX,Methyl-HT-SELEX
#Subtype = 0
#MGI = 99961
#Entrez = 7392,22282
174.0	202.0	295.0	152.0
152.0	243.0	258.0	170.0
129.0	270.0	238.0	186.0
136.0	274.0	239.0	174.0
165.0	222.0	291.0	145.0
257.0	65.0	362.0	139.0
84.0	10.0	728.0	1.0
6.0	10.0	13.0	794.0
0.0	823.0	0.0	0.0
820.0	0.0	1.0	2.0
1.0	781.0	7.0	34.0
70.0	1.0	752.0	0.0
3.0	1.0	2.0	817.0
0.0	0.0	822.0	1.0
388.0	95.0	272.0	68.0
39.0	348.0	167.0	269.0
112.0	379.0	247.0	85.0
198.0	247.0	208.0	170.0

#ID = MA0478
#Short = FOSL2
#Long = Fos-related antigen 2
#W = 10
#Class = 1.1.2.1.4
#Factors = FOSL2
#Organisms = human (Homo sapiens)
#Interactions = HM0205,HM0206,HM0216,HM0221,HM0222,HM0281,HM0282,HM0295,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0678,HM0679,HM0725,HM0771,HM0772,M00490,MA0099_2,MA0099_3,MA0099_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0705,MA0705_1,MA0705_2,MA0706,MA0706_1,MA0706_2,MA0834,MA0834_1,MA0834_2,MA0840,MA0840_1,MA0840_2,MA1101,MA1101_1,MA1101_2,MA1101_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1470,MA1470_1,MA1470_2,MA1632,MA1632_1,MA1632_2,MA2127,MA2127_1,MA2192,MA2192_1
#Alternatives = HM0400,MA0478_2,MA0478_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2
#UniProt = P15408
#Jaspar = MA0478.2
#Evidence = ChIP-seq
#PubMed = 17916232
1525.0	592.0	2707.0	494.0
2861.0	55.0	2328.0	74.0
0.0	0.0	0.0	5318.0
0.0	0.0	5318.0	0.0
5075.0	51.0	192.0	0.0
0.0	3286.0	1838.0	194.0
0.0	0.0	0.0	5318.0
205.0	5113.0	0.0	0.0
5318.0	0.0	0.0	0.0
0.0	1399.0	1933.0	1986.0

#ID = MA0477
#Short = FOSL1
#Long = Fos-related antigen 1
#W = 9
#Class = 1.1.2.1.3
#Factors = FOSL1
#Organisms = human (Homo sapiens)
#Interactions = HM0205,HM0206,HM0211,HM0212,HM0213,HM0233,HM0234,HM0235,HM0281,HM0282,HM0624,HM0625,HM0626,HM0627,HM1231,M00514,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1632,MA1632_1,MA1632_2,MA2127,MA2127_1,MA2192,MA2192_1
#Alternatives = HM0399,MA0477_3,MA0477_1,MA0477_2,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1137,MA1137_1,MA1137_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2
#UniProt = P15407
#Jaspar = MA0477.3
#Evidence = ChIP-seq
#PubMed = 17916232
35056.0	6703.0	13127.0	2795.0
260.0	460.0	183.0	56778.0
515.0	301.0	54619.0	2246.0
56806.0	287.0	286.0	302.0
2557.0	43918.0	8615.0	2591.0
1060.0	163.0	598.0	55860.0
3133.0	53711.0	278.0	559.0
56408.0	344.0	566.0	363.0
2716.0	10399.0	6533.0	38033.0

#ID = MA0476
#Short = FOS
#Long = Protein c-Fos
#W = 8
#Class = 1.1.2.1.1
#Factors = FOS
#Organisms = human (Homo sapiens)
#Interactions = HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0253,HM0260,HM0261,HM0262,HM0281,HM0282,HM0295,HM0363,HM0364,HM0393,HM0394,HM0395,HM0624,HM0625,HM0626,HM0627,HM0628,HM0629,HM0643,HM0644,HM0694,HM0695,HM0706,HM0707,HM0841,HM0842,HM0843,HM1137,HM1138,HM1324,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0029,MA0029_1,MA0029_2,MA0099_2,MA0099_3,MA0099_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0258,MA0258_1,MA0258_2,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0490,MA0490_1,MA0490_2,MA0490_3,MA0491,MA0491_1,MA0491_2,MA0491_3,MA0492,MA0492_1,MA0492_2,MA0517,MA0517_1,MA0517_2,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0838,MA0838_1,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1140,MA1140_1,MA1140_2,MA1140_3,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1513,MA1513_1,MA1513_2,MA1522,MA1522_1,MA1522_2,MA1534,MA1534_1,MA1534_2,MA1632,MA1632_1,MA1632_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1890,MA1890_1,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0624,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476_2,MA0476_1,MA0488,MA0488_1,MA0488_2,MA0489_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#UniProt = P01100
#Jaspar = MA0476.2
#Evidence = ChIP-seq
#PubMed = 17916232
0.0	0.0	0.0	29396.0
0.0	0.0	27108.0	2288.0
29396.0	0.0	0.0	0.0
998.0	14079.0	11206.0	3113.0
0.0	0.0	0.0	29396.0
0.0	29396.0	0.0	0.0
29396.0	0.0	0.0	0.0
258.0	5823.0	1538.0	21777.0

#ID = HM0624
#Short = JUN
#Long = Transcription factor AP-1
#W = 12
#Class = 1.1.1.1.1
#Factors = JUN,Activator protein 1,AP1,Proto-oncogene c-Jun,V-jun avian sarcoma virus 17 oncogene homolog,p39
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0075,HM0203,HM0204,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0260,HM0261,HM0262,HM0280,HM0361,HM0362,HM0367,HM0368,HM0393,HM0394,HM0395,HM0399,HM0400,HM0624,HM0625,HM0706,HM0707,HM0771,HM0772,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM1058,HM1059,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099_2,MA0099_3,MA0099_4,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0604,MA0604_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0624,MA0624_1,MA0624_2,MA0624_3,MA0638,MA0638_1,MA0638_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1448,MA1448_1,MA1522,MA1522_1,MA1522_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1951,MA1951_1,MA1951_2,MA1964,MA1964_1,MA1964_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0625,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#HOCOMOCOv13 = JUN.H13CORE.0.P.B
#UniProt = P05412,P05627
#HGNC = 6204
#GeneCards = JUN
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 96646
#Entrez = 3725,16476
102.0	123.0	258.0	110.0
159.0	101.0	252.0	81.0
243.0	102.0	207.0	41.0
0.0	0.0	8.0	585.0
12.0	0.0	580.0	1.0
559.0	25.0	0.0	9.0
13.0	0.0	580.0	0.0
0.0	0.0	0.0	593.0
2.0	591.0	0.0	0.0
593.0	0.0	0.0	0.0
4.0	236.0	51.0	302.0
60.0	319.0	110.0	104.0

#ID = HM0625
#Short = JUN
#Long = Transcription factor AP-1
#W = 16
#Class = 1.1.1.1.1
#Factors = JUN,Activator protein 1,AP1,Proto-oncogene c-Jun,V-jun avian sarcoma virus 17 oncogene homolog,p39
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0075,HM0203,HM0204,HM0205,HM0206,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0216,HM0231,HM0232,HM0233,HM0234,HM0235,HM0260,HM0261,HM0262,HM0280,HM0361,HM0362,HM0367,HM0368,HM0393,HM0394,HM0395,HM0399,HM0400,HM0624,HM0625,HM0706,HM0707,HM0771,HM0772,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM1058,HM1059,M00001,M00008,M00017,M00032,M00033,M00035,M00036,M00040,M00041,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00116,M00117,M00148,M00155,M00158,M00159,M00160,M00172,M00177,M00178,M00179,M00184,M00187,M00190,M00191,M00192,M00196,M00201,M00205,M00216,M00223,M00224,M00225,M00242,M00249,M00251,M00252,M00260,M00271,M00284,M00302,M00338,M00339,M00340,M00396,M00418,M00447,M00466,M00471,M00481,M00492,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00538,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099_2,MA0099_3,MA0099_4,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0604,MA0604_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0624,MA0624_1,MA0624_2,MA0624_3,MA0638,MA0638_1,MA0638_2,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0834,MA0834_1,MA0834_2,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0838,MA0838_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1438,MA1438_1,MA1438_2,MA1448,MA1448_1,MA1522,MA1522_1,MA1522_2,MA1632,MA1632_1,MA1632_2,MA1634,MA1634_1,MA1634_2,MA1636,MA1636_1,MA1636_2,MA1848,MA1848_1,MA1848_2,MA1951,MA1951_1,MA1951_2,MA1964,MA1964_1,MA1964_2,MA1988,MA1988_1,MA1988_2,MA2127,MA2127_1,MA2192,MA2192_1,MA2193,MA2193_1
#Alternatives = HM0393,HM0394,HM0395,HM0624,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1951,MA1951_1,MA1951_2
#HOCOMOCOv13 = JUN.H13CORE.1.S.C
#UniProt = P05412,P05627
#HGNC = 6204
#GeneCards = JUN
#HMQuality = C
#Evidence = HT-SELEX
#Subtype = 1
#MGI = 96646
#Entrez = 3725,16476
18.0	36.0	50.0	35.0
25.0	40.0	56.0	18.0
103.0	13.0	22.0	2.0
5.0	1.0	0.0	134.0
2.0	5.0	105.0	28.0
125.0	4.0	11.0	0.0
0.0	140.0	0.0	0.0
0.0	10.0	130.0	0.0
0.0	0.0	0.0	140.0
1.0	133.0	0.0	6.0
136.0	4.0	0.0	0.0
0.0	21.0	1.0	118.0
3.0	116.0	13.0	8.0
25.0	68.0	29.0	18.0
11.0	50.0	11.0	67.0
29.0	33.0	34.0	42.0

#ID = HM0592
#Short = IRF1
#Long = Interferon regulatory factor 1
#W = 19
#Class = 3.5.3.0.1
#Factors = IRF1,IRF-1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0594,HM0595,HM0771,HM0772,M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00258,M00302,M00339,M00340,M00453,M00492,M00496,MA0150,MA0150_1,MA0150_2,MA0150_3,MA1418,MA1418_1,MA1418_2
#Alternatives = M00062,HM0593,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0051,MA0051_1,MA0051_2
#HOCOMOCOv13 = IRF1.H13CORE.0.P.B
#UniProt = P10914,P15314
#HGNC = 6116
#GeneCards = IRF1
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 96590
#Entrez = 3659,16362
395.0	107.0	88.0	91.0
439.0	64.0	75.0	103.0
166.0	180.0	217.0	118.0
171.0	130.0	121.0	259.0
77.0	11.0	589.0	4.0
655.0	5.0	19.0	2.0
665.0	4.0	9.0	3.0
659.0	6.0	6.0	10.0
27.0	267.0	379.0	8.0
95.0	120.0	15.0	451.0
16.0	5.0	657.0	3.0
648.0	3.0	27.0	3.0
647.0	8.0	11.0	15.0
658.0	5.0	17.0	1.0
14.0	259.0	402.0	6.0
88.0	251.0	39.0	303.0
276.0	107.0	231.0	67.0
307.0	105.0	204.0	65.0
242.0	139.0	174.0	126.0

#ID = HM0593
#Short = IRF2
#Long = Interferon regulatory factor 2
#W = 17
#Class = 3.5.3.0.2
#Factors = IRF2,IRF-2
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0425,HM0426,M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00258,M00302,M00339,M00340,M00453,M00492,M00496,MA0852,MA0852_1,MA0852_2,MA0852_3,MA1103,MA1103_1,MA1103_2,MA1103_3
#Alternatives = M00063,HM0592,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0051,MA0051_1,MA0051_2
#HOCOMOCOv13 = IRF2.H13CORE.0.PSM.A
#UniProt = P14316,P23906
#HGNC = 6117
#GeneCards = IRF2
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX,Methyl-HT-SELEX
#Subtype = 0
#MGI = 96591
#Entrez = 3660,16363
848.0	214.0	248.0	312.0
369.0	379.0	556.0	317.0
88.0	1032.0	147.0	357.0
40.0	49.0	1501.0	34.0
1534.0	13.0	66.0	11.0
1498.0	3.0	1.0	122.0
1618.0	0.0	1.0	5.0
50.0	517.0	1010.0	47.0
7.0	1086.0	20.0	511.0
2.0	0.0	1622.0	0.0
1620.0	0.0	3.0	1.0
1573.0	1.0	2.0	48.0
1618.0	0.0	2.0	4.0
38.0	695.0	862.0	29.0
132.0	573.0	202.0	717.0
481.0	163.0	829.0	150.0
567.0	384.0	371.0	302.0

#ID = HM0594
#Short = IRF3
#Long = Interferon regulatory factor 3
#W = 19
#Class = 3.5.3.0.3
#Factors = IRF3,IRF-3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0592,HM0594,HM0595,HM0694,HM0695,M00062,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0117,MA0117_1,MA0117_2,MA0117_3,MA1418,MA1418_1,MA1418_2
#Alternatives = HM0595,MA1418,MA1418_1,MA1418_2
#HOCOMOCOv13 = IRF3.H13CORE.0.PS.A
#UniProt = Q14653,P70671
#HGNC = 6118
#GeneCards = IRF3
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX
#Subtype = 0
#MGI = 1859179
#Entrez = 3661,54131
1570.0	1472.0	1529.0	1252.0
647.0	1301.0	3161.0	716.0
1217.0	375.0	3881.0	353.0
4231.0	241.0	928.0	426.0
4770.0	180.0	391.0	485.0
4933.0	274.0	145.0	474.0
1383.0	2306.0	1440.0	697.0
266.0	1977.0	3016.0	567.0
7.0	2.0	5817.0	0.0
5603.0	25.0	122.0	76.0
5551.0	0.0	24.0	251.0
5491.0	64.0	44.0	227.0
370.0	3582.0	1574.0	300.0
765.0	2129.0	1471.0	1461.0
957.0	268.0	4223.0	378.0
3914.0	665.0	749.0	498.0
3627.0	469.0	706.0	1024.0
3764.0	779.0	589.0	692.0
1264.0	2259.0	1338.0	965.0

#ID = HM0595
#Short = IRF3
#Long = Interferon regulatory factor 3
#W = 23
#Class = 3.5.3.0.3
#Factors = IRF3,IRF-3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0592,HM0594,HM0595,HM0694,HM0695,M00062,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0117,MA0117_1,MA0117_2,MA0117_3,MA1418,MA1418_1,MA1418_2
#Alternatives = HM0594,MA1418,MA1418_1,MA1418_2
#HOCOMOCOv13 = IRF3.H13CORE.1.SM.B
#UniProt = Q14653,P70671
#HGNC = 6118
#GeneCards = IRF3
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 1
#MGI = 1859179
#Entrez = 3661,54131
260.0	1323.0	92.0	360.0
1037.0	256.0	354.0	386.0
159.0	254.0	1527.0	96.0
49.0	30.0	171.0	1786.0
57.0	12.0	216.0	1751.0
252.0	21.0	26.0	1737.0
208.0	1731.0	20.0	77.0
320.0	1559.0	111.0	46.0
713.0	342.0	287.0	694.0
18.0	159.0	1787.0	72.0
6.0	1.0	2027.0	2.0
2008.0	1.0	26.0	1.0
2021.0	0.0	3.0	12.0
2023.0	3.0	5.0	5.0
50.0	1837.0	137.0	12.0
132.0	798.0	184.0	922.0
277.0	4.0	1740.0	15.0
1105.0	829.0	63.0	39.0
999.0	177.0	618.0	242.0
1108.0	684.0	72.0	172.0
420.0	927.0	534.0	155.0
404.0	595.0	341.0	693.0
792.0	332.0	450.0	460.0

#ID = HM0596
#Short = IRF4
#Long = Interferon regulatory factor 4
#W = 17
#Class = 3.5.3.0.4
#Factors = IRF4,MUM1,Spip,IRF-4,Lymphocyte-specific interferon regulatory factor,LSIRF,Multiple myeloma oncogene 1,NF-EM5
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0231,HM0232,MA1634,MA1634_1,MA1634_2
#Alternatives = HM0597,HM0598,MA1419,MA1419_1,MA1419_2
#HOCOMOCOv13 = IRF4.H13CORE.0.P.B
#UniProt = Q15306,Q64287
#HGNC = 6119
#GeneCards = IRF4
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 1096873
#Entrez = 3662,16364
439.0	171.0	201.0	174.0
505.0	107.0	199.0	174.0
490.0	102.0	215.0	178.0
257.0	236.0	338.0	154.0
420.0	158.0	193.0	214.0
196.0	14.0	764.0	11.0
375.0	25.0	574.0	11.0
889.0	15.0	65.0	16.0
866.0	26.0	44.0	49.0
137.0	476.0	318.0	54.0
130.0	122.0	34.0	699.0
33.0	4.0	941.0	7.0
855.0	13.0	111.0	6.0
794.0	29.0	152.0	10.0
910.0	6.0	47.0	22.0
141.0	512.0	305.0	27.0
154.0	313.0	93.0	425.0

#ID = HM0597
#Short = IRF4
#Long = Interferon regulatory factor 4
#W = 17
#Class = 3.5.3.0.4
#Factors = IRF4,MUM1,Spip,IRF-4,Lymphocyte-specific interferon regulatory factor,LSIRF,Multiple myeloma oncogene 1,NF-EM5
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0231,HM0232,MA1634,MA1634_1,MA1634_2
#Alternatives = HM0596,HM0598,MA1419,MA1419_1,MA1419_2
#HOCOMOCOv13 = IRF4.H13CORE.2.SM.B
#UniProt = Q15306,Q64287
#HGNC = 6119
#GeneCards = IRF4
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 2
#MGI = 1096873
#Entrez = 3662,16364
2185.0	1611.0	1638.0	908.0
2689.0	1125.0	646.0	1883.0
4562.0	654.0	246.0	883.0
796.0	3700.0	749.0	1100.0
14.0	5543.0	15.0	773.0
1.0	0.0	6344.0	0.0
6335.0	10.0	0.0	0.0
6197.0	0.0	1.0	147.0
6345.0	0.0	0.0	0.0
8.0	6017.0	310.0	10.0
36.0	3815.0	25.0	2469.0
1565.0	264.0	4341.0	175.0
3762.0	1177.0	830.0	576.0
3396.0	843.0	810.0	1296.0
4325.0	934.0	406.0	680.0
966.0	3452.0	946.0	981.0
1219.0	2229.0	815.0	2080.0

#ID = HM0598
#Short = IRF4
#Long = Interferon regulatory factor 4
#W = 14
#Class = 3.5.3.0.4
#Factors = IRF4,MUM1,Spip,IRF-4,Lymphocyte-specific interferon regulatory factor,LSIRF,Multiple myeloma oncogene 1,NF-EM5
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0231,HM0232,MA1634,MA1634_1,MA1634_2
#Alternatives = HM0596,HM0597,MA1419,MA1419_1,MA1419_2
#HOCOMOCOv13 = IRF4.H13CORE.1.S.B
#UniProt = Q15306,Q64287
#HGNC = 6119
#GeneCards = IRF4
#HMQuality = B
#Evidence = HT-SELEX
#Subtype = 1
#MGI = 1096873
#Entrez = 3662,16364
1535.0	3071.0	1912.0	1527.0
1509.0	1797.0	3792.0	947.0
3431.0	1712.0	1980.0	924.0
4264.0	1362.0	924.0	1497.0
5365.0	970.0	532.0	1180.0
1109.0	4906.0	988.0	1044.0
288.0	6107.0	295.0	1357.0
55.0	120.0	7820.0	52.0
7824.0	129.0	57.0	37.0
7485.0	56.0	108.0	398.0
7357.0	335.0	160.0	195.0
429.0	6491.0	786.0	341.0
912.0	3435.0	587.0	3111.0
2634.0	2145.0	1761.0	1505.0

#ID = HM0599
#Short = IRF5
#Long = Interferon regulatory factor 5
#W = 17
#Class = 3.5.3.0.5
#Factors = IRF5,IRF-5
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0599,HM0600,HM1188,MA0107,MA0107_1,MA1420,MA1420_1
#Alternatives = HM0600,MA1420,MA1420_1
#HOCOMOCOv13 = IRF5.H13CORE.0.SM.B
#UniProt = Q13568,P56477
#HGNC = 6120
#GeneCards = IRF5
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 0
#MGI = 1350924
#Entrez = 3663,27056
4010.0	2360.0	2323.0	1148.0
1894.0	3106.0	3016.0	1823.0
1055.0	4739.0	874.0	3173.0
1062.0	1036.0	6294.0	1449.0
6720.0	1086.0	792.0	1243.0
6141.0	1194.0	919.0	1587.0
8541.0	407.0	654.0	239.0
481.0	7367.0	1654.0	339.0
149.0	7981.0	6.0	1705.0
105.0	3.0	9728.0	5.0
9812.0	12.0	15.0	2.0
8526.0	2.0	166.0	1147.0
9826.0	6.0	2.0	7.0
58.0	9153.0	590.0	40.0
538.0	3987.0	264.0	5052.0
3883.0	1297.0	3557.0	1103.0
3886.0	2096.0	2156.0	1701.0

#ID = MA0772
#Short = IRF7
#Long = Interferon regulatory factor 7
#W = 13
#Class = 3.5.3.0.7
#Factors = IRF7
#Organisms = human (Homo sapiens)
#Interactions = M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00226,M00302,M00339,M00340,M00492,M00496
#Alternatives = M00453,HM0603,HM0604,MA0772_2,MA0772_1
#UniProt = Q92985
#Jaspar = MA0772.2
#Evidence = HT-SELEX
#PubMed = 10938111
97.0	957.0	50.0	46.0
36.0	67.0	957.0	90.0
957.0	3.0	1.0	0.0
957.0	0.0	0.0	1.0
957.0	2.0	1.0	1.0
279.0	156.0	505.0	17.0
8.0	582.0	2.0	375.0
30.0	3.0	957.0	7.0
957.0	16.0	4.0	5.0
957.0	3.0	3.0	1.0
957.0	10.0	7.0	41.0
1184.0	957.0	1235.0	301.0
160.0	153.0	31.0	804.0

#ID = MA0653
#Short = IRF9
#Long = Interferon regulatory factor 9
#W = 15
#Class = 3.5.3.0.9
#Factors = IRF9
#Organisms = human (Homo sapiens)
#Interactions = HM1139,MA0517,MA0517_1,MA0517_2,MA1623,MA1623_1,MA1623_2
#Alternatives = HM0608,MA0653_1
#UniProt = Q00978
#Jaspar = MA0653.1
#Evidence = HT-SELEX
#PubMed = 21731497
3467.0	52.0	43.0	110.0
2392.0	498.0	204.0	1076.0
49.0	3467.0	33.0	118.0
43.0	3.0	3467.0	5.0
3467.0	5.0	1.0	0.0
3467.0	0.0	0.0	3.0
3467.0	2.0	0.0	1.0
43.0	3467.0	197.0	9.0
16.0	3467.0	0.0	831.0
2.0	0.0	3467.0	1.0
3467.0	2.0	0.0	0.0
3467.0	1.0	0.0	21.0
3467.0	0.0	0.0	3.0
4.0	3467.0	239.0	2.0
99.0	1129.0	7.0	2338.0

#ID = MA0652
#Short = IRF8
#Long = Interferon regulatory factor 8
#W = 13
#Class = 3.5.3.0.8
#Factors = IRF8
#Organisms = human (Homo sapiens)
#Interactions = HM0601,HM0602,MA1509,MA1509_1
#Alternatives = HM0605,HM0606,HM0607,MA0652_2,MA0652_1
#UniProt = Q02556
#Jaspar = MA0652.2
#Evidence = HT-SELEX
#PubMed = 21731497
63.0	5878.0	19.0	884.0
3.0	0.0	5878.0	2.0
5878.0	2.0	0.0	0.0
5878.0	0.0	0.0	33.0
5878.0	0.0	0.0	3.0
54.0	5878.0	580.0	6.0
6.0	5878.0	0.0	1228.0
0.0	0.0	5878.0	0.0
5878.0	0.0	3.0	0.0
5878.0	0.0	2.0	68.0
5878.0	5.0	0.0	0.0
11.0	5878.0	1061.0	15.0
321.0	1454.0	8.0	5878.0

#ID = MA1418
#Short = IRF3
#Long = Interferon regulatory factor 3
#W = 17
#Class = 3.5.3.0.3
#Factors = IRF3
#Organisms = human (Homo sapiens)
#Interactions = HM0592,HM0594,HM0595,HM0694,HM0695,M00062,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0117,MA0117_1,MA0117_2,MA0117_3,MA1418,MA1418_1,MA1418_2
#Alternatives = HM0594,HM0595,MA1418_2,MA1418_1
#UniProt = Q14653
#Jaspar = MA1418.2
#Evidence = HT-SELEX
#PubMed = 10938111
8451.0	700.0	14773.0	2099.0
12887.0	17.0	9047.0	629.0
18311.0	83.0	3484.0	2153.0
19157.0	214.0	193.0	377.0
14210.0	14600.0	5575.0	6865.0
288.0	7338.0	26852.0	3058.0
154.0	14.0	27999.0	19.0
19385.0	15.0	55.0	10.0
19350.0	15.0	59.0	54.0
19428.0	22.0	43.0	324.0
423.0	18363.0	1150.0	864.0
711.0	18316.0	3396.0	2348.0
394.0	8.0	27995.0	8.0
19322.0	137.0	83.0	26.0
19386.0	51.0	36.0	486.0
19410.0	84.0	56.0	787.0
569.0	17758.0	3274.0	516.0

#ID = MA1419
#Short = IRF4
#Long = Interferon regulatory factor 4
#W = 14
#Class = 3.5.3.0.4
#Factors = IRF4
#Organisms = human (Homo sapiens)
#Interactions = HM0231,HM0232,MA1634,MA1634_1,MA1634_2
#Alternatives = HM0596,HM0597,HM0598,MA1419_2,MA1419_1
#UniProt = Q15306
#Jaspar = MA1419.2
#Evidence = HT-SELEX
#PubMed = 25896227
364.0	45331.0	87.0	5937.0
350.0	66.0	45331.0	31.0
45331.0	124.0	91.0	112.0
45331.0	8.0	25.0	444.0
45331.0	6.0	4.0	8.0
187.0	45331.0	593.0	497.0
27.0	45331.0	4.0	3801.0
57.0	6.0	45331.0	3.0
45331.0	46.0	7.0	5.0
45331.0	11.0	23.0	1002.0
45331.0	15.0	4.0	13.0
829.0	45331.0	4251.0	80.0
1377.0	17589.0	253.0	27742.0
25202.0	4640.0	5644.0	9846.0

#ID = MA1420
#Short = IRF5
#Long = Interferon regulatory factor 5
#W = 14
#Class = 3.5.3.0.5
#Factors = IRF5
#Organisms = human (Homo sapiens)
#Interactions = HM0599,HM0600,HM1188,MA0107,MA0107_1,MA1420,MA1420_1
#Alternatives = HM0599,HM0600,MA1420_1
#UniProt = Q13568
#Jaspar = MA1420.1
#Evidence = HT-SELEX
#PubMed = 25896227
35.0	169.0	22.0	42.0
10.0	177.0	17.0	38.0
15.0	3.0	357.0	21.0
223.0	2.0	6.0	7.0
224.0	5.0	4.0	44.0
225.0	0.0	5.0	1.0
1.0	180.0	0.0	4.0
0.0	182.0	0.0	37.0
105.0	30.0	365.0	8.0
224.0	11.0	7.0	1.0
206.0	6.0	25.0	40.0
223.0	84.0	12.0	15.0
29.0	171.0	25.0	22.0
22.0	80.0	23.0	157.0

#ID = MA0050
#Short = Irf1
#Long = Interferon regulatory factor 1
#W = 11
#Class = 3.5.3.0.1
#Factors = Irf1
#Organisms = mouse (Mus musculus)
#Interactions = HM0594,HM0595,HM0771,HM0772,M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00258,M00302,M00339,M00340,M00453,M00492,M00496,MA0150,MA0150_1,MA0150_2,MA0150_3,MA1418,MA1418_1,MA1418_2
#Alternatives = M00062,HM0592,HM0593,MA0050_4,MA0050_1,MA0050_2,MA0050_3,MA0051,MA0051_1,MA0051_2
#UniProt = P15314
#Jaspar = MA0050.4
#PubMed = 21803131
3724.0	1292.0	2035.0	8589.0
1661.0	637.0	12682.0	660.0
13772.0	361.0	1024.0	483.0
14795.0	253.0	258.0	334.0
14878.0	176.0	240.0	346.0
1939.0	9822.0	3315.0	564.0
1900.0	933.0	274.0	12533.0
1017.0	314.0	14013.0	296.0
14145.0	298.0	775.0	422.0
14424.0	353.0	499.0	364.0
14172.0	365.0	607.0	496.0

#ID = MA0051
#Short = IRF2
#Long = Interferon regulatory factor 2
#W = 16
#Class = 3.5.3.0.2
#Factors = IRF2
#Organisms = human (Homo sapiens)
#Interactions = HM0425,HM0426,M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00258,M00302,M00339,M00340,M00453,M00492,M00496,MA0852,MA0852_1,MA0852_2,MA0852_3,MA1103,MA1103_1,MA1103_2,MA1103_3
#Alternatives = M00063,HM0592,HM0593,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0051_2,MA0051_1
#UniProt = P14316
#Jaspar = MA0051.2
#Evidence = SELEX
#PubMed = 7687740
0.0	4.0	7.0	1.0
2.0	0.0	10.0	0.0
12.0	0.0	0.0	0.0
11.0	0.0	0.0	1.0
12.0	0.0	0.0	0.0
2.0	0.0	10.0	0.0
0.0	6.0	0.0	6.0
0.0	0.0	12.0	0.0
12.0	0.0	0.0	0.0
12.0	0.0	0.0	0.0
12.0	0.0	0.0	0.0
0.0	6.0	6.0	0.0
0.0	7.0	2.0	3.0
5.0	2.0	3.0	2.0
6.0	0.0	2.0	4.0
6.0	1.0	1.0	4.0

#ID = M00453
#Short = V$IRF7_01
#Long = IRF-7 (interferon regulatory factor 7)
#W = 18
#Factors = IRF-7A
#Organisms = human (Homo sapiens)
#Interactions = HM0367,HM0368,HM0369,HM0370,HM0592,HM0593,HM1137,HM1138,M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00226,M00259,M00302,M00339,M00340,M00492,M00496,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0051,MA0051_1,MA0051_2,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA1484,MA1484_1,MA1484_2
#Alternatives = HM0603,HM0604,MA0772,MA0772_1,MA0772_2
#Transfac class = C0022
1.0	1.0	1.0	4.0
3.0	1.0	2.0	1.0
1.0	4.0	6.0	0.0
3.0	2.0	22.0	1.0
26.0	0.0	2.0	0.0
28.0	0.0	0.0	0.0
17.0	0.0	0.0	11.0
4.0	5.0	6.0	13.0
0.0	16.0	4.0	8.0
2.0	1.0	24.0	1.0
27.0	0.0	0.0	1.0
26.0	2.0	0.0	0.0
19.0	1.0	3.0	5.0
5.0	6.0	10.0	7.0
3.0	7.0	1.0	16.0
3.0	5.0	8.0	9.0
7.0	3.0	10.0	5.0
5.0	8.0	9.0	3.0

#ID = MA1509
#Short = IRF6
#Long = Interferon regulatory factor 6
#W = 9
#Class = 3.5.3.0.6
#Factors = IRF6
#Organisms = human (Homo sapiens)
#Interactions = HM0605,HM0606,HM0607,HM0964,HM0965,M00512,M00515,M00528,MA0065_2,MA0065_3,MA0066,MA0066_1,MA0066_2,MA0652,MA0652_1,MA0652_2
#Alternatives = HM0601,HM0602,MA1509_1
#UniProt = O14896
#Jaspar = MA1509.1
#Evidence = HT-SELEX
#PubMed = 18604160
2652.0	164.0	648.0	89.0
67.0	2652.0	62.0	561.0
0.0	2652.0	22.0	19.0
48.0	5.0	2652.0	9.0
2652.0	0.0	0.0	26.0
2314.0	0.0	9.0	338.0
2652.0	0.0	17.0	2.0
0.0	2652.0	12.0	0.0
98.0	368.0	7.0	2284.0

#ID = MA1888
#Short = Irf-b
#Long = Interferon-regulatory factor
#W = 15
#Class = 3.5.3
#Factors = Irf-b
#Organisms = vase tunicate (Ciona intestinalis)
#Alternatives = MA1888_2,MA1888_1
#Jaspar = MA1888.2
#Evidence = SELEX
#PubMed = 32750546
124.0	22.0	842.0	12.0
858.0	47.0	70.0	25.0
419.0	10.0	259.0	312.0
940.0	14.0	31.0	15.0
126.0	676.0	168.0	30.0
97.0	176.0	79.0	648.0
299.0	226.0	263.0	213.0
199.0	207.0	388.0	207.0
883.0	10.0	85.0	21.0
15.0	71.0	880.0	33.0
19.0	3.0	4.0	974.0
259.0	56.0	14.0	672.0
10.0	19.0	36.0	935.0
29.0	917.0	14.0	40.0
107.0	33.0	829.0	31.0

#ID = M00062
#Short = V$IRF1_01
#Long = IRF-1 (interferon regulatory factor 1)
#W = 13
#Class = 3.5.3.0.1
#Factors = irf1
#Organisms = chick (Gallus gallus),rat (Rattus norvegicus),human (Homo sapiens),cattle (Bos taurus),sheep (Ovis aries),mouse (Mus musculus)
#Interactions = HM0592,HM0593,HM0594,HM0595,HM0603,HM0604,HM0771,HM0772,HM0800,HM0998,HM1137,HM1138,HM1140,HM1188,M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00225,M00258,M00259,M00302,M00339,M00340,M00453,M00492,M00496,M00497,MA0045,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0051,MA0051_1,MA0051_2,MA0061,MA0101,MA0101_1,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0517,MA0517_1,MA0517_2,MA0772,MA0772_1,MA0772_2,MA1418,MA1418_1,MA1418_2,MA1911,MA1911_1,MA1911_2,MA2264,MA2264_1
#Alternatives = HM0592,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4
#Transfac class = C0022
0.0	8.0	12.0	1.0
9.0	0.0	0.0	0.0
21.0	0.0	0.0	0.0
20.0	0.0	0.0	1.0
21.0	0.0	0.0	0.0
1.0	4.0	12.0	1.0
0.0	10.0	0.0	11.0
1.0	0.0	19.0	0.0
21.0	0.0	0.0	0.0
20.0	1.0	0.0	0.0
21.0	0.0	0.0	0.0
1.0	14.0	6.0	0.0
1.0	13.0	1.0	6.0

#ID = M00063
#Short = V$IRF2_01
#Long = IRF-2 (interferon regulatory factor 2)
#W = 13
#Class = 3.5.3.0.2
#Factors = IRF-2
#Organisms = human (Homo sapiens),sheep (Ovis aries),mouse (Mus musculus)
#Interactions = HM0425,HM0426,HM0592,HM0593,HM0603,HM0604,M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00258,M00302,M00339,M00340,M00453,M00492,M00496,MA0050,MA0050_1,MA0050_2,MA0050_3,MA0050_4,MA0051,MA0051_1,MA0051_2,MA0772,MA0772_1,MA0772_2,MA0852,MA0852_1,MA0852_2,MA0852_3,MA1103,MA1103_1,MA1103_2,MA1103_3
#Alternatives = HM0593,MA0051,MA0051_1,MA0051_2
#Transfac class = C0022
0.0	1.0	14.0	0.0
4.0	0.0	0.0	0.0
14.0	0.0	0.0	1.0
15.0	0.0	0.0	0.0
15.0	0.0	0.0	0.0
0.0	1.0	12.0	0.0
0.0	7.0	0.0	8.0
0.0	0.0	15.0	0.0
15.0	0.0	0.0	0.0
15.0	0.0	0.0	0.0
15.0	0.0	0.0	0.0
0.0	8.0	7.0	0.0
0.0	8.0	2.0	5.0

#ID = HM0605
#Short = IRF8
#Long = Interferon regulatory factor 8
#W = 19
#Class = 3.5.3.0.8
#Factors = IRF8,ICSBP1,Icsbp,IRF-8,Interferon consensus sequence-binding protein,H-ICSBP
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0601,HM0602,MA1509,MA1509_1
#Alternatives = HM0606,HM0607,MA0652,MA0652_1,MA0652_2
#HOCOMOCOv13 = IRF8.H13CORE.0.P.B
#UniProt = Q02556,P23611
#HGNC = 5358
#GeneCards = IRF8
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 96395
#Entrez = 3394,15900
406.0	84.0	180.0	166.0
554.0	43.0	79.0	160.0
217.0	134.0	417.0	68.0
311.0	97.0	222.0	206.0
207.0	105.0	517.0	7.0
364.0	4.0	467.0	1.0
742.0	9.0	21.0	64.0
804.0	6.0	3.0	23.0
125.0	290.0	386.0	35.0
92.0	58.0	22.0	664.0
13.0	0.0	820.0	3.0
787.0	8.0	37.0	4.0
790.0	4.0	36.0	6.0
827.0	2.0	4.0	3.0
74.0	354.0	402.0	6.0
120.0	204.0	23.0	489.0
344.0	108.0	277.0	107.0
345.0	117.0	266.0	108.0
322.0	152.0	211.0	151.0

#ID = HM0606
#Short = IRF8
#Long = Interferon regulatory factor 8
#W = 17
#Class = 3.5.3.0.8
#Factors = IRF8,ICSBP1,Icsbp,IRF-8,Interferon consensus sequence-binding protein,H-ICSBP
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0601,HM0602,MA1509,MA1509_1
#Alternatives = HM0605,HM0607,MA0652,MA0652_1,MA0652_2
#HOCOMOCOv13 = IRF8.H13CORE.1.SM.B
#UniProt = Q02556,P23611
#HGNC = 5358
#GeneCards = IRF8
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 1
#MGI = 96395
#Entrez = 3394,15900
5418.0	1381.0	1017.0	2174.0
2739.0	2398.0	2786.0	2067.0
917.0	3880.0	744.0	4452.0
305.0	140.0	9445.0	103.0
9441.0	208.0	216.0	128.0
9386.0	55.0	100.0	452.0
9801.0	59.0	11.0	122.0
79.0	7040.0	2827.0	47.0
45.0	3492.0	45.0	6411.0
126.0	2.0	9860.0	5.0
9633.0	212.0	79.0	69.0
9138.0	33.0	213.0	609.0
9737.0	101.0	32.0	123.0
177.0	7671.0	1976.0	169.0
678.0	3132.0	294.0	5889.0
4114.0	1079.0	3514.0	1284.0
3496.0	2347.0	2085.0	2062.0

#ID = HM0607
#Short = IRF8
#Long = Interferon regulatory factor 8
#W = 14
#Class = 3.5.3.0.8
#Factors = IRF8,ICSBP1,Icsbp,IRF-8,Interferon consensus sequence-binding protein,H-ICSBP
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0601,HM0602,MA1509,MA1509_1
#Alternatives = HM0605,HM0606,MA0652,MA0652_1,MA0652_2
#HOCOMOCOv13 = IRF8.H13CORE.2.SM.B
#UniProt = Q02556,P23611
#HGNC = 5358
#GeneCards = IRF8
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 2
#MGI = 96395
#Entrez = 3394,15900
1968.0	1522.0	5380.0	1048.0
5762.0	1143.0	2137.0	878.0
6678.0	785.0	1075.0	1382.0
8443.0	419.0	216.0	842.0
1454.0	4509.0	1910.0	2047.0
141.0	7877.0	69.0	1833.0
82.0	32.0	9774.0	32.0
9779.0	55.0	34.0	52.0
9621.0	31.0	35.0	233.0
9768.0	41.0	30.0	81.0
109.0	8347.0	1370.0	94.0
550.0	3150.0	171.0	6049.0
4219.0	1219.0	3267.0	1215.0
3716.0	2417.0	2145.0	1642.0

#ID = HM0608
#Short = IRF9
#Long = Interferon regulatory factor 9
#W = 16
#Class = 3.5.3.0.9
#Factors = IRF9,ISGF3G,IRF-9,IFN-alpha-responsive transcription factor subunit,ISGF3 p48 subunit,Interferon-stimulated gene factor 3 gamma,ISGF-3 gamma,Transcriptional regulator ISGF3 subunit gamma
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM1139,MA0517,MA0517_1,MA0517_2,MA1623,MA1623_1,MA1623_2
#Alternatives = MA0653,MA0653_1
#HOCOMOCOv13 = IRF9.H13CORE.0.PSM.A
#UniProt = Q00978,Q61179
#HGNC = 6131
#GeneCards = IRF9
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX,Methyl-HT-SELEX
#Subtype = 0
#MGI = 107587
#Entrez = 10379,16391
2285.0	2614.0	3134.0	1957.0
817.0	4422.0	1526.0	3227.0
428.0	204.0	9174.0	186.0
9265.0	246.0	288.0	193.0
9338.0	70.0	177.0	407.0
9729.0	84.0	49.0	130.0
148.0	6205.0	3581.0	58.0
56.0	3237.0	38.0	6661.0
82.0	3.0	9881.0	26.0
9774.0	136.0	38.0	44.0
9269.0	30.0	123.0	570.0
9709.0	130.0	45.0	108.0
122.0	7210.0	2553.0	107.0
633.0	3399.0	408.0	5552.0
2609.0	1577.0	3473.0	2330.0
4304.0	1905.0	1808.0	1973.0

#ID = HM0600
#Short = IRF5
#Long = Interferon regulatory factor 5
#W = 11
#Class = 3.5.3.0.5
#Factors = IRF5,IRF-5
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0599,HM0600,HM1188,MA0107,MA0107_1,MA1420,MA1420_1
#Alternatives = HM0599,MA1420,MA1420_1
#HOCOMOCOv13 = IRF5.H13CORE.1.S.B
#UniProt = Q13568,P56477
#HGNC = 6120
#GeneCards = IRF5
#HMQuality = B
#Evidence = HT-SELEX
#Subtype = 1
#MGI = 1350924
#Entrez = 3663,27056
97.0	96.0	65.0	53.0
165.0	59.0	32.0	55.0
64.0	157.0	65.0	27.0
0.0	256.0	53.0	4.0
0.0	0.0	313.0	0.0
313.0	0.0	0.0	0.0
312.0	0.0	0.0	1.0
311.0	1.0	0.0	1.0
1.0	262.0	50.0	0.0
48.0	96.0	44.0	123.0
85.0	82.0	71.0	75.0

#ID = HM0601
#Short = IRF6
#Long = Interferon regulatory factor 6
#W = 11
#Class = 3.5.3.0.6
#Factors = IRF6,IRF-6
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0605,HM0606,HM0607,HM0964,HM0965,M00512,M00515,M00528,MA0065_2,MA0065_3,MA0066,MA0066_1,MA0066_2,MA0652,MA0652_1,MA0652_2
#Alternatives = HM0602,MA1509,MA1509_1
#HOCOMOCOv13 = IRF6.H13CORE.0.SM.B
#UniProt = O14896,P97431
#HGNC = 6121
#GeneCards = IRF6
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 0
#MGI = 1859211
#Entrez = 3664,54139
2674.0	2213.0	1208.0	1949.0
4600.0	1487.0	1129.0	825.0
738.0	5091.0	875.0	1340.0
17.0	7973.0	0.0	54.0
0.0	0.0	8044.0	0.0
8044.0	0.0	0.0	0.0
5572.0	0.0	0.0	2472.0
8044.0	0.0	0.0	0.0
0.0	8044.0	0.0	0.0
146.0	3112.0	197.0	4589.0
2234.0	1894.0	2621.0	1294.0

#ID = HM0602
#Short = IRF6
#Long = Interferon regulatory factor 6
#W = 17
#Class = 3.5.3.0.6
#Factors = IRF6,IRF-6
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0605,HM0606,HM0607,HM0964,HM0965,M00512,M00515,M00528,MA0065_2,MA0065_3,MA0066,MA0066_1,MA0066_2,MA0652,MA0652_1,MA0652_2
#Alternatives = HM0601,MA1509,MA1509_1
#HOCOMOCOv13 = IRF6.H13CORE.1.S.C
#UniProt = O14896,P97431
#HGNC = 6121
#GeneCards = IRF6
#HMQuality = C
#Evidence = HT-SELEX
#Subtype = 1
#MGI = 1859211
#Entrez = 3664,54139
299.0	342.0	189.0	310.0
492.0	361.0	186.0	103.0
202.0	480.0	291.0	169.0
80.0	831.0	63.0	168.0
99.0	121.0	868.0	54.0
928.0	84.0	82.0	48.0
656.0	101.0	20.0	365.0
1126.0	12.0	3.0	1.0
1.0	1090.0	14.0	37.0
3.0	1116.0	1.0	22.0
1.0	0.0	1141.0	0.0
1142.0	0.0	0.0	0.0
827.0	0.0	0.0	315.0
1142.0	0.0	0.0	0.0
0.0	1135.0	7.0	0.0
36.0	442.0	41.0	623.0
359.0	300.0	306.0	176.0

#ID = HM0603
#Short = IRF7
#Long = Interferon regulatory factor 7
#W = 19
#Class = 3.5.3.0.7
#Factors = IRF7,IRF-7
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00226,M00302,M00339,M00340,M00492,M00496
#Alternatives = M00453,HM0604,MA0772,MA0772_1,MA0772_2
#HOCOMOCOv13 = IRF7.H13CORE.1.SM.B
#UniProt = Q92985,P70434
#HGNC = 6122
#GeneCards = IRF7
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 1
#MGI = 1859212
#Entrez = 3665,54123
1530.0	3358.0	2199.0	1860.0
4173.0	1424.0	2574.0	777.0
6237.0	506.0	735.0	1472.0
6351.0	969.0	296.0	1334.0
2554.0	2783.0	1446.0	2167.0
139.0	8148.0	161.0	502.0
26.0	31.0	8849.0	44.0
8887.0	52.0	3.0	8.0
8910.0	24.0	6.0	10.0
8754.0	27.0	0.0	169.0
2659.0	2366.0	3238.0	687.0
222.0	5187.0	222.0	3319.0
598.0	1807.0	5881.0	664.0
5809.0	477.0	1966.0	698.0
6805.0	643.0	511.0	991.0
6411.0	792.0	401.0	1346.0
2499.0	2237.0	2325.0	1889.0
1279.0	2749.0	1062.0	3857.0
2305.0	1914.0	2326.0	2405.0

#ID = HM0604
#Short = IRF7
#Long = Interferon regulatory factor 7
#W = 14
#Class = 3.5.3.0.7
#Factors = IRF7,IRF-7
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = M00032,M00033,M00053,M00062,M00063,M00074,M00223,M00224,M00226,M00302,M00339,M00340,M00492,M00496
#Alternatives = M00453,HM0603,MA0772,MA0772_1,MA0772_2
#HOCOMOCOv13 = IRF7.H13CORE.0.S.B
#UniProt = Q92985,P70434
#HGNC = 6122
#GeneCards = IRF7
#HMQuality = B
#Evidence = HT-SELEX
#Subtype = 0
#MGI = 1859212
#Entrez = 3665,54123
2122.0	2486.0	1865.0	1304.0
594.0	4456.0	977.0	1752.0
4782.0	658.0	2025.0	315.0
7103.0	156.0	148.0	373.0
7117.0	300.0	65.0	298.0
2592.0	2370.0	1101.0	1717.0
62.0	7628.0	54.0	36.0
0.0	0.0	7780.0	0.0
7773.0	6.0	0.0	1.0
7393.0	4.0	42.0	341.0
6831.0	39.0	37.0	873.0
3347.0	1057.0	1323.0	2053.0
288.0	1702.0	328.0	5459.0
1739.0	3491.0	1586.0	963.0

#ID = M00184
#Short = V$MYOD_Q6
#Long = MyoD (myoblast determining factor)
#W = 10
#Class = 1.2.2.1.1
#Factors = MyoD,MyoD (376 AA),MyoD (275 AA)
#Organisms = human (Homo sapiens),zebra fish (Brachydanio rerio),mouse (Mus musculus),quail (Coturnix coturnix),chick (Gallus gallus),clawed frog (Xenopus laevis),common carp (Cyprinus carpio),rat (Rattus norvegicus),monkey (Cercopithecus aethiops),rainbow trout (Oncorhynchus mykiss)
#Interactions = HM0269,HM0270,HM0279,HM0393,HM0394,HM0395,HM0439,HM0440,HM0484,HM0485,HM0521,HM0624,HM0625,HM0710,HM0746,HM0908,HM0909,HM0910,HM0916,HM0917,HM1014,HM1137,HM1138,HM1140,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00002,M00004,M00006,M00026,M00033,M00041,M00065,M00066,M00070,M00071,M00096,M00124,M00155,M00172,M00173,M00174,M00183,M00184,M00188,M00199,M00218,M00219,M00222,M00223,M00224,M00225,M00231,M00232,M00233,M00259,M00403,M00405,M00406,M00407,M00436,M00454,M00492,M00496,M00497,M00517,MA0017,MA0017_1,MA0017_2,MA0017_3,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0034,MA0034_1,MA0034_2,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5,MA0054,MA0054_1,MA0055,MA0070,MA0070_1,MA0070_2,MA0071,MA0071_1,MA0072,MA0072_1,MA0072_2,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0100,MA0100_1,MA0100_2,MA0100_3,MA0100_4,MA0114,MA0114_1,MA0114_2,MA0114_3,MA0114_4,MA0114_5,MA0132,MA0132_1,MA0132_2,MA0132_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0517,MA0517_1,MA0517_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0940,MA0940_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1494,MA1494_1,MA1494_2,MA1537,MA1537_1,MA1537_2,MA1538,MA1538_1,MA1849,MA1849_1,MA1849_2,MA1951,MA1951_1,MA1951_2,MA2173,MA2173_1,MA2388,MA2388_1
#Alternatives = M00001
#Transfac class = C0010
5.0	2.0	3.0	4.0
3.0	5.0	5.0	1.0
0.0	14.0	0.0	0.0
14.0	0.0	0.0	0.0
1.0	7.0	3.0	3.0
0.0	12.0	1.0	1.0
0.0	0.0	0.0	14.0
0.0	0.0	14.0	0.0
2.0	4.0	2.0	6.0
0.0	9.0	0.0	5.0

#ID = M00001
#Short = V$MYOD_01
#Long = MyoD (myoblast determination gene product)
#W = 12
#Class = 1.2.2.1.1
#Factors = MyoD,MyoD (376 AA),MyoD (275 AA)
#Organisms = chick (Gallus gallus),clawed frog (Xenopus laevis),common carp (Cyprinus carpio),rat (Rattus norvegicus),monkey (Cercopithecus aethiops),human (Homo sapiens),rainbow trout (Oncorhynchus mykiss),zebra fish (Brachydanio rerio),mouse (Mus musculus),quail (Coturnix coturnix)
#Interactions = HM0269,HM0270,HM0279,HM0393,HM0394,HM0395,HM0439,HM0440,HM0484,HM0485,HM0521,HM0624,HM0625,HM0710,HM0746,HM0908,HM0909,HM0910,HM0916,HM0917,HM1014,HM1137,HM1138,HM1140,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00002,M00004,M00006,M00026,M00033,M00041,M00065,M00066,M00070,M00071,M00096,M00124,M00155,M00172,M00173,M00174,M00183,M00184,M00188,M00199,M00218,M00219,M00222,M00223,M00224,M00225,M00231,M00232,M00233,M00259,M00403,M00405,M00406,M00407,M00436,M00454,M00492,M00496,M00497,M00517,MA0017,MA0017_1,MA0017_2,MA0017_3,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0034,MA0034_1,MA0034_2,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5,MA0054,MA0054_1,MA0055,MA0070,MA0070_1,MA0070_2,MA0071,MA0071_1,MA0072,MA0072_1,MA0072_2,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0100,MA0100_1,MA0100_2,MA0100_3,MA0100_4,MA0114,MA0114_1,MA0114_2,MA0114_3,MA0114_4,MA0114_5,MA0132,MA0132_1,MA0132_2,MA0132_3,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0517,MA0517_1,MA0517_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0940,MA0940_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1494,MA1494_1,MA1494_2,MA1537,MA1537_1,MA1537_2,MA1538,MA1538_1,MA1849,MA1849_1,MA1849_2,MA1951,MA1951_1,MA1951_2,MA2173,MA2173_1,MA2388,MA2388_1
#Alternatives = M00184
#Transfac class = C0010
1.0	2.0	2.0	0.0
2.0	1.0	2.0	0.0
3.0	0.0	1.0	1.0
0.0	5.0	0.0	0.0
5.0	0.0	0.0	0.0
0.0	0.0	4.0	1.0
0.0	1.0	4.0	0.0
0.0	0.0	0.0	5.0
0.0	0.0	5.0	0.0
0.0	1.0	2.0	2.0
0.0	2.0	0.0	3.0
1.0	0.0	3.0	1.0

#ID = HM0759
#Short = MYOD1
#Long = Myoblast determination protein 1
#W = 10
#Class = 1.2.2.1.1
#Factors = MYOD1,BHLHC1,MYF3,MYOD,Class C basic helix-loop-helix protein 1,Myogenic factor 3,Myf-3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0390,HM0710,HM1170,HM1171,HM1198,MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5,MA0091,MA0091_1,MA0091_2,MA0522,MA0522_1,MA0522_2,MA0522_3,MA0522_4,MA0820,MA0820_1,MA0820_2,MA0832,MA0832_1,MA0832_2,MA1568,MA1568_1,MA1568_2,MA1934,MA1934_1,MA1934_2,MA1941,MA1941_1,MA1941_2,MA1945,MA1945_1,MA1945_2
#Alternatives = HM0758,MA0499,MA0499_1,MA0499_2,MA0499_3
#HOCOMOCOv13 = MYOD1.H13CORE.1.PSM.A
#UniProt = P15172,P10085
#HGNC = 7611
#GeneCards = MYOD1
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX,Methyl-HT-SELEX
#Subtype = 1
#MGI = 97275
#Entrez = 4654,17927
206.0	258.0	414.0	118.0
12.0	966.0	5.0	13.0
958.0	6.0	6.0	26.0
9.0	310.0	628.0	49.0
18.0	951.0	3.0	24.0
5.0	3.0	0.0	988.0
5.0	10.0	971.0	10.0
9.0	317.0	16.0	654.0
7.0	422.0	57.0	510.0
232.0	353.0	242.0	169.0

#ID = HM0758
#Short = MYOD1
#Long = Myoblast determination protein 1
#W = 15
#Class = 1.2.2.1.1
#Factors = MYOD1,BHLHC1,MYF3,MYOD,Class C basic helix-loop-helix protein 1,Myogenic factor 3,Myf-3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0390,HM0710,HM1170,HM1171,HM1198,MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5,MA0091,MA0091_1,MA0091_2,MA0522,MA0522_1,MA0522_2,MA0522_3,MA0522_4,MA0820,MA0820_1,MA0820_2,MA0832,MA0832_1,MA0832_2,MA1568,MA1568_1,MA1568_2,MA1934,MA1934_1,MA1934_2,MA1941,MA1941_1,MA1941_2,MA1945,MA1945_1,MA1945_2
#Alternatives = HM0759,MA0499,MA0499_1,MA0499_2,MA0499_3
#HOCOMOCOv13 = MYOD1.H13CORE.0.P.B
#UniProt = P15172,P10085
#HGNC = 7611
#GeneCards = MYOD1
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 97275
#Entrez = 4654,17927
233.0	233.0	425.0	109.0
2.0	996.0	0.0	2.0
990.0	1.0	3.0	6.0
6.0	155.0	814.0	25.0
8.0	981.0	3.0	8.0
4.0	2.0	0.0	994.0
0.0	2.0	998.0	0.0
0.0	359.0	35.0	606.0
5.0	306.0	68.0	621.0
128.0	338.0	349.0	185.0
97.0	486.0	128.0	289.0
151.0	230.0	192.0	427.0
204.0	148.0	433.0	215.0
106.0	312.0	243.0	339.0
171.0	452.0	174.0	203.0

#ID = MA0499
#Short = MYOD1
#Long = Myoblast determination protein 1
#W = 9
#Class = 1.2.2.1.1
#Factors = MYOD1
#Organisms = human (Homo sapiens)
#Interactions = HM0390,HM0710,HM1170,HM1171,HM1198,MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5,MA0091,MA0091_1,MA0091_2,MA0522,MA0522_1,MA0522_2,MA0522_3,MA0522_4,MA0820,MA0820_1,MA0820_2,MA0832,MA0832_1,MA0832_2,MA1568,MA1568_1,MA1568_2,MA1934,MA1934_1,MA1934_2,MA1941,MA1941_1,MA1941_2,MA1945,MA1945_1,MA1945_2
#Alternatives = HM0758,HM0759,MA0499_3,MA0499_1,MA0499_2
#UniProt = P15172
#Jaspar = MA0499.3
#Evidence = ChIP-seq
#PubMed = 20412780
4549.0	5622.0	21884.0	2245.0
349.0	33328.0	354.0	269.0
32281.0	583.0	849.0	587.0
463.0	25275.0	7336.0	1226.0
534.0	32504.0	932.0	330.0
241.0	563.0	366.0	33130.0
208.0	386.0	33468.0	238.0
402.0	2555.0	1699.0	29644.0
1808.0	19052.0	4440.0	9000.0

#ID = MA0773
#Short = MEF2D
#Long = MEF2D protein
#W = 12
#Class = 5.1.1.1.4
#Factors = MEF2D,Q05BX2
#Organisms = human (Homo sapiens)
#Alternatives = HM0715,HM0716,MA0773_1
#UniProt = Q05BX2
#Jaspar = MA0773.1
#Evidence = HT-SELEX
#PubMed = 25217591
2120.0	109.0	1933.0	1642.0
28.0	5803.0	0.0	53.0
3.0	22.0	0.0	5803.0
5803.0	8.0	2.0	6.0
2782.0	0.0	2.0	3021.0
5803.0	4.0	0.0	778.0
5803.0	0.0	2.0	217.0
5803.0	2.0	1.0	69.0
0.0	0.0	0.0	5803.0
5803.0	0.0	4.0	0.0
339.0	17.0	5803.0	5.0
3206.0	2598.0	70.0	585.0

#ID = M00231
#Short = V$MEF2_02
#Long = MEF-2 (myogenic MADS factor MEF-2)
#W = 22
#Factors = MEF2A-isoform1,mef2a-isoform1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0439,HM0440,HM0484,HM0485,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00033,M00184,M00454,M00482,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0055,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA2388,MA2388_1
#Alternatives = M00006,M00232,M00233,MA2173,MA2173_1
#Transfac class = C0014
5.0	28.0	25.0	42.0
16.0	32.0	31.0	21.0
18.0	36.0	27.0	19.0
19.0	25.0	33.0	23.0
22.0	12.0	43.0	23.0
33.0	9.0	21.0	37.0
20.0	4.0	43.0	33.0
3.0	85.0	3.0	9.0
3.0	8.0	0.0	89.0
85.0	0.0	0.0	15.0
57.0	0.0	0.0	41.0
91.0	0.0	1.0	8.0
96.0	0.0	0.0	4.0
93.0	0.0	1.0	6.0
0.0	0.0	0.0	100.0
100.0	0.0	0.0	0.0
9.0	0.0	90.0	1.0
34.0	46.0	11.0	9.0
36.0	28.0	8.0	28.0
20.0	37.0	15.0	28.0
30.0	34.0	13.0	23.0
23.0	23.0	22.0	32.0

#ID = M00232
#Short = V$MEF2_03
#Long = MEF-2 (myogenic MADS factor MEF-2)
#W = 22
#Factors = MEF2A-isoform1,mef2a-isoform1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0439,HM0440,HM0484,HM0485,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00033,M00184,M00454,M00482,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0055,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA2388,MA2388_1
#Alternatives = M00006,M00231,M00233,MA2173,MA2173_1
#Transfac class = C0014
22.0	22.0	24.0	32.0
26.0	27.0	29.0	18.0
26.0	14.0	26.0	32.0
18.0	21.0	37.0	24.0
22.0	3.0	49.0	26.0
31.0	10.0	9.0	50.0
15.0	4.0	39.0	42.0
0.0	98.0	0.0	2.0
0.0	0.0	0.0	100.0
80.0	0.0	1.0	19.0
53.0	0.0	0.0	47.0
92.0	0.0	0.0	8.0
91.0	1.0	2.0	5.0
99.0	0.0	0.0	1.0
0.0	0.0	0.0	100.0
98.0	0.0	0.0	2.0
5.0	0.0	92.0	3.0
46.0	39.0	4.0	11.0
42.0	27.0	6.0	25.0
26.0	34.0	6.0	34.0
30.0	28.0	18.0	24.0
30.0	28.0	23.0	19.0

#ID = M00233
#Short = V$MEF2_04
#Long = MEF-2 (myogenic MADS factor MEF-2)
#W = 22
#Factors = MEF2A-isoform1,mef2a-isoform1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0439,HM0440,HM0484,HM0485,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00033,M00184,M00454,M00482,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0055,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA2388,MA2388_1
#Alternatives = M00006,M00231,M00232,MA2173,MA2173_1
#Transfac class = C0014
41.0	27.0	15.0	17.0
13.0	43.0	32.0	12.0
7.0	9.0	7.0	77.0
7.0	0.0	84.0	9.0
9.0	0.0	7.0	84.0
0.0	1.0	4.0	86.0
63.0	1.0	20.0	16.0
0.0	98.0	2.0	0.0
0.0	2.0	0.0	98.0
91.0	2.0	0.0	7.0
68.0	0.0	0.0	32.0
100.0	0.0	0.0	0.0
100.0	0.0	0.0	0.0
100.0	0.0	0.0	0.0
0.0	2.0	0.0	98.0
100.0	0.0	0.0	0.0
2.0	0.0	98.0	0.0
80.0	9.0	6.0	5.0
72.0	6.0	0.0	22.0
43.0	36.0	2.0	18.0
27.0	48.0	9.0	16.0
21.0	23.0	17.0	39.0

#ID = MA0660
#Short = MEF2B
#Long = Myocyte-specific enhancer factor 2B
#W = 12
#Class = 5.1.1.1.2
#Factors = MEF2B
#Organisms = human (Homo sapiens)
#Alternatives = HM0711,HM0712,MA0660_1
#UniProt = Q02080
#Jaspar = MA0660.1
#Evidence = HT-SELEX
#PubMed = 9430690
1385.0	72.0	1766.0	505.0
18.0	3150.0	0.0	12.0
0.0	25.0	0.0	3150.0
3150.0	0.0	0.0	15.0
1495.0	2.0	0.0	1655.0
3150.0	0.0	12.0	710.0
3150.0	3.0	2.0	143.0
3150.0	0.0	0.0	45.0
0.0	0.0	0.0	3150.0
3150.0	3.0	2.0	3.0
98.0	19.0	3150.0	3.0
1013.0	2138.0	99.0	506.0

#ID = MA0052
#Short = MEF2A
#Long = Myocyte-specific enhancer factor 2A
#W = 10
#Class = 5.1.1.1.1
#Factors = MEF2A
#Organisms = human (Homo sapiens)
#Interactions = HM0724,HM0758,HM0759,HM0760,HM0798,HM0799,HM0926,M00001,M00026,M00033,M00184,M00242,M00403,M00405,M00406,M00407,M00482,M00518,MA0499,MA0499_1,MA0499_2,MA0499_3,MA0500,MA0500_1,MA0500_2,MA0500_3,MA0661,MA0661_1,MA0661_2,MA0671,MA0671_1,MA0671_2,MA1528,MA1528_1,MA1528_2,MA1547,MA1547_1,MA1547_2
#Alternatives = HM0710,MA0052_5,MA0052_1,MA0052_2,MA0052_3,MA0052_4
#UniProt = Q02078
#Jaspar = MA0052.5
#Evidence = ChIP-seq
#PubMed = 25217591
1984.0	10919.0	1007.0	2252.0
627.0	2974.0	236.0	12325.0
12437.0	1013.0	1066.0	1646.0
13132.0	253.0	610.0	2167.0
14680.0	141.0	506.0	835.0
14453.0	231.0	241.0	1237.0
14956.0	173.0	202.0	831.0
441.0	349.0	215.0	15157.0
15582.0	50.0	422.0	108.0
2566.0	1060.0	11104.0	1432.0

#ID = M00403
#Short = V$AMEF2_Q6
#Long = aMEF-2 (myocyte enhancer factor)
#W = 18
#Class = 5.1.1.1.1
#Factors = MEF2A-isoform1,aMEF-2,RSRFC9,RSRFC4,mef2a,mef2a-isoform2,mef2a-isoform1,mef2a-isoform3
#Organisms = human (Homo sapiens),mouse (Mus musculus),rat (Rattus norvegicus)
#Interactions = HM0439,HM0440,HM0484,HM0485,HM0710,HM0926,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00026,M00033,M00184,M00403,M00405,M00406,M00407,M00454,M00482,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5,MA0055,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0201,MA0201_1,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1547,MA1547_1,MA1547_2,MA2388,MA2388_1
#Transfac class = C0014
2.0	4.0	2.0	0.0
1.0	0.0	4.0	3.0
0.0	2.0	5.0	1.0
2.0	0.0	2.0	4.0
1.0	3.0	0.0	4.0
0.0	0.0	0.0	8.0
8.0	0.0	0.0	0.0
6.0	0.0	0.0	2.0
8.0	0.0	0.0	0.0
6.0	0.0	0.0	2.0
6.0	0.0	0.0	1.0
2.0	0.0	0.0	6.0
6.0	1.0	1.0	0.0
4.0	2.0	2.0	0.0
0.0	7.0	0.0	1.0
1.0	4.0	0.0	3.0
2.0	3.0	0.0	1.0
3.0	2.0	0.0	1.0

#ID = M00405
#Short = V$MMEF2_Q6
#Long = MEF-2 (myocyte enhancer factor)
#W = 16
#Class = 5.1.1.1.1
#Factors = MEF2A-isoform1,aMEF-2,RSRFC9,RSRFC4,mef2a,mef2a-isoform2,mef2a-isoform1,mef2a-isoform3
#Organisms = human (Homo sapiens),mouse (Mus musculus),rat (Rattus norvegicus)
#Interactions = HM0439,HM0440,HM0484,HM0485,HM0710,HM0926,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00026,M00033,M00184,M00403,M00405,M00406,M00407,M00454,M00482,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5,MA0055,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0201,MA0201_1,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1547,MA1547_1,MA1547_2,MA2388,MA2388_1
#Transfac class = C0014
2.0	5.0	2.0	0.0
1.0	0.0	4.0	4.0
0.0	3.0	5.0	1.0
2.0	1.0	2.0	5.0
2.0	3.0	0.0	5.0
0.0	0.0	0.0	10.0
10.0	0.0	0.0	0.0
8.0	0.0	0.0	2.0
10.0	0.0	0.0	0.0
7.0	0.0	0.0	3.0
7.0	0.0	0.0	3.0
4.0	1.0	0.0	5.0
5.0	2.0	3.0	0.0
4.0	4.0	1.0	0.0
1.0	6.0	1.0	1.0
1.0	5.0	0.0	3.0

#ID = M00406
#Short = V$HMEF2_Q6
#Long = MEF-2 (myocyte enhancer factor)
#W = 16
#Class = 5.1.1.1.1
#Factors = MEF2A-isoform1,aMEF-2,RSRFC9,RSRFC4,mef2a,mef2a-isoform2,mef2a-isoform1,mef2a-isoform3
#Organisms = human (Homo sapiens),mouse (Mus musculus),rat (Rattus norvegicus)
#Interactions = HM0439,HM0440,HM0484,HM0485,HM0710,HM0926,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00026,M00033,M00184,M00403,M00405,M00406,M00407,M00454,M00482,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5,MA0055,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0201,MA0201_1,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1547,MA1547_1,MA1547_2,MA2388,MA2388_1
#Transfac class = C0014
1.0	5.0	4.0	1.0
1.0	0.0	4.0	6.0
0.0	7.0	0.0	4.0
0.0	0.0	0.0	11.0
11.0	0.0	0.0	0.0
9.0	0.0	0.0	2.0
11.0	0.0	0.0	0.0
11.0	0.0	0.0	0.0
10.0	0.0	0.0	1.0
0.0	0.0	0.0	11.0
11.0	0.0	0.0	0.0
10.0	1.0	0.0	0.0
0.0	11.0	0.0	0.0
0.0	7.0	0.0	4.0
1.0	8.0	0.0	2.0
3.0	3.0	0.0	5.0

#ID = M00407
#Short = V$RSRFC4_Q2
#Long = RSRFC4 ((Related to) serum response factor-like protein 1) aka MEF-2A (Myocyte-specific enhancer factor 2A)
#W = 17
#Class = 5.1.1.1.1.3
#Quality = 2
#Factors = MEF2A-isoform1,aMEF-2,RSRFC9,RSRFC4,mef2a,mef2a-isoform2,mef2a-isoform1,mef2a-isoform3
#Organisms = human (Homo sapiens),mouse (Mus musculus),rat (Rattus norvegicus)
#Interactions = HM0439,HM0440,HM0484,HM0485,HM0710,HM0926,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00026,M00033,M00184,M00403,M00405,M00406,M00407,M00454,M00482,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5,MA0055,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0201,MA0201_1,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1547,MA1547_1,MA1547_2,MA2388,MA2388_1
#Alternatives = M00026
#Transfac class = C0014
17.0	3.0	2.0	3.0
6.0	2.0	4.0	9.0
3.0	0.0	13.0	9.0
0.0	22.0	1.0	4.0
0.0	0.0	0.0	27.0
27.0	0.0	0.0	0.0
14.0	0.0	0.0	13.0
19.0	0.0	0.0	8.0
23.0	0.0	0.0	4.0
27.0	0.0	0.0	0.0
0.0	0.0	0.0	27.0
27.0	0.0	0.0	0.0
3.0	0.0	24.0	0.0
14.0	10.0	1.0	1.0
8.0	7.0	0.0	12.0
4.0	9.0	1.0	10.0
4.0	5.0	8.0	7.0

#ID = M00006
#Short = V$MEF2_01
#Long = MEF-2 (myogenic enhancer factor 2)
#W = 16
#Class = 5.1.1.1.1
#Factors = mef2a-isoform1,MEF2A-isoform1,mef2a
#Organisms = human (Homo sapiens),rat (Rattus norvegicus),mouse (Mus musculus)
#Interactions = HM0439,HM0440,HM0484,HM0485,HM0926,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00033,M00184,M00454,M00482,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0055,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0201,MA0201_1,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1547,MA1547_1,MA1547_2,MA2388,MA2388_1
#Alternatives = M00231,M00232,M00233,MA2173,MA2173_1
#Transfac class = C0014
0.0	3.0	1.0	1.0
0.0	0.0	1.0	4.0
0.0	4.0	0.0	1.0
0.0	0.0	0.0	5.0
5.0	0.0	0.0	0.0
5.0	0.0	0.0	0.0
5.0	0.0	0.0	0.0
5.0	0.0	0.0	0.0
5.0	0.0	0.0	0.0
0.0	0.0	0.0	5.0
5.0	0.0	0.0	0.0
5.0	0.0	0.0	0.0
0.0	5.0	0.0	0.0
0.0	2.0	0.0	3.0
0.0	4.0	0.0	1.0
0.0	2.0	0.0	3.0

#ID = HM0715
#Short = MEF2D
#Long = Myocyte-specific enhancer factor 2D
#W = 13
#Class = 5.1.1.1.4
#Factors = MEF2D
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Alternatives = HM0716,MA0773,MA0773_1
#HOCOMOCOv13 = MEF2D.H13CORE.0.PS.A
#UniProt = Q14814,Q63943
#HGNC = 6997
#GeneCards = MEF2D
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX
#Subtype = 0
#MGI = 99533
#Entrez = 4209,17261
260.0	57.0	348.0	333.0
69.0	71.0	534.0	324.0
21.0	830.0	32.0	115.0
1.0	24.0	0.0	973.0
982.0	6.0	6.0	4.0
92.0	6.0	4.0	896.0
86.0	7.0	9.0	896.0
49.0	71.0	10.0	868.0
217.0	93.0	12.0	676.0
120.0	27.0	118.0	733.0
618.0	0.0	375.0	5.0
75.0	39.0	795.0	89.0
312.0	440.0	105.0	141.0

#ID = HM0716
#Short = MEF2D
#Long = Myocyte-specific enhancer factor 2D
#W = 16
#Class = 5.1.1.1.4
#Factors = MEF2D
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Alternatives = HM0715,MA0773,MA0773_1
#HOCOMOCOv13 = MEF2D.H13CORE.1.M.C
#UniProt = Q14814,Q63943
#HGNC = 6997
#GeneCards = MEF2D
#HMQuality = C
#Evidence = Methyl-HT-SELEX
#Subtype = 1
#MGI = 99533
#Entrez = 4209,17261
1190.0	1215.0	1935.0	2130.0
1328.0	4112.0	510.0	519.0
223.0	4344.0	269.0	1634.0
2562.0	1758.0	1150.0	1000.0
2787.0	1109.0	1262.0	1312.0
4540.0	94.0	386.0	1450.0
709.0	28.0	67.0	5666.0
1989.0	5.0	73.0	4403.0
3122.0	20.0	0.0	3328.0
354.0	5.0	6111.0	0.0
1.0	1.0	6468.0	0.0
3446.0	894.0	623.0	1507.0
4295.0	435.0	640.0	1100.0
2508.0	2028.0	1000.0	934.0
1218.0	2368.0	1899.0	984.0
1747.0	1220.0	1939.0	1563.0

#ID = HM0710
#Short = MEF2A
#Long = Myocyte-specific enhancer factor 2A
#W = 13
#Class = 5.1.1.1.1
#Factors = MEF2A,MEF2,Serum response factor-like protein 1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0724,HM0758,HM0759,HM0760,HM0798,HM0799,HM0926,M00001,M00026,M00033,M00184,M00242,M00403,M00405,M00406,M00407,M00482,M00518,MA0499,MA0499_1,MA0499_2,MA0499_3,MA0500,MA0500_1,MA0500_2,MA0500_3,MA0661,MA0661_1,MA0661_2,MA0671,MA0671_1,MA0671_2,MA1528,MA1528_1,MA1528_2,MA1547,MA1547_1,MA1547_2
#Alternatives = MA0052,MA0052_1,MA0052_2,MA0052_3,MA0052_4,MA0052_5
#HOCOMOCOv13 = MEF2A.H13CORE.0.P.B
#UniProt = Q02078,Q60929
#HGNC = 6993
#GeneCards = MEF2A
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 99532
#Entrez = 4205,17258
272.0	83.0	279.0	367.0
93.0	81.0	438.0	389.0
29.0	790.0	36.0	146.0
2.0	40.0	0.0	959.0
947.0	11.0	14.0	29.0
76.0	13.0	4.0	908.0
80.0	15.0	11.0	895.0
37.0	49.0	5.0	910.0
202.0	109.0	7.0	683.0
91.0	28.0	75.0	807.0
617.0	3.0	380.0	1.0
102.0	32.0	773.0	94.0
359.0	437.0	100.0	105.0

#ID = HM0711
#Short = MEF2B
#Long = Myocyte-specific enhancer factor 2B
#W = 14
#Class = 5.1.1.1.2
#Factors = MEF2B,XMEF2,RSRFR2,Serum response factor-like protein 2
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Alternatives = HM0712,MA0660,MA0660_1
#HOCOMOCOv13 = MEF2B.H13CORE.0.PS.A
#UniProt = Q02080,O55087
#HGNC = 6995
#GeneCards = MEF2B
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX
#Subtype = 0
#MGI = 104526
#Entrez = 100271849,4207
237.0	125.0	344.0	224.0
157.0	139.0	198.0	436.0
176.0	57.0	216.0	481.0
156.0	104.0	279.0	391.0
21.0	755.0	45.0	109.0
8.0	313.0	3.0	606.0
532.0	134.0	109.0	155.0
90.0	130.0	31.0	679.0
133.0	79.0	15.0	703.0
19.0	92.0	31.0	788.0
116.0	182.0	102.0	530.0
153.0	79.0	153.0	545.0
291.0	12.0	561.0	66.0
111.0	101.0	544.0	174.0

#ID = HM0712
#Short = MEF2B
#Long = Myocyte-specific enhancer factor 2B
#W = 18
#Class = 5.1.1.1.2
#Factors = MEF2B,XMEF2,RSRFR2,Serum response factor-like protein 2
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Alternatives = HM0711,MA0660,MA0660_1
#HOCOMOCOv13 = MEF2B.H13CORE.1.SM.B
#UniProt = Q02080,O55087
#HGNC = 6995
#GeneCards = MEF2B
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 1
#MGI = 104526
#Entrez = 100271849,4207
1829.0	1601.0	2325.0	1538.0
716.0	2990.0	553.0	3036.0
218.0	362.0	6537.0	178.0
807.0	232.0	441.0	5815.0
362.0	91.0	142.0	6700.0
5036.0	132.0	864.0	1263.0
1.0	7293.0	0.0	1.0
1.0	6993.0	2.0	299.0
5079.0	582.0	443.0	1191.0
2419.0	334.0	311.0	4231.0
6175.0	11.0	27.0	1082.0
1433.0	126.0	41.0	5695.0
2197.0	1178.0	683.0	3237.0
903.0	1050.0	1920.0	3422.0
1189.0	16.0	6042.0	48.0
242.0	128.0	6087.0	838.0
2770.0	2405.0	837.0	1280.0
3067.0	1390.0	1130.0	1706.0

#ID = HM0713
#Short = MEF2C
#Long = Myocyte-specific enhancer factor 2C
#W = 14
#Class = 5.1.1.1.3
#Factors = MEF2C,Myocyte enhancer factor 2C
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Alternatives = HM0714,MA0497,MA0497_1,MA0497_2
#HOCOMOCOv13 = MEF2C.H13CORE.0.P.B
#UniProt = Q06413,Q8CFN5
#HGNC = 6996
#GeneCards = MEF2C
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 99458
#Entrez = 4208,17260
233.0	123.0	205.0	287.0
236.0	61.0	190.0	361.0
88.0	95.0	292.0	373.0
33.0	632.0	58.0	125.0
6.0	148.0	8.0	686.0
704.0	48.0	37.0	59.0
128.0	47.0	14.0	659.0
133.0	13.0	27.0	675.0
38.0	79.0	15.0	716.0
119.0	216.0	33.0	480.0
224.0	43.0	84.0	497.0
117.0	6.0	710.0	15.0
64.0	50.0	630.0	104.0
396.0	259.0	105.0	88.0

#ID = HM0714
#Short = MEF2C
#Long = Myocyte-specific enhancer factor 2C
#W = 17
#Class = 5.1.1.1.3
#Factors = MEF2C,Myocyte enhancer factor 2C
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Alternatives = HM0713,MA0497,MA0497_1,MA0497_2
#HOCOMOCOv13 = MEF2C.H13CORE.1.SM.B
#UniProt = Q06413,Q8CFN5
#HGNC = 6996
#GeneCards = MEF2C
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 1
#MGI = 99458
#Entrez = 4208,17260
1985.0	1630.0	2285.0	2831.0
1083.0	832.0	3174.0	3643.0
2307.0	5712.0	250.0	464.0
95.0	6638.0	74.0	1926.0
3209.0	2672.0	1608.0	1244.0
3248.0	1367.0	2180.0	1938.0
6662.0	33.0	161.0	1877.0
509.0	3.0	21.0	8200.0
1967.0	15.0	37.0	6714.0
2725.0	37.0	86.0	5885.0
1624.0	1.0	7107.0	1.0
5.0	13.0	8648.0	67.0
4125.0	1652.0	975.0	1981.0
5413.0	859.0	796.0	1665.0
3400.0	2828.0	1133.0	1372.0
1629.0	3745.0	1958.0	1398.0
2543.0	1802.0	2548.0	1839.0

#ID = MA0497
#Short = MEF2C
#Long = Myocyte-specific enhancer factor 2C
#W = 11
#Class = 5.1.1.1.3
#Factors = MEF2C
#Organisms = human (Homo sapiens)
#Alternatives = HM0713,HM0714,MA0497_2,MA0497_1
#UniProt = Q06413
#Jaspar = MA0497.2
#Evidence = ChIP-seq
#PubMed = 7559475
382.0	1412.0	78.0	337.0
0.0	985.0	0.0	1224.0
1616.0	256.0	74.0	263.0
1706.0	32.0	241.0	230.0
2107.0	0.0	87.0	15.0
2131.0	0.0	2.0	76.0
2135.0	0.0	4.0	70.0
56.0	62.0	0.0	2091.0
2177.0	0.0	32.0	0.0
389.0	120.0	1671.0	29.0
975.0	836.0	148.0	250.0

#ID = MA2173
#Short = mef-2
#Long = MEF2 transcription factor homolog
#W = 7
#Class = 5.1.1.1.1
#Factors = mef-2,MEF2
#Organisms = roundworm (Caenorhabditis elegans)
#Interactions = M00001,M00033,M00184,M00454,M00482
#Alternatives = M00006,M00231,M00232,M00233,MA2173_1
#UniProt = Q9U325
#Jaspar = MA2173.1
#Evidence = ChIP-seq
#PubMed = 7559475
422.0	26.0	80.0	30.0
517.0	9.0	27.0	5.0
501.0	15.0	26.0	16.0
516.0	11.0	8.0	23.0
9.0	7.0	12.0	530.0
514.0	12.0	19.0	13.0
40.0	21.0	467.0	30.0

#ID = M00215
#Short = V$SRF_C
#Long = SRF (serum response factor)
#W = 15
#Class = 5.1.2.0.1
#Factors = SRF-L,SRF-I,SRF-S,SRF,SRF-M
#Organisms = human (Homo sapiens),mouse (Mus musculus),clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus),cat (Felis silvestris catus)
#Interactions = HM0185,HM0186,HM0187,HM0253,HM0254,HM0255,HM0279,HM0348,HM0350,HM0367,HM0368,HM0388,HM0802,HM0814,HM1104,HM1105,HM1106,HM1124,HM1125,HM1126,HM1129,HM1130,HM1131,HM1132,HM1173,HM1174,HM1175,HM1223,HM1224,M00007,M00008,M00025,M00059,M00069,M00109,M00116,M00117,M00152,M00185,M00186,M00196,M00209,M00215,M00287,M00339,M00447,M00451,M00481,M00483,M00531,MA0007,MA0007_1,MA0007_2,MA0007_3,MA0007_4,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0028,MA0028_1,MA0028_2,MA0028_3,MA0045,MA0060,MA0060_1,MA0060_2,MA0060_3,MA0060_4,MA0076,MA0076_1,MA0076_2,MA0076_3,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0083,MA0083_1,MA0083_2,MA0083_3,MA0090,MA0090_1,MA0090_2,MA0090_3,MA0090_4,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0124,MA0124_1,MA0124_2,MA0124_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0596,MA0596_1,MA0828,MA0828_1,MA0828_2,MA0828_3,MA1466,MA1466_1,MA1466_2,MA1849,MA1849_1,MA1849_2,MA1931,MA1931_1,MA1932,MA1932_1,MA1932_2,MA1933,MA1933_1,MA1933_2,MA1954,MA1954_1,MA1954_2,MA1957,MA1957_1,MA1958,MA1958_1,MA1958_2,MA2194,MA2194_1,MA2279,MA2279_1
#Alternatives = M00152,M00186,HM1132,MA0083,MA0083_1,MA0083_2,MA0083_3
#Transfac class = C0014
1.8	0.0	3.23	1.75
0.0	12.86	0.0	0.0
0.0	12.86	0.0	0.0
7.14	1.19	0.0	4.52
2.65	0.0	0.0	10.2
9.47	0.0	0.93	2.45
0.93	1.22	0.0	10.71
10.8	0.0	0.0	2.06
3.52	0.0	0.0	9.34
0.0	0.0	12.86	0.0
0.0	0.0	12.86	0.0
3.18	6.16	2.13	1.39
1.68	7.87	2.45	0.85
6.73	2.52	0.0	3.61
1.46	2.49	4.63	4.28

#ID = M00152
#Short = V$SRF_01
#Long = SRF (serum response factor)
#W = 18
#Class = 5.1.2.0.1
#Factors = SRF-L,SRF-I,SRF-S,SRF,SRF-M
#Organisms = human (Homo sapiens),mouse (Mus musculus),clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus),cat (Felis silvestris catus)
#Interactions = HM0185,HM0186,HM0187,HM0253,HM0254,HM0255,HM0279,HM0348,HM0350,HM0367,HM0368,HM0388,HM0802,HM0814,HM1104,HM1105,HM1106,HM1124,HM1125,HM1126,HM1129,HM1130,HM1131,HM1132,HM1173,HM1174,HM1175,HM1223,HM1224,M00007,M00008,M00025,M00059,M00069,M00109,M00116,M00117,M00152,M00185,M00186,M00196,M00209,M00215,M00287,M00339,M00447,M00451,M00481,M00483,M00531,MA0007,MA0007_1,MA0007_2,MA0007_3,MA0007_4,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0028,MA0028_1,MA0028_2,MA0028_3,MA0045,MA0060,MA0060_1,MA0060_2,MA0060_3,MA0060_4,MA0076,MA0076_1,MA0076_2,MA0076_3,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0083,MA0083_1,MA0083_2,MA0083_3,MA0090,MA0090_1,MA0090_2,MA0090_3,MA0090_4,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0124,MA0124_1,MA0124_2,MA0124_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0596,MA0596_1,MA0828,MA0828_1,MA0828_2,MA0828_3,MA1466,MA1466_1,MA1466_2,MA1849,MA1849_1,MA1849_2,MA1931,MA1931_1,MA1932,MA1932_1,MA1932_2,MA1933,MA1933_1,MA1933_2,MA1954,MA1954_1,MA1954_2,MA1957,MA1957_1,MA1958,MA1958_1,MA1958_2,MA2194,MA2194_1,MA2279,MA2279_1
#Alternatives = M00186,M00215,HM1132,MA0083,MA0083_1,MA0083_2,MA0083_3
#Transfac class = C0014
28.0	1.0	2.0	2.0
1.0	0.0	0.0	32.0
1.0	0.0	31.0	1.0
7.0	25.0	0.0	1.0
0.0	33.0	0.0	0.0
0.0	33.0	0.0	0.0
23.0	0.0	0.0	10.0
2.0	0.0	0.0	31.0
33.0	0.0	0.0	0.0
0.0	0.0	0.0	33.0
31.0	0.0	0.0	2.0
10.0	0.0	0.0	23.0
0.0	0.0	33.0	0.0
0.0	0.0	33.0	0.0
12.0	4.0	3.0	14.0
13.0	9.0	8.0	3.0
11.0	6.0	7.0	9.0
1.0	4.0	8.0	20.0

#ID = M00186
#Short = V$SRF_Q6
#Long = SRF (serum response factor)
#W = 14
#Class = 5.1.2.0.1
#Factors = SRF-L,SRF-I,SRF-S,SRF,SRF-M
#Organisms = human (Homo sapiens),mouse (Mus musculus),clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus),cat (Felis silvestris catus)
#Interactions = HM0185,HM0186,HM0187,HM0253,HM0254,HM0255,HM0279,HM0348,HM0350,HM0367,HM0368,HM0388,HM0802,HM0814,HM1104,HM1105,HM1106,HM1124,HM1125,HM1126,HM1129,HM1130,HM1131,HM1132,HM1173,HM1174,HM1175,HM1223,HM1224,M00007,M00008,M00025,M00059,M00069,M00109,M00116,M00117,M00152,M00185,M00186,M00196,M00209,M00215,M00287,M00339,M00447,M00451,M00481,M00483,M00531,MA0007,MA0007_1,MA0007_2,MA0007_3,MA0007_4,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0028,MA0028_1,MA0028_2,MA0028_3,MA0045,MA0060,MA0060_1,MA0060_2,MA0060_3,MA0060_4,MA0076,MA0076_1,MA0076_2,MA0076_3,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0083,MA0083_1,MA0083_2,MA0083_3,MA0090,MA0090_1,MA0090_2,MA0090_3,MA0090_4,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0124,MA0124_1,MA0124_2,MA0124_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0596,MA0596_1,MA0828,MA0828_1,MA0828_2,MA0828_3,MA1466,MA1466_1,MA1466_2,MA1849,MA1849_1,MA1849_2,MA1931,MA1931_1,MA1932,MA1932_1,MA1932_2,MA1933,MA1933_1,MA1933_2,MA1954,MA1954_1,MA1954_2,MA1957,MA1957_1,MA1958,MA1958_1,MA1958_2,MA2194,MA2194_1,MA2279,MA2279_1
#Alternatives = M00152,M00215,HM1132,MA0083,MA0083_1,MA0083_2,MA0083_3
#Transfac class = C0014
2.0	4.0	11.0	4.0
3.0	4.0	7.0	7.0
0.0	21.0	0.0	0.0
0.0	21.0	0.0	0.0
19.0	0.0	0.0	2.0
9.0	1.0	0.0	11.0
19.0	0.0	1.0	1.0
1.0	2.0	1.0	17.0
17.0	0.0	1.0	3.0
10.0	2.0	2.0	7.0
0.0	0.0	21.0	0.0
0.0	0.0	20.0	1.0
9.0	7.0	5.0	0.0
4.0	9.0	5.0	3.0

#ID = MA0083
#Short = SRF
#Long = Serum response factor
#W = 16
#Class = 5.1.2.0.1
#Factors = SRF
#Organisms = human (Homo sapiens)
#Interactions = HM1129,HM1130,HM1131,M00007,M00008,M00025,M00059,M00069,M00109,M00117,M00152,M00185,M00186,M00196,M00209,M00215,M00447,M00451,M00481,M00483,M00531,MA0596,MA0596_1,MA0828,MA0828_1,MA0828_2,MA0828_3
#Alternatives = M00152,M00186,M00215,HM1132,MA0083_3,MA0083_1,MA0083_2
#UniProt = P11831
#Jaspar = MA0083.3
#Evidence = HT-SELEX
#PubMed = 2243767
214.0	125.0	80.0	1129.0
75.0	152.0	1144.0	372.0
627.0	611.0	144.0	167.0
0.0	1771.0	15.0	0.0
3.0	1787.0	11.0	19.0
1137.0	13.0	18.0	61.0
54.0	0.0	6.0	1571.0
1163.0	0.0	2.0	0.0
1.0	5.0	8.0	1610.0
1162.0	0.0	0.0	16.0
439.0	12.0	0.0	1074.0
8.0	9.0	1896.0	0.0
8.0	2.0	1872.0	7.0
262.0	105.0	670.0	686.0
337.0	1023.0	145.0	72.0
913.0	63.0	98.0	248.0

#ID = HM1132
#Short = SRF
#Long = Serum response factor
#W = 17
#Class = 5.1.2.0.1
#Factors = SRF
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM1129,HM1130,HM1131,M00007,M00008,M00025,M00059,M00069,M00109,M00117,M00152,M00185,M00186,M00196,M00209,M00215,M00447,M00451,M00481,M00483,M00531,MA0596,MA0596_1,MA0828,MA0828_1,MA0828_2,MA0828_3
#Alternatives = M00152,M00186,M00215,MA0083,MA0083_1,MA0083_2,MA0083_3
#HOCOMOCOv13 = SRF.H13CORE.0.PSM.A
#UniProt = P11831,Q9JM73
#HGNC = 11291
#GeneCards = SRF
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX,Methyl-HT-SELEX
#Subtype = 0
#MGI = 106658
#Entrez = 6722,20807
142.0	163.0	85.0	558.0
73.0	134.0	200.0	541.0
218.0	155.0	292.0	283.0
10.0	921.0	11.0	6.0
0.0	906.0	0.0	42.0
267.0	143.0	17.0	521.0
100.0	31.0	20.0	797.0
682.0	16.0	39.0	211.0
17.0	28.0	10.0	893.0
594.0	20.0	9.0	325.0
100.0	12.0	15.0	821.0
92.0	0.0	855.0	1.0
8.0	10.0	919.0	11.0
117.0	276.0	279.0	276.0
176.0	539.0	92.0	141.0
409.0	88.0	114.0	337.0
262.0	129.0	163.0	394.0

#ID = MA2200
#Short = bs
#Long = Serum response factor homolog
#W = 10
#Class = 5.1.2.0.1
#Factors = bs,SRF
#Organisms = fruit fly (Drosophila melanogaster)
#Alternatives = MA2200_1
#UniProt = Q24535
#Jaspar = MA2200.1
#Evidence = SELEX
#PubMed = 11322877
4.0	995.0	0.0	0.0
0.0	998.0	1.0	0.0
632.0	104.0	115.0	146.0
11.0	0.0	0.0	988.0
999.0	0.0	0.0	0.0
179.0	314.0	12.0	492.0
951.0	0.0	0.0	48.0
248.0	4.0	0.0	747.0
0.0	0.0	998.0	0.0
0.0	0.0	1000.0	0.0

#ID = M00002
#Short = V$E47_01
#Long = E47 (E2A immunoglobulin enhancer binding factor, also known as Transcription factor 3 (TCF3))
#W = 15
#Class = 1.2.1.0.1.2
#Factors = E47
#Organisms = human (Homo sapiens)
#Interactions = HM0367,HM0368,HM0388,HM0439,HM0440,HM0484,HM0485,HM0489,HM1124,HM1125,HM1126,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00002,M00058,M00065,M00066,M00068,M00070,M00071,M00184,M00222,M00339,M00454,M00531,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0048,MA0048_1,MA0048_2,MA0048_3,MA0055,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1938,MA1938_1,MA1938_2,MA2388,MA2388_1
#Alternatives = M00071
#Transfac class = C0010
4.0	4.0	3.0	0.0
2.0	5.0	4.0	0.0
3.0	2.0	4.0	2.0
2.0	0.0	9.0	0.0
0.0	11.0	0.0	0.0
11.0	0.0	0.0	0.0
0.0	0.0	11.0	0.0
1.0	2.0	8.0	0.0
0.0	0.0	0.0	11.0
0.0	0.0	11.0	0.0
0.0	0.0	4.0	7.0
1.0	4.0	3.0	3.0
1.0	6.0	2.0	2.0
1.0	4.0	4.0	2.0
1.0	4.0	2.0	3.0

#ID = M00065
#Short = V$TAL1BETAE47_01
#Long = Tal-1beta:E47 (Tal-1beta:E47 heterodimer) (TAL-1=T-cell acute lymphocytic leukemia protein 1)
#W = 16
#Class = 1.2.1.0.1.2
#Factors = E47,Tal1-PP22
#Organisms = human (Homo sapiens)
#Interactions = HM0367,HM0368,HM0388,HM0439,HM0440,HM0484,HM0485,HM0489,HM1124,HM1125,HM1126,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00002,M00058,M00065,M00066,M00068,M00070,M00071,M00184,M00222,M00339,M00454,M00531,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0048,MA0048_1,MA0048_2,MA0048_3,MA0055,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1938,MA1938_1,MA1938_2,MA2388,MA2388_1
#Transfac class = C0010
23.0	35.0	28.0	14.0
15.0	30.0	23.0	32.0
14.0	23.0	44.0	19.0
66.0	9.0	14.0	11.0
61.0	30.0	3.0	6.0
0.0	100.0	0.0	0.0
100.0	0.0	0.0	0.0
0.0	0.0	100.0	0.0
86.0	1.0	10.0	3.0
0.0	0.0	0.0	100.0
0.0	0.0	100.0	0.0
1.0	3.0	61.0	35.0
3.0	17.0	1.0	79.0
20.0	43.0	17.0	20.0
27.0	23.0	31.0	19.0
23.0	26.0	32.0	19.0

#ID = M00066
#Short = V$TAL1ALPHAE47_01
#Long = Tal-1alpha:E47 (Tal-1alpha:E47 heterodimer) (TAL-1=T-cell acute lymphocytic leukemia protein 1)
#W = 16
#Class = 1.2.1.0.1.2
#Factors = E47,Tal1-PP42
#Organisms = human (Homo sapiens)
#Interactions = HM0367,HM0368,HM0388,HM0439,HM0440,HM0484,HM0485,HM0489,HM1124,HM1125,HM1126,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00002,M00058,M00065,M00066,M00068,M00070,M00071,M00184,M00222,M00277,M00278,M00339,M00454,M00531,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0048,MA0048_1,MA0048_2,MA0048_3,MA0055,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1938,MA1938_1,MA1938_2,MA2388,MA2388_1
#Transfac class = C0010
18.0	10.0	35.0	37.0
14.0	40.0	17.0	29.0
12.0	26.0	41.0	21.0
59.0	8.0	27.0	6.0
65.0	26.0	9.0	0.0
0.0	100.0	0.0	0.0
100.0	0.0	0.0	0.0
0.0	0.0	95.0	4.0
86.0	6.0	8.0	0.0
0.0	0.0	0.0	100.0
0.0	0.0	100.0	0.0
1.0	3.0	56.0	40.0
0.0	17.0	4.0	79.0
19.0	34.0	35.0	12.0
34.0	24.0	19.0	23.0
17.0	39.0	30.0	14.0

#ID = M00071
#Short = V$E47_02
#Long = E47 (E2A immunoglobulin enhancer binding factor, also known as Transcription factor 3 (TCF3))
#W = 16
#Class = 1.2.1.0.1.2
#Factors = E47
#Organisms = human (Homo sapiens)
#Interactions = HM0367,HM0368,HM0388,HM0439,HM0440,HM0484,HM0485,HM0489,HM1124,HM1125,HM1126,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00002,M00058,M00065,M00066,M00068,M00070,M00071,M00184,M00222,M00339,M00454,M00531,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0048,MA0048_1,MA0048_2,MA0048_3,MA0055,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1938,MA1938_1,MA1938_2,MA2388,MA2388_1
#Alternatives = M00002
#Transfac class = C0010
41.0	24.0	17.0	17.0
31.0	24.0	14.0	31.0
17.0	17.0	30.0	36.0
50.0	26.0	7.0	17.0
50.0	14.0	33.0	3.0
0.0	100.0	0.0	0.0
100.0	0.0	0.0	0.0
0.0	5.0	92.0	3.0
0.0	16.0	84.0	0.0
0.0	0.0	0.0	100.0
0.0	0.0	100.0	0.0
0.0	24.0	13.0	63.0
20.0	3.0	8.0	69.0
34.0	46.0	11.0	9.0
34.0	27.0	24.0	15.0
25.0	37.0	22.0	16.0

#ID = HM1198
#Short = TFE2
#Long = Transcription factor E2-alpha
#W = 10
#Class = 1.2.1.0.1
#Factors = TFE2,BHLHB21,E2A,ITF1,Alf2,Me2,Tcfe2a,Class B basic helix-loop-helix protein 21,Immunoglobulin enhancer-binding factor E12/E47,Immunoglobulin transcription factor 1,Kappa-E2-binding factor,Transcription factor 3,TCF-3,Transcription factor ITF-1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0201,HM0419,HM0484,HM0485,HM0486,HM0487,HM0488,HM0758,HM0759,HM1146,HM1147,HM1148,HM1219,HM1220,HM1221,HM1222,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00469,M00471,M00497,M00517,M00615,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0479,MA0479_1,MA0479_2,MA0499,MA0499_1,MA0499_2,MA0499_3,MA0633,MA0633_1,MA0633_2,MA0633_3,MA1100,MA1100_1,MA1100_2,MA1100_3,MA1123,MA1123_1,MA1123_2,MA1123_3,MA1631,MA1631_1,MA1631_2,MA1638,MA1638_1,MA1638_2,MA2123,MA2123_1
#Alternatives = HM0484,HM0485,HM1146,HM1147,HM1148,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0140,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4
#HOCOMOCOv13 = TFE2.H13CORE.0.PS.A
#UniProt = P15923,P15806
#HGNC = 11633
#GeneCards = TCF3
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX
#Subtype = 0
#MGI = 98510
#Entrez = 6929,21423
315.0	309.0	224.0	151.0
417.0	249.0	305.0	28.0
2.0	994.0	1.0	2.0
989.0	0.0	5.0	5.0
1.0	671.0	275.0	52.0
3.0	993.0	2.0	1.0
0.0	3.0	2.0	994.0
1.0	1.0	993.0	4.0
7.0	543.0	243.0	206.0
284.0	257.0	254.0	204.0

#ID = MA0792
#Short = POU5F1B
#Long = POU domain, class 5, transcription factor 1B
#W = 9
#Class = 3.1.10.5.2
#Factors = POU5F1B,P5F1B
#Organisms = human (Homo sapiens)
#Alternatives = HM0886,MA0792_1
#UniProt = Q06416
#Jaspar = MA0792.1
#Evidence = HT-SELEX
#PubMed = 2350782
1326.0	1778.0	808.0	9519.0
9519.0	21.0	67.0	84.0
171.0	364.0	206.0	9519.0
322.0	94.0	9519.0	1790.0
398.0	9519.0	1293.0	3828.0
6299.0	51.0	65.0	3220.0
9519.0	144.0	856.0	896.0
9519.0	65.0	97.0	203.0
1559.0	537.0	750.0	9519.0

#ID = MA1115
#Short = POU5F1
#Long = POU domain, class 5, transcription factor 1
#W = 7
#Class = 3.1.10.5.1
#Factors = POU5F1,PO5F1
#Organisms = human (Homo sapiens)
#Interactions = HM0094,HM0286,HM0413,HM0414,HM1085,HM1086,HM1087,HM1088,M00130,MA0041,MA0041_1,MA0041_2,MA0041_3,MA0139,MA0139_1,MA0139_2,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA0531,MA0531_1,MA0531_2,MA1929,MA1929_1,MA1929_2,MA1930,MA1930_1,MA1930_2,MA1962,MA1962_1
#Alternatives = HM0956,HM0957,HM0958,MA1115_2,MA1115_1
#UniProt = Q01860
#Jaspar = MA1115.2
#Evidence = ChIP-seq
#PubMed = 23747866
12693.0	122.0	229.0	70.0
83.0	130.0	67.0	12834.0
717.0	192.0	11571.0	634.0
533.0	10310.0	548.0	1723.0
11756.0	132.0	118.0	1108.0
10560.0	690.0	1026.0	838.0
12280.0	270.0	257.0	307.0

#ID = MA0142
#Short = Pou5f1::Sox2
#Long = POU domain, class 5, transcription factor 1::Transcription factor SOX-2
#W = 15
#Class = 3.1.10.5.1
#Factors = PO5F1,SOX2,Pou5f1
#Organisms = mouse (Mus musculus)
#Part = Dimer
#Interactions = HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1060,HM1061,HM1062,HM1085,HM1086,HM1087,HM1088,HM1223,HM1224,M00008,M00033,M00039,M00040,M00041,M00056,M00059,M00069,M00073,M00113,M00114,M00115,M00130,M00135,M00136,M00137,M00138,M00161,M00162,M00177,M00178,M00179,M00185,M00191,M00192,M00193,M00195,M00196,M00205,M00209,M00210,M00216,M00223,M00225,M00248,M00252,M00302,M00327,M00340,M00342,M00360,M00394,M00412,M00413,M00414,M00415,M00444,M00447,M00457,M00459,M00460,M00471,M00481,M00493,M00497,M00499,M00518,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA0795,MA0795_1,MA1115,MA1115_1,MA1115_2,MA2339,MA2339_1
#Alternatives = HM0956,HM0957,HM0958,HM1085,HM1086,HM1087,HM1088,MA0142_1,MA0143_1,MA0143_2,MA0143_3
#UniProt = P20263,P48432
#Jaspar = MA0142.1
#DimerClass = 4.1.1.2.2
#Evidence = ChIP-seq
#PubMed = 18555785
63.0	846.0	66.0	389.0
579.0	58.0	28.0	701.0
11.0	50.0	36.0	1270.0
47.0	12.0	79.0	1231.0
118.0	363.0	825.0	63.0
415.0	18.0	29.0	907.0
206.0	365.0	186.0	612.0
1235.0	30.0	24.0	80.0
17.0	5.0	15.0	1332.0
10.0	16.0	1239.0	104.0
14.0	1029.0	129.0	196.0
1050.0	16.0	30.0	269.0
887.0	68.0	315.0	92.0
1200.0	33.0	75.0	53.0
198.0	119.0	207.0	837.0

#ID = HM0957
#Short = PO5F1
#Long = POU domain, class 5, transcription factor 1
#W = 11
#Class = 3.1.10.5.1
#Factors = PO5F1,OCT3,OCT4,OTF3,Oct-3,Oct-4,Otf-3,Octamer-binding protein 3,Octamer-binding protein 4,Octamer-binding transcription factor 3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0094,HM0286,HM0413,HM0414,HM0763,HM0764,HM0765,HM1060,HM1061,HM1062,HM1085,HM1086,HM1087,HM1088,M00008,M00033,M00039,M00040,M00041,M00056,M00059,M00069,M00073,M00113,M00114,M00115,M00130,M00135,M00136,M00137,M00138,M00161,M00162,M00177,M00178,M00179,M00185,M00191,M00192,M00193,M00195,M00196,M00205,M00209,M00210,M00216,M00223,M00225,M00248,M00252,M00302,M00327,M00340,M00342,M00360,M00394,M00412,M00413,M00414,M00415,M00444,M00447,M00457,M00459,M00460,M00471,M00481,M00493,M00497,M00499,M00518,MA0041,MA0041_1,MA0041_2,MA0041_3,MA0139,MA0139_1,MA0139_2,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA0531,MA0531_1,MA0531_2,MA0795,MA0795_1,MA1929,MA1929_1,MA1929_2,MA1930,MA1930_1,MA1930_2,MA1962,MA1962_1,MA2339,MA2339_1
#Alternatives = HM0956,HM0958,MA0142,MA0142_1,MA1115,MA1115_1,MA1115_2
#HOCOMOCOv13 = PO5F1.H13CORE.1.P.B
#UniProt = Q01860,P20263
#HGNC = 9221
#GeneCards = POU5F1
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 1
#MGI = 101893
#Entrez = 5460,18999
410.0	55.0	111.0	418.0
237.0	153.0	50.0	554.0
948.0	1.0	13.0	32.0
7.0	1.0	12.0	974.0
0.0	3.0	924.0	67.0
23.0	739.0	86.0	146.0
748.0	2.0	7.0	237.0
771.0	37.0	134.0	52.0
961.0	3.0	21.0	9.0
164.0	53.0	76.0	701.0
177.0	101.0	348.0	368.0

#ID = HM0958
#Short = PO5F1
#Long = POU domain, class 5, transcription factor 1
#W = 17
#Class = 3.1.10.5.1
#Factors = PO5F1,OCT3,OCT4,OTF3,Oct-3,Oct-4,Otf-3,Octamer-binding protein 3,Octamer-binding protein 4,Octamer-binding transcription factor 3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0094,HM0286,HM0413,HM0414,HM0763,HM0764,HM0765,HM1060,HM1061,HM1062,HM1085,HM1086,HM1087,HM1088,M00008,M00033,M00039,M00040,M00041,M00056,M00059,M00069,M00073,M00113,M00114,M00115,M00130,M00135,M00136,M00137,M00138,M00161,M00162,M00177,M00178,M00179,M00185,M00191,M00192,M00193,M00195,M00196,M00205,M00209,M00210,M00216,M00223,M00225,M00248,M00252,M00302,M00327,M00340,M00342,M00360,M00394,M00412,M00413,M00414,M00415,M00444,M00447,M00457,M00459,M00460,M00471,M00481,M00493,M00497,M00499,M00518,MA0041,MA0041_1,MA0041_2,MA0041_3,MA0139,MA0139_1,MA0139_2,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA0531,MA0531_1,MA0531_2,MA0795,MA0795_1,MA1929,MA1929_1,MA1929_2,MA1930,MA1930_1,MA1930_2,MA1962,MA1962_1,MA2339,MA2339_1
#Alternatives = HM0956,HM0957,MA0142,MA0142_1,MA1115,MA1115_1,MA1115_2
#HOCOMOCOv13 = PO5F1.H13CORE.2.SM.B
#UniProt = Q01860,P20263
#HGNC = 9221
#GeneCards = POU5F1
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 2
#MGI = 101893
#Entrez = 5460,18999
3145.0	2016.0	2600.0	1017.0
4565.0	1044.0	1781.0	1389.0
1494.0	36.0	521.0	6730.0
1.0	4.0	2.0	8774.0
8778.0	2.0	1.0	0.0
5.0	0.0	10.0	8766.0
0.0	15.0	8766.0	0.0
12.0	7548.0	0.0	1221.0
1709.0	0.0	4.0	7068.0
8775.0	1.0	2.0	3.0
8780.0	0.0	0.0	1.0
0.0	1.0	0.0	8780.0
4.0	12.0	3698.0	5067.0
7983.0	55.0	399.0	344.0
3617.0	645.0	4290.0	229.0
397.0	2150.0	4565.0	1669.0
1102.0	2607.0	2438.0	2634.0

#ID = HM0956
#Short = PO5F1
#Long = POU domain, class 5, transcription factor 1
#W = 17
#Class = 3.1.10.5.1
#Factors = PO5F1,OCT3,OCT4,OTF3,Oct-3,Oct-4,Otf-3,Octamer-binding protein 3,Octamer-binding protein 4,Octamer-binding transcription factor 3
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0094,HM0286,HM0413,HM0414,HM0763,HM0764,HM0765,HM1060,HM1061,HM1062,HM1085,HM1086,HM1087,HM1088,M00008,M00033,M00039,M00040,M00041,M00056,M00059,M00069,M00073,M00113,M00114,M00115,M00130,M00135,M00136,M00137,M00138,M00161,M00162,M00177,M00178,M00179,M00185,M00191,M00192,M00193,M00195,M00196,M00205,M00209,M00210,M00216,M00223,M00225,M00248,M00252,M00302,M00327,M00340,M00342,M00360,M00394,M00412,M00413,M00414,M00415,M00444,M00447,M00457,M00459,M00460,M00471,M00481,M00493,M00497,M00499,M00518,MA0041,MA0041_1,MA0041_2,MA0041_3,MA0139,MA0139_1,MA0139_2,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA0531,MA0531_1,MA0531_2,MA0795,MA0795_1,MA1929,MA1929_1,MA1929_2,MA1930,MA1930_1,MA1930_2,MA1962,MA1962_1,MA2339,MA2339_1
#Alternatives = HM0957,HM0958,MA0142,MA0142_1,MA1115,MA1115_1,MA1115_2
#HOCOMOCOv13 = PO5F1.H13CORE.0.P.B
#UniProt = Q01860,P20263
#HGNC = 9221
#GeneCards = POU5F1
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 101893
#Entrez = 5460,18999
116.0	257.0	285.0	364.0
66.0	490.0	232.0	234.0
53.0	606.0	59.0	304.0
533.0	33.0	30.0	426.0
13.0	38.0	33.0	938.0
52.0	14.0	130.0	826.0
113.0	300.0	562.0	47.0
344.0	9.0	35.0	634.0
160.0	258.0	110.0	494.0
950.0	11.0	27.0	34.0
9.0	6.0	11.0	996.0
1.0	5.0	926.0	90.0
18.0	824.0	65.0	115.0
776.0	20.0	45.0	181.0
573.0	98.0	201.0	150.0
829.0	42.0	93.0	58.0
169.0	136.0	161.0	556.0

#ID = HM0886
#Short = P5F1B
#Long = Putative POU domain, class 5, transcription factor 1B
#W = 17
#Class = 3.1.10.5.2
#Factors = P5F1B,OCT4PG1,OTF3C,OTF3P1,POU5F1P1,POU5FLC20,POU5FLC8,Oct4-pg1,Octamer-binding protein 3-like,Octamer-binding transcription factor 3-like
#Organisms = human (Homo sapiens)
#Alternatives = MA0792,MA0792_1
#HOCOMOCOv13 = P5F1B.H13CORE.0.S.B
#UniProt = Q06416
#HGNC = 9223
#GeneCards = POU5F1B
#HMQuality = B
#Evidence = HT-SELEX
#Subtype = 0
#Entrez = 5462
1423.0	866.0	648.0	4541.0
1921.0	569.0	4390.0	595.0
4015.0	2653.0	286.0	524.0
5338.0	110.0	788.0	1242.0
17.0	53.0	9.0	7399.0
7470.0	0.0	0.0	8.0
1.0	24.0	0.0	7453.0
1.0	3.0	6703.0	771.0
0.0	7348.0	14.0	116.0
6024.0	0.0	6.0	1448.0
6847.0	2.0	24.0	605.0
7332.0	3.0	119.0	24.0
404.0	148.0	177.0	6749.0
678.0	1019.0	1247.0	4534.0
3905.0	1191.0	741.0	1641.0
1955.0	1169.0	3405.0	946.0
1608.0	1820.0	2180.0	1869.0

#ID = HM1085
#Short = SOX2
#Long = Transcription factor SOX-2
#W = 12
#Class = 4.1.1.2.2
#Factors = SOX2,Sox-2
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0094,HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1223,HM1224,M00008,M00033,M00039,M00040,M00041,M00056,M00059,M00069,M00073,M00097,M00113,M00114,M00115,M00116,M00130,M00135,M00136,M00137,M00138,M00145,M00159,M00161,M00162,M00172,M00177,M00178,M00179,M00185,M00190,M00191,M00192,M00193,M00195,M00196,M00201,M00205,M00209,M00210,M00216,M00223,M00225,M00248,M00249,M00252,M00302,M00327,M00340,M00342,M00360,M00394,M00395,M00412,M00413,M00414,M00415,M00436,M00444,M00447,M00457,M00459,M00460,M00463,M00464,M00471,M00481,M00493,M00497,M00499,M00517,M00518,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0142,MA0142_1,MA1115,MA1115_1,MA1115_2,MA2339,MA2339_1
#Alternatives = HM1086,HM1087,HM1088,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA1962,MA1962_1
#HOCOMOCOv13 = SOX2.H13CORE.0.P.B
#UniProt = P48431,P48432
#HGNC = 11195
#GeneCards = SOX2
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 98364
#Entrez = 6657,20674
71.0	250.0	313.0	373.0
13.0	703.0	147.0	144.0
11.0	618.0	13.0	365.0
497.0	9.0	1.0	500.0
1.0	4.0	4.0	998.0
2.0	0.0	2.0	1003.0
17.0	44.0	941.0	5.0
14.0	1.0	2.0	990.0
71.0	296.0	87.0	553.0
386.0	365.0	84.0	172.0
93.0	145.0	63.0	706.0
120.0	171.0	539.0	177.0

#ID = HM1086
#Short = SOX2
#Long = Transcription factor SOX-2
#W = 17
#Class = 4.1.1.2.2
#Factors = SOX2,Sox-2
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0094,HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1223,HM1224,M00008,M00033,M00039,M00040,M00041,M00056,M00059,M00069,M00073,M00097,M00113,M00114,M00115,M00116,M00130,M00135,M00136,M00137,M00138,M00145,M00159,M00161,M00162,M00172,M00177,M00178,M00179,M00185,M00190,M00191,M00192,M00193,M00195,M00196,M00201,M00205,M00209,M00210,M00216,M00223,M00225,M00248,M00249,M00252,M00302,M00327,M00340,M00342,M00360,M00394,M00395,M00412,M00413,M00414,M00415,M00436,M00444,M00447,M00457,M00459,M00460,M00463,M00464,M00471,M00481,M00493,M00497,M00499,M00517,M00518,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0142,MA0142_1,MA1115,MA1115_1,MA1115_2,MA2339,MA2339_1
#Alternatives = HM1085,HM1087,HM1088,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA1962,MA1962_1
#HOCOMOCOv13 = SOX2.H13CORE.1.P.B
#UniProt = P48431,P48432
#HGNC = 11195
#GeneCards = SOX2
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 1
#MGI = 98364
#Entrez = 6657,20674
100.0	243.0	281.0	378.0
35.0	636.0	166.0	165.0
24.0	632.0	26.0	320.0
524.0	6.0	4.0	468.0
2.0	2.0	12.0	986.0
12.0	1.0	5.0	984.0
39.0	138.0	803.0	22.0
136.0	3.0	4.0	859.0
124.0	258.0	120.0	500.0
560.0	238.0	70.0	134.0
57.0	79.0	42.0	824.0
50.0	95.0	694.0	163.0
66.0	604.0	147.0	185.0
558.0	124.0	68.0	252.0
543.0	101.0	190.0	168.0
650.0	131.0	86.0	135.0
210.0	161.0	157.0	474.0

#ID = HM1087
#Short = SOX2
#Long = Transcription factor SOX-2
#W = 12
#Class = 4.1.1.2.2
#Factors = SOX2,Sox-2
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0094,HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1223,HM1224,M00008,M00033,M00039,M00040,M00041,M00056,M00059,M00069,M00073,M00097,M00113,M00114,M00115,M00116,M00130,M00135,M00136,M00137,M00138,M00145,M00159,M00161,M00162,M00172,M00177,M00178,M00179,M00185,M00190,M00191,M00192,M00193,M00195,M00196,M00201,M00205,M00209,M00210,M00216,M00223,M00225,M00248,M00249,M00252,M00302,M00327,M00340,M00342,M00360,M00394,M00395,M00412,M00413,M00414,M00415,M00436,M00444,M00447,M00457,M00459,M00460,M00463,M00464,M00471,M00481,M00493,M00497,M00499,M00517,M00518,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0142,MA0142_1,MA1115,MA1115_1,MA1115_2,MA2339,MA2339_1
#Alternatives = HM1085,HM1086,HM1088,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA1962,MA1962_1
#HOCOMOCOv13 = SOX2.H13CORE.3.S.B
#UniProt = P48431,P48432
#HGNC = 11195
#GeneCards = SOX2
#HMQuality = B
#Evidence = HT-SELEX
#Subtype = 3
#MGI = 98364
#Entrez = 6657,20674
1052.0	94.0	114.0	103.0
998.0	97.0	86.0	182.0
82.0	41.0	78.0	1165.0
706.0	76.0	167.0	417.0
530.0	228.0	185.0	423.0
18.0	1342.0	0.0	6.0
1366.0	0.0	0.0	0.0
0.0	0.0	0.0	1366.0
0.0	0.0	0.0	1366.0
2.0	1014.0	341.0	9.0
835.0	74.0	125.0	331.0
339.0	349.0	224.0	452.0

#ID = HM1088
#Short = SOX2
#Long = Transcription factor SOX-2
#W = 10
#Class = 4.1.1.2.2
#Factors = SOX2,Sox-2
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0094,HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1223,HM1224,M00008,M00033,M00039,M00040,M00041,M00056,M00059,M00069,M00073,M00097,M00113,M00114,M00115,M00116,M00130,M00135,M00136,M00137,M00138,M00145,M00159,M00161,M00162,M00172,M00177,M00178,M00179,M00185,M00190,M00191,M00192,M00193,M00195,M00196,M00201,M00205,M00209,M00210,M00216,M00223,M00225,M00248,M00249,M00252,M00302,M00327,M00340,M00342,M00360,M00394,M00395,M00412,M00413,M00414,M00415,M00436,M00444,M00447,M00457,M00459,M00460,M00463,M00464,M00471,M00481,M00493,M00497,M00499,M00517,M00518,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0142,MA0142_1,MA1115,MA1115_1,MA1115_2,MA2339,MA2339_1
#Alternatives = HM1085,HM1086,HM1087,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA1962,MA1962_1
#HOCOMOCOv13 = SOX2.H13CORE.2.S.B
#UniProt = P48431,P48432
#HGNC = 11195
#GeneCards = SOX2
#HMQuality = B
#Evidence = HT-SELEX
#Subtype = 2
#MGI = 98364
#Entrez = 6657,20674
3720.0	1092.0	767.0	1585.0
886.0	674.0	759.0	4845.0
3416.0	882.0	780.0	2088.0
2032.0	2280.0	1298.0	1556.0
61.0	7105.0	0.0	0.0
7166.0	0.0	0.0	0.0
0.0	0.0	0.0	7166.0
0.0	0.0	0.0	7166.0
2221.0	1996.0	2836.0	113.0
2180.0	1365.0	858.0	2762.0

#ID = MA0143
#Short = SOX2
#Long = Transcription factor SOX-2
#W = 7
#Class = 4.1.1.2.2
#Factors = SOX2
#Organisms = human (Homo sapiens)
#Interactions = HM0094,HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1223,HM1224,M00008,M00041,M00059,M00069,M00097,M00116,M00135,M00136,M00137,M00138,M00145,M00159,M00161,M00162,M00172,M00190,M00195,M00196,M00201,M00210,M00248,M00249,M00327,M00342,M00360,M00395,M00436,M00463,M00464,M00517,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0142,MA0142_1,MA1115,MA1115_1,MA1115_2,MA2339,MA2339_1
#Alternatives = HM1085,HM1086,HM1087,HM1088,MA0143_5,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA1962,MA1962_1
#UniProt = P48431
#Jaspar = MA0143.5
#Evidence = ChIP-seq
#PubMed = 15863505
83515.0	436.0	418.0	1385.0
1307.0	78356.0	1243.0	4848.0
81587.0	1205.0	550.0	2412.0
80825.0	1742.0	2002.0	1185.0
4815.0	732.0	930.0	79277.0
9926.0	800.0	73372.0	1656.0
14772.0	6264.0	54414.0	10304.0

#ID = MA2339
#Short = Nanog
#Long = Homeobox protein NANOG
#W = 7
#Class = 3.1.2.12.1
#Factors = Nanog
#Organisms = mouse (Mus musculus)
#Interactions = HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1085,HM1086,HM1087,HM1088,HM1371,HM1372,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA1115,MA1115_1,MA1115_2,MA1630,MA1630_1,MA1630_2,MA1630_3,MA2339,MA2339_1
#Alternatives = HM0763,HM0764,HM0765,MA2339_1
#UniProt = Q80Z64
#Jaspar = MA2339.1
#Evidence = ChIP-seq
#PubMed = 33603233
480.0	164.0	7830.0	190.0
143.0	7298.0	93.0	1130.0
6992.0	400.0	365.0	907.0
7959.0	206.0	196.0	303.0
235.0	96.0	124.0	8209.0
348.0	7421.0	149.0	746.0
8076.0	131.0	180.0	277.0

#ID = HM0763
#Short = NANOG
#Long = Homeobox protein NANOG
#W = 17
#Class = 3.1.2.12.1
#Factors = NANOG,Ecat4,Enk,Homeobox transcription factor Nanog,hNanog
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1085,HM1086,HM1087,HM1088,HM1371,HM1372,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA1115,MA1115_1,MA1115_2,MA1630,MA1630_1,MA1630_2,MA1630_3,MA2339,MA2339_1
#Alternatives = HM0764,HM0765,MA2339,MA2339_1
#HOCOMOCOv13 = NANOG.H13CORE.0.P.B
#UniProt = Q9H9S0,Q80Z64
#HGNC = 20857
#GeneCards = NANOG
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 1919200
#Entrez = 79923,71950
129.0	241.0	308.0	321.0
36.0	516.0	205.0	242.0
83.0	541.0	64.0	311.0
345.0	54.0	51.0	549.0
18.0	61.0	45.0	875.0
62.0	9.0	31.0	897.0
79.0	287.0	583.0	50.0
386.0	26.0	31.0	556.0
211.0	254.0	201.0	333.0
755.0	36.0	70.0	138.0
76.0	12.0	54.0	857.0
15.0	21.0	812.0	151.0
36.0	613.0	116.0	234.0
679.0	19.0	13.0	288.0
623.0	62.0	264.0	50.0
791.0	56.0	60.0	92.0
131.0	126.0	202.0	540.0

#ID = HM0764
#Short = NANOG
#Long = Homeobox protein NANOG
#W = 11
#Class = 3.1.2.12.1
#Factors = NANOG,Ecat4,Enk,Homeobox transcription factor Nanog,hNanog
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1085,HM1086,HM1087,HM1088,HM1371,HM1372,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA1115,MA1115_1,MA1115_2,MA1630,MA1630_1,MA1630_2,MA1630_3,MA2339,MA2339_1
#Alternatives = HM0763,HM0765,MA2339,MA2339_1
#HOCOMOCOv13 = NANOG.H13CORE.1.P.B
#UniProt = Q9H9S0,Q80Z64
#HGNC = 20857
#GeneCards = NANOG
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 1
#MGI = 1919200
#Entrez = 79923,71950
71.0	164.0	163.0	102.0
42.0	145.0	86.0	227.0
67.0	9.0	22.0	402.0
182.0	5.0	313.0	0.0
481.0	8.0	2.0	9.0
12.0	3.0	7.0	478.0
6.0	3.0	370.0	121.0
48.0	7.0	432.0	13.0
27.0	287.0	113.0	73.0
22.0	157.0	19.0	302.0
43.0	166.0	128.0	163.0

#ID = HM0765
#Short = NANOG
#Long = Homeobox protein NANOG
#W = 12
#Class = 3.1.2.12.1
#Factors = NANOG,Ecat4,Enk,Homeobox transcription factor Nanog,hNanog
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0763,HM0764,HM0765,HM0956,HM0957,HM0958,HM1085,HM1086,HM1087,HM1088,HM1371,HM1372,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA1115,MA1115_1,MA1115_2,MA1630,MA1630_1,MA1630_2,MA1630_3,MA2339,MA2339_1
#Alternatives = HM0763,HM0764,MA2339,MA2339_1
#HOCOMOCOv13 = NANOG.H13CORE.2.M.C
#UniProt = Q9H9S0,Q80Z64
#HGNC = 20857
#GeneCards = NANOG
#HMQuality = C
#Evidence = Methyl-HT-SELEX
#Subtype = 2
#MGI = 1919200
#Entrez = 79923,71950
1716.0	1019.0	1489.0	2462.0
1643.0	301.0	4054.0	689.0
370.0	102.0	644.0	5573.0
0.0	2.0	0.0	6687.0
6331.0	0.0	358.0	0.0
6688.0	0.0	1.0	0.0
1.0	862.0	1037.0	4789.0
2.0	8.0	5600.0	1079.0
3070.0	194.0	2254.0	1171.0
789.0	450.0	1715.0	3733.0
1139.0	418.0	2159.0	2971.0
1764.0	521.0	2015.0	2388.0

#ID = MA0608
#Short = Creb3l2
#Long = Cyclic AMP-responsive element-binding protein 3-like protein 2
#W = 9
#Class = 1.1.7.2.3
#Factors = Creb3l2,CR3L2
#Organisms = mouse (Mus musculus)
#Alternatives = HM0276,MA0608_1
#UniProt = Q8BH52
#Jaspar = MA0608.1
#Evidence = PBM
#PubMed = 23332764
2.0	2.0	745.0	250.0
250.0	623.0	1.0	126.0
1.0	872.0	126.0	1.0
996.0	1.0	1.0	1.0
1.0	996.0	1.0	1.0
1.0	1.0	996.0	1.0
1.0	1.0	1.0	996.0
1.0	143.0	854.0	1.0
250.0	2.0	250.0	498.0

#ID = MA0638
#Short = CREB3
#Long = Cyclic AMP-responsive element-binding protein 3
#W = 12
#Class = 1.1.7.2.1
#Factors = CREB3
#Organisms = human (Homo sapiens)
#Interactions = HM0036,HM0280,HM0295,HM0624,HM0625,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0638,MA0638_1,MA0638_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2
#Alternatives = HM0280,MA0638_2,MA0638_1
#UniProt = O43889
#Jaspar = MA0638.2
#Evidence = HT-SELEX
#PubMed = 15845366
32.0	78.0	75.0	284.0
20.0	0.0	390.0	129.0
92.0	207.0	2.0	20.0
7.0	241.0	16.0	7.0
305.0	0.0	0.0	1.0
0.0	245.0	0.0	0.0
3.0	0.0	447.0	2.0
1.0	1.0	0.0	376.0
10.0	245.0	8.0	4.0
300.0	2.0	12.0	6.0
7.0	115.0	28.0	161.0
65.0	210.0	35.0	59.0

#ID = M00177
#Short = V$CREB_Q2
#Long = CREB (cAMP-response element-binding protein)
#W = 12
#Class = 1.1.7.1.1
#Quality = 2
#Factors = CREBomega,deltaCREB,CREBbeta,CREB,CREB1
#Organisms = human (Homo sapiens),cattle (Bos taurus),hamster (Cricetulus sp),mouse (Mus musculus),monkey (Cercopithecus aethiops),rat (Rattus norvegicus),domestic pig (Sus scrofa),mink (Mustela vison)
#Interactions = HM0279,HM0367,HM0368,HM0369,HM0370,HM0388,HM0393,HM0394,HM0395,HM0443,HM0444,HM0624,HM0625,HM0796,HM0797,HM0956,HM0957,HM0958,HM1026,HM1027,HM1028,HM1029,HM1085,HM1086,HM1087,HM1088,HM1124,HM1125,HM1126,HM1235,HM1236,M00017,M00033,M00039,M00040,M00041,M00045,M00077,M00113,M00114,M00115,M00133,M00135,M00136,M00137,M00138,M00161,M00162,M00172,M00173,M00174,M00177,M00178,M00179,M00188,M00195,M00199,M00203,M00210,M00248,M00338,M00339,M00340,M00342,M00350,M00351,M00444,M00517,M00531,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0025,MA0025_1,MA0025_2,MA0025_3,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0065_1,MA0074,MA0074_1,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0115,MA0115_1,MA0142,MA0142_1,MA0143_1,MA0143_2,MA0143_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0159,MA0159_1,MA0197,MA0197_1,MA0197_2,MA0197_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0693,MA0693_1,MA0693_2,MA0693_3,MA0693_4,MA0940,MA0940_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1146,MA1146_1,MA1146_2,MA1147,MA1147_1,MA1147_2,MA1148,MA1148_1,MA1148_2,MA1484,MA1484_1,MA1484_2,MA1849,MA1849_1,MA1849_2,MA1951,MA1951_1,MA1951_2
#Alternatives = M00039,M00113,M00178
#Transfac class = C0008
1.0	4.0	7.0	3.0
1.0	6.0	8.0	0.0
0.0	0.0	0.0	15.0
0.0	0.0	15.0	0.0
15.0	0.0	0.0	0.0
0.0	15.0	0.0	0.0
1.0	0.0	14.0	0.0
1.0	4.0	0.0	10.0
11.0	3.0	0.0	1.0
9.0	1.0	3.0	2.0
2.0	4.0	5.0	4.0
2.0	5.0	6.0	2.0

#ID = M00178
#Short = V$CREB_Q4
#Long = CREB (cAMP-response element binding protein)
#W = 12
#Class = 1.1.7.1.1
#Quality = 4
#Factors = CREBomega,deltaCREB,CREBbeta,CREB,CREB1
#Organisms = human (Homo sapiens),cattle (Bos taurus),hamster (Cricetulus sp),mouse (Mus musculus),monkey (Cercopithecus aethiops),rat (Rattus norvegicus),domestic pig (Sus scrofa),mink (Mustela vison)
#Interactions = HM0279,HM0367,HM0368,HM0369,HM0370,HM0388,HM0393,HM0394,HM0395,HM0443,HM0444,HM0624,HM0625,HM0796,HM0797,HM0956,HM0957,HM0958,HM1026,HM1027,HM1028,HM1029,HM1085,HM1086,HM1087,HM1088,HM1124,HM1125,HM1126,HM1235,HM1236,M00017,M00033,M00039,M00040,M00041,M00045,M00077,M00113,M00114,M00115,M00133,M00135,M00136,M00137,M00138,M00161,M00162,M00172,M00173,M00174,M00177,M00178,M00179,M00188,M00195,M00199,M00203,M00210,M00248,M00338,M00339,M00340,M00342,M00350,M00351,M00444,M00517,M00531,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0025,MA0025_1,MA0025_2,MA0025_3,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0065_1,MA0074,MA0074_1,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0115,MA0115_1,MA0142,MA0142_1,MA0143_1,MA0143_2,MA0143_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0159,MA0159_1,MA0197,MA0197_1,MA0197_2,MA0197_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0693,MA0693_1,MA0693_2,MA0693_3,MA0693_4,MA0940,MA0940_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1146,MA1146_1,MA1146_2,MA1147,MA1147_1,MA1147_2,MA1148,MA1148_1,MA1148_2,MA1484,MA1484_1,MA1484_2,MA1849,MA1849_1,MA1849_2,MA1951,MA1951_1,MA1951_2
#Alternatives = M00039,M00113,M00177
#Transfac class = C0008
2.0	6.0	7.0	5.0
1.0	7.0	11.0	1.0
0.0	0.0	0.0	20.0
0.0	0.0	20.0	0.0
20.0	0.0	0.0	0.0
0.0	20.0	0.0	0.0
1.0	0.0	19.0	0.0
1.0	5.0	0.0	14.0
10.0	8.0	0.0	2.0
14.0	1.0	4.0	1.0
2.0	6.0	6.0	6.0
3.0	9.0	6.0	2.0

#ID = M00179
#Short = V$CREBP1_Q2
#Long = ATF2 (Activating Transcription factor 2, CRE-binding protein 1)
#W = 12
#Quality = 2
#Factors = ATF-2-isoform3,ATF-2-xbb4,ATF-2-xbb3,ATF-2,ATF-2-isoform2,ATF-2-isoform1
#Organisms = human (Homo sapiens),mouse (Mus musculus),rat (Rattus norvegicus)
#Interactions = HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0220,HM0253,HM0279,HM0393,HM0394,HM0395,HM0624,HM0625,HM0694,HM0695,HM0770,HM0800,HM0956,HM0957,HM0958,HM0998,HM1085,HM1086,HM1087,HM1088,HM1188,HM1223,HM1224,M00017,M00033,M00039,M00040,M00041,M00051,M00052,M00054,M00059,M00069,M00113,M00114,M00115,M00116,M00133,M00135,M00136,M00137,M00138,M00159,M00161,M00162,M00172,M00173,M00174,M00177,M00178,M00179,M00188,M00190,M00194,M00195,M00199,M00201,M00208,M00210,M00248,M00249,M00338,M00342,M00495,M00513,M00514,M00517,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0045,MA0061,MA0089,MA0089_1,MA0089_2,MA0089_3,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0133,MA0142,MA0142_1,MA0143_1,MA0143_2,MA0143_3,MA0197,MA0197_1,MA0197_2,MA0197_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0940,MA0940_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1633,MA1633_1,MA1633_2,MA1849,MA1849_1,MA1849_2,MA1902,MA1902_1,MA1902_2,MA1911,MA1911_1,MA1911_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2193,MA2193_1,MA2264,MA2264_1
#Alternatives = M00040
#Transfac class = C0008
2.0	2.0	3.0	0.0
0.0	2.0	4.0	1.0
0.0	0.0	0.0	7.0
0.0	0.0	7.0	0.0
7.0	0.0	0.0	0.0
0.0	7.0	0.0	0.0
0.0	0.0	7.0	0.0
0.0	1.0	0.0	6.0
4.0	3.0	0.0	0.0
5.0	0.0	1.0	1.0
1.0	4.0	2.0	0.0
1.0	2.0	1.0	3.0

#ID = MA1474
#Short = CREB3L4
#Long = Cyclic AMP-responsive element-binding protein 3-like protein 4
#W = 10
#Class = 1.1.7.2.5
#Factors = CREB3L4,CR3L4
#Organisms = human (Homo sapiens)
#Alternatives = HM0277,HM0278,MA1474_2,MA1474_1,MA1475,MA1475_1,MA1475_2
#UniProt = Q8TEY5
#Jaspar = MA1474.2
#Evidence = HT-SELEX
#PubMed = 21711675
828.0	247.0	3891.0	1403.0
1118.0	3891.0	165.0	246.0
260.0	3891.0	112.0	221.0
3891.0	50.0	208.0	8.0
13.0	3891.0	20.0	130.0
306.0	65.0	3891.0	0.0
53.0	301.0	63.0	3891.0
500.0	3891.0	690.0	279.0
3891.0	515.0	769.0	275.0
284.0	2584.0	729.0	1308.0

#ID = MA1475
#Short = CREB3L4
#Long = Cyclic AMP-responsive element-binding protein 3-like protein 4
#W = 9
#Class = 1.1.7.2.5
#Factors = CREB3L4,CR3L4
#Organisms = human (Homo sapiens)
#Alternatives = HM0277,HM0278,MA1474,MA1474_1,MA1474_2,MA1475_2,MA1475_1
#UniProt = Q8TEY5
#Jaspar = MA1475.2
#Evidence = HT-SELEX
#PubMed = 21711675
504.0	221.0	790.0	75.0
0.0	138.0	48.0	1293.0
35.0	265.0	1293.0	258.0
1293.0	27.0	83.0	39.0
0.0	1293.0	6.0	43.0
81.0	3.0	1293.0	0.0
16.0	100.0	36.0	1293.0
176.0	1293.0	227.0	59.0
1293.0	35.0	153.0	40.0

#ID = HM0281
#Short = CREB5
#Long = Cyclic AMP-responsive element-binding protein 5
#W = 11
#Class = 1.1.1.3.3
#Factors = CREB5,CREBPA,CREB-5,cAMP-responsive element-binding protein 5,cAMP-response element-binding protein A,CRE-BPa
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0233,HM0234,HM0235,HM0281,HM0282,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,HM0400,HM0539,HM0540,HM0623,HM0683,HM0684,HM0685,HM0967,MA0099_2,MA0099_3,MA0099_4,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0655,MA0655_1,MA0656,MA0656_1,MA0656_2,MA0703,MA0703_1,MA0703_2,MA0703_3,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1495,MA1495_1,MA1495_2,MA1858,MA1858_1,MA1858_2,MA1931,MA1931_1,MA1951,MA1951_1,MA1951_2,MA1998,MA1998_1,MA1998_2,MA2312,MA2312_1
#Alternatives = HM0282,MA0840,MA0840_1,MA0840_2
#HOCOMOCOv13 = CREB5.H13CORE.0.P.B
#UniProt = Q02930,Q8K1L0
#HGNC = 16844
#GeneCards = CREB5
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 2443973
#Entrez = 9586,231991
346.0	159.0	319.0	176.0
662.0	115.0	181.0	42.0
39.0	6.0	11.0	944.0
3.0	11.0	806.0	180.0
914.0	29.0	26.0	31.0
76.0	38.0	263.0	623.0
14.0	117.0	824.0	45.0
21.0	104.0	27.0	848.0
297.0	667.0	11.0	25.0
970.0	13.0	2.0	15.0
30.0	117.0	119.0	734.0

#ID = HM0282
#Short = CREB5
#Long = Cyclic AMP-responsive element-binding protein 5
#W = 12
#Class = 1.1.1.3.3
#Factors = CREB5,CREBPA,CREB-5,cAMP-responsive element-binding protein 5,cAMP-response element-binding protein A,CRE-BPa
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0233,HM0234,HM0235,HM0281,HM0282,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,HM0400,HM0539,HM0540,HM0623,HM0683,HM0684,HM0685,HM0967,MA0099_2,MA0099_3,MA0099_4,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0655,MA0655_1,MA0656,MA0656_1,MA0656_2,MA0703,MA0703_1,MA0703_2,MA0703_3,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1495,MA1495_1,MA1495_2,MA1858,MA1858_1,MA1858_2,MA1931,MA1931_1,MA1951,MA1951_1,MA1951_2,MA1998,MA1998_1,MA1998_2,MA2312,MA2312_1
#Alternatives = HM0281,MA0840,MA0840_1,MA0840_2
#HOCOMOCOv13 = CREB5.H13CORE.1.SM.B
#UniProt = Q02930,Q8K1L0
#HGNC = 16844
#GeneCards = CREB5
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 1
#MGI = 2443973
#Entrez = 9586,231991
1397.0	2554.0	2584.0	2933.0
2093.0	1381.0	4843.0	1151.0
6896.0	29.0	2526.0	20.0
0.0	36.0	1.0	9434.0
0.0	0.0	9013.0	458.0
9462.0	0.0	1.0	8.0
4.0	6643.0	263.0	2561.0
431.0	31.0	9009.0	0.0
45.0	76.0	6.0	9344.0
3310.0	5988.0	118.0	55.0
7687.0	329.0	1132.0	323.0
588.0	2636.0	1384.0	4862.0

#ID = MA0018
#Short = CREB1
#Long = Cyclic AMP-responsive element-binding protein 1
#W = 8
#Class = 1.1.7.1.1
#Factors = CREB1
#Organisms = human (Homo sapiens)
#Interactions = HM0203,HM0204,HM0279,HM0717,HM0718,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM0796,HM0797,M00001,M00008,M00017,M00032,M00033,M00034,M00039,M00040,M00041,M00045,M00051,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00113,M00114,M00115,M00116,M00117,M00135,M00136,M00137,M00138,M00148,M00152,M00155,M00158,M00159,M00160,M00161,M00162,M00172,M00177,M00178,M00179,M00184,M00185,M00186,M00190,M00191,M00192,M00194,M00195,M00196,M00201,M00203,M00205,M00208,M00210,M00215,M00216,M00223,M00224,M00225,M00242,M00248,M00249,M00252,M00260,M00272,M00284,M00285,M00302,M00338,M00339,M00340,M00342,M00350,M00351,M00396,M00418,M00419,M00444,M00447,M00466,M00471,M00481,M00492,M00495,M00496,M00497,M00498,M00513,M00514,M00517,M00518,M00538,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0025,MA0025_1,MA0025_2,MA0025_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0498,MA0498_1,MA0498_2,MA0498_3,MA0604,MA0604_1,MA0624,MA0624_1,MA0624_2,MA0624_3,MA1639,MA1639_1,MA1639_2,MA1849,MA1849_1,MA1849_2
#Alternatives = HM0279,MA0018_5,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA1849,MA1849_1,MA1849_2
#UniProt = P16220
#Jaspar = MA0018.5
#Evidence = ChIP-seq
#PubMed = 17916232
1911.0	970.0	1109.0	75554.0
1728.0	2298.0	72555.0	2963.0
73505.0	1748.0	2012.0	2279.0
2186.0	14144.0	6339.0	56875.0
1417.0	1895.0	74401.0	1831.0
8889.0	1231.0	1207.0	68217.0
3533.0	71982.0	2177.0	1852.0
75819.0	1018.0	1222.0	1485.0

#ID = MA0839
#Short = CREB3L1
#Long = Cyclic AMP-responsive element-binding protein 3-like protein 1
#W = 13
#Class = 1.1.7.2.2
#Factors = CREB3L1,CR3L1
#Organisms = human (Homo sapiens)
#Interactions = HM0036
#Alternatives = HM0275,MA0839_2,MA0839_1
#UniProt = Q96BA8
#Jaspar = MA0839.2
#Evidence = HT-SELEX
#PubMed = 21041443
38.0	159.0	29.0	671.0
20.0	3.0	671.0	18.0
61.0	671.0	0.0	2.0
3.0	671.0	0.0	5.0
671.0	0.0	3.0	0.0
0.0	671.0	3.0	0.0
21.0	3.0	671.0	0.0
7.0	0.0	3.0	671.0
121.0	671.0	40.0	10.0
671.0	33.0	72.0	39.0
60.0	186.0	125.0	300.0
76.0	671.0	64.0	79.0
671.0	65.0	167.0	127.0

#ID = MA0840
#Short = Creb5
#Long = Cyclic AMP-responsive element-binding protein 5
#W = 10
#Class = 1.1.1.3.3
#Factors = Creb5
#Organisms = mouse (Mus musculus)
#Interactions = HM0233,HM0234,HM0235,HM0281,HM0282,HM0393,HM0394,HM0395,HM0396,HM0397,HM0398,HM0399,HM0400,HM0539,HM0540,HM0623,HM0683,HM0684,HM0685,HM0967,MA0099_2,MA0099_3,MA0099_4,MA0476,MA0476_1,MA0476_2,MA0477,MA0477_1,MA0477_2,MA0477_3,MA0478,MA0478_1,MA0478_2,MA0655,MA0655_1,MA0656,MA0656_1,MA0656_2,MA0703,MA0703_1,MA0703_2,MA0703_3,MA0835,MA0835_1,MA0835_2,MA0835_3,MA0840,MA0840_1,MA0840_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1134,MA1134_1,MA1134_2,MA1135,MA1135_1,MA1135_2,MA1136,MA1136_1,MA1137,MA1137_1,MA1137_2,MA1138,MA1138_1,MA1138_2,MA1139,MA1139_1,MA1139_2,MA1141,MA1141_1,MA1141_2,MA1142,MA1142_1,MA1142_2,MA1143,MA1143_1,MA1143_2,MA1144,MA1144_1,MA1144_2,MA1145,MA1145_1,MA1145_2,MA1495,MA1495_1,MA1495_2,MA1858,MA1858_1,MA1858_2,MA1931,MA1931_1,MA1951,MA1951_1,MA1951_2,MA1998,MA1998_1,MA1998_2,MA2312,MA2312_1
#Alternatives = HM0281,HM0282,MA0840_2,MA0840_1
#UniProt = Q8K1L0
#Jaspar = MA0840.2
#Evidence = HT-SELEX
#PubMed = 11134034
3704.0	227.0	256.0	40.0
6.0	16.0	0.0	3704.0
13.0	6.0	3704.0	918.0
3704.0	0.0	1.0	10.0
0.0	3704.0	0.0	57.0
151.0	0.0	3704.0	0.0
18.0	6.0	0.0	3704.0
917.0	3704.0	0.0	4.0
3704.0	0.0	0.0	2.0
25.0	1861.0	77.0	1843.0

#ID = HM0280
#Short = CREB3
#Long = Cyclic AMP-responsive element-binding protein 3
#W = 14
#Class = 1.1.7.2.1
#Factors = CREB3,LZIP,CREB-3,cAMP-responsive element-binding protein 3,Leucine zipper protein,Luman,Transcription factor LZIP-alpha,N-terminal Luman,Transcriptionally active form
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0036,HM0280,HM0295,HM0624,HM0625,MA0099_2,MA0099_3,MA0099_4,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0488,MA0488_1,MA0488_2,MA0489,MA0489_1,MA0489_2,MA0489_3,MA0638,MA0638_1,MA0638_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2
#Alternatives = MA0638,MA0638_1,MA0638_2
#HOCOMOCOv13 = CREB3.H13CORE.0.SM.B
#UniProt = O43889,Q61817
#HGNC = 2347
#GeneCards = CREB3
#HMQuality = B
#Evidence = HT-SELEX,Methyl-HT-SELEX
#Subtype = 0
#MGI = 99946
#Entrez = 10488
79.0	75.0	153.0	101.0
105.0	30.0	94.0	178.0
57.0	68.0	250.0	35.0
188.0	14.0	207.0	1.0
0.0	5.0	1.0	404.0
0.0	5.0	404.0	1.0
410.0	0.0	0.0	0.0
0.0	410.0	0.0	0.0
0.0	0.0	410.0	0.0
0.0	1.0	0.0	409.0
2.0	131.0	277.0	0.0
143.0	0.0	246.0	21.0
68.0	266.0	15.0	60.0
134.0	84.0	122.0	67.0

#ID = HM0279
#Short = CREB1
#Long = Cyclic AMP-responsive element-binding protein 1
#W = 11
#Class = 1.1.7.1.1
#Factors = CREB1,Creb-1,cAMP-responsive element-binding protein 1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0203,HM0204,HM0279,HM0717,HM0718,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM0796,HM0797,M00001,M00008,M00017,M00032,M00033,M00034,M00039,M00040,M00041,M00045,M00051,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00113,M00114,M00115,M00116,M00117,M00135,M00136,M00137,M00138,M00148,M00152,M00155,M00158,M00159,M00160,M00161,M00162,M00172,M00177,M00178,M00179,M00184,M00185,M00186,M00190,M00191,M00192,M00194,M00195,M00196,M00201,M00203,M00205,M00208,M00210,M00215,M00216,M00223,M00224,M00225,M00242,M00248,M00249,M00252,M00260,M00272,M00284,M00285,M00302,M00338,M00339,M00340,M00342,M00350,M00351,M00396,M00418,M00419,M00444,M00447,M00466,M00471,M00481,M00492,M00495,M00496,M00497,M00498,M00513,M00514,M00517,M00518,M00538,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0025,MA0025_1,MA0025_2,MA0025_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0498,MA0498_1,MA0498_2,MA0498_3,MA0604,MA0604_1,MA0624,MA0624_1,MA0624_2,MA0624_3,MA1639,MA1639_1,MA1639_2,MA1849,MA1849_1,MA1849_2
#Alternatives = MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA1849,MA1849_1,MA1849_2
#HOCOMOCOv13 = CREB1.H13CORE.0.PSM.A
#UniProt = P16220,Q01147
#HGNC = 2345
#GeneCards = CREB1
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX,Methyl-HT-SELEX
#Subtype = 0
#MGI = 88494
#Entrez = 1385,12912
1179.0	1876.0	1706.0	955.0
2980.0	60.0	2676.0	0.0
0.0	0.0	0.0	5716.0
0.0	0.0	5716.0	0.0
5716.0	0.0	0.0	0.0
0.0	5716.0	0.0	0.0
0.0	0.0	5716.0	0.0
0.0	32.0	0.0	5684.0
2635.0	2463.0	516.0	102.0
3730.0	325.0	1145.0	515.0
807.0	2135.0	1852.0	921.0

#ID = HM0036
#Short = CREB3L3
#Long = Cyclic AMP-responsive element-binding protein 3-like protein 3
#W = 14
#Class = 1.1.7.2.4
#Factors = CREB3L3,CREBH,cAMP-responsive element-binding protein 3-like protein 3,Transcription factor CREB-H
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0036,HM0214,HM0275,HM0280,HM0796,HM0797,M00483,MA0025,MA0025_1,MA0025_2,MA0025_3,MA0638,MA0638_1,MA0638_2,MA0839,MA0839_1,MA0839_2,MA1466,MA1466_1,MA1466_2,MA2194,MA2194_1
#HOCOMOCOv13 = CREB3L3.H13CORE.0.PSGIB.A
#UniProt = Q68CJ9,Q91XE9
#HGNC = 18855
#GeneCards = CREB3L3
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX,Genomic HT-SELEX,SMiLE-Seq,PBM
#Subtype = 0
#MGI = 2384786
#Entrez = 84699,208677
68.0	54.0	86.0	218.0
17.0	13.0	277.0	119.0
98.0	51.0	241.0	36.0
47.0	132.0	5.0	242.0
8.0	168.0	246.0	4.0
424.0	0.0	2.0	0.0
0.0	424.0	0.0	2.0
3.0	0.0	423.0	0.0
0.0	0.0	0.0	426.0
0.0	8.0	418.0	0.0
10.0	0.0	392.0	24.0
81.0	339.0	2.0	4.0
316.0	33.0	55.0	22.0
54.0	130.0	182.0	60.0

#ID = MA1849
#Short = Creb1
#Long = Cyclic AMP-responsive element-binding protein 1
#W = 10
#Class = 1.1.7.1.1
#Factors = Creb1
#Organisms = vase tunicate (Ciona intestinalis)
#Interactions = HM0203,HM0204,HM0279,HM0717,HM0718,HM0773,HM0774,HM0775,HM0776,HM0777,HM0778,HM0779,HM0780,HM0781,HM0796,HM0797,M00001,M00008,M00017,M00032,M00033,M00034,M00039,M00040,M00041,M00045,M00051,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00113,M00114,M00115,M00116,M00117,M00135,M00136,M00137,M00138,M00148,M00152,M00155,M00158,M00159,M00160,M00161,M00162,M00172,M00177,M00178,M00179,M00184,M00185,M00186,M00190,M00191,M00192,M00194,M00195,M00196,M00201,M00203,M00205,M00208,M00210,M00215,M00216,M00223,M00224,M00225,M00242,M00248,M00249,M00252,M00260,M00272,M00284,M00285,M00302,M00338,M00339,M00340,M00342,M00350,M00351,M00396,M00418,M00419,M00444,M00447,M00466,M00471,M00481,M00492,M00495,M00496,M00497,M00498,M00513,M00514,M00517,M00518,M00538,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0025,MA0025_1,MA0025_2,MA0025_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0498,MA0498_1,MA0498_2,MA0498_3,MA0604,MA0604_1,MA0624,MA0624_1,MA0624_2,MA0624_3,MA1639,MA1639_1,MA1639_2,MA1849,MA1849_1,MA1849_2
#Alternatives = HM0279,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA1849_2,MA1849_1
#Jaspar = MA1849.2
#Evidence = SELEX
#PubMed = 26684323
495.0	46.0	436.0	23.0
10.0	12.0	6.0	971.0
7.0	19.0	941.0	32.0
986.0	4.0	5.0	5.0
3.0	988.0	3.0	6.0
6.0	3.0	988.0	3.0
5.0	5.0	4.0	986.0
32.0	941.0	19.0	7.0
971.0	6.0	12.0	10.0
23.0	436.0	46.0	495.0

#ID = M00113
#Short = V$CREB_02
#Long = CREB (cAMP-responsive element binding protein)
#W = 12
#Class = 1.1.7.1.1
#Factors = deltaCREB,CREB,CREB1
#Organisms = rat (Rattus norvegicus),human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0279,HM0367,HM0368,HM0369,HM0370,HM0388,HM0443,HM0444,HM0956,HM0957,HM0958,HM1026,HM1027,HM1028,HM1029,HM1085,HM1086,HM1087,HM1088,HM1124,HM1125,HM1126,HM1235,HM1236,M00017,M00033,M00039,M00041,M00045,M00077,M00113,M00114,M00115,M00133,M00135,M00136,M00137,M00138,M00161,M00162,M00172,M00177,M00178,M00179,M00195,M00203,M00210,M00248,M00338,M00339,M00340,M00342,M00350,M00351,M00444,M00517,M00531,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0065_1,MA0074,MA0074_1,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0115,MA0115_1,MA0142,MA0142_1,MA0143_1,MA0143_2,MA0143_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0159,MA0159_1,MA0197,MA0197_1,MA0197_2,MA0197_3,MA0693,MA0693_1,MA0693_2,MA0693_3,MA0693_4,MA1146,MA1146_1,MA1146_2,MA1147,MA1147_1,MA1147_2,MA1148,MA1148_1,MA1148_2,MA1484,MA1484_1,MA1484_2,MA1849,MA1849_1,MA1849_2
#Alternatives = M00039,M00177,M00178
#Transfac class = C0008
2.0	5.0	4.0	5.0
1.0	3.0	6.0	6.0
2.0	2.0	12.0	0.0
5.0	1.0	7.0	3.0
0.0	0.0	0.0	16.0
0.0	0.0	15.0	1.0
16.0	0.0	0.0	0.0
0.0	15.0	1.0	0.0
0.0	0.0	15.0	1.0
1.0	5.0	0.0	10.0
4.0	7.0	3.0	2.0
5.0	6.0	3.0	2.0

#ID = M00039
#Short = V$CREB_01
#Long = CREB (cAMP-responsive element binding protein)
#W = 8
#Class = 1.1.7.1.1
#Factors = CREB,deltaCREB,CREB1
#Organisms = rat (Rattus norvegicus),human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0279,HM0367,HM0368,HM0369,HM0370,HM0388,HM0443,HM0444,HM0956,HM0957,HM0958,HM1026,HM1027,HM1028,HM1029,HM1085,HM1086,HM1087,HM1088,HM1124,HM1125,HM1126,HM1235,HM1236,M00017,M00033,M00039,M00041,M00045,M00077,M00113,M00114,M00115,M00133,M00135,M00136,M00137,M00138,M00161,M00162,M00172,M00177,M00178,M00179,M00195,M00203,M00210,M00248,M00338,M00339,M00340,M00342,M00350,M00351,M00444,M00517,M00531,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0065_1,MA0074,MA0074_1,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0115,MA0115_1,MA0142,MA0142_1,MA0143_1,MA0143_2,MA0143_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0159,MA0159_1,MA0197,MA0197_1,MA0197_2,MA0197_3,MA0693,MA0693_1,MA0693_2,MA0693_3,MA0693_4,MA1146,MA1146_1,MA1146_2,MA1147,MA1147_1,MA1147_2,MA1148,MA1148_1,MA1148_2,MA1484,MA1484_1,MA1484_2,MA1849,MA1849_1,MA1849_2
#Alternatives = M00113,M00177,M00178
#Transfac class = C0008
0.0	0.0	0.0	29.0
0.0	0.0	28.0	1.0
29.0	0.0	0.0	0.0
0.0	29.0	0.0	0.0
0.0	1.0	28.0	0.0
0.0	1.0	1.0	27.0
12.0	16.0	1.0	0.0
17.0	1.0	4.0	7.0

#ID = M00040
#Short = V$CREBP1_01
#Long = ATF2 (Activating transcription factor 2, cAMP-responsive element binding protein 1)
#W = 8
#Factors = ATF-2-xbb4
#Organisms = human (Homo sapiens)
#Interactions = HM0207,HM0208,HM0209,HM0210,HM0220,HM0253,HM0279,HM0393,HM0394,HM0395,HM0624,HM0625,HM0694,HM0695,HM0770,HM0800,HM0956,HM0957,HM0958,HM0998,HM1085,HM1086,HM1087,HM1088,HM1188,M00017,M00033,M00040,M00041,M00051,M00052,M00054,M00059,M00069,M00114,M00115,M00116,M00133,M00135,M00136,M00137,M00138,M00159,M00161,M00162,M00172,M00173,M00174,M00177,M00178,M00179,M00188,M00190,M00194,M00195,M00199,M00201,M00208,M00210,M00248,M00249,M00338,M00342,M00495,M00513,M00514,M00517,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0045,MA0061,MA0089,MA0089_1,MA0089_2,MA0089_3,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0133,MA0142,MA0142_1,MA0143_1,MA0143_2,MA0143_3,MA0197,MA0197_1,MA0197_2,MA0197_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0940,MA0940_1,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1633,MA1633_1,MA1633_2,MA1849,MA1849_1,MA1849_2,MA1902,MA1902_1,MA1902_2,MA1911,MA1911_1,MA1911_2,MA1951,MA1951_1,MA1951_2,MA1988,MA1988_1,MA1988_2,MA2193,MA2193_1,MA2264,MA2264_1
#Alternatives = M00179
#Transfac class = C0008
0.0	0.0	0.0	47.0
0.0	0.0	8.0	39.0
47.0	0.0	0.0	0.0
0.0	47.0	0.0	0.0
4.0	0.0	43.0	0.0
0.0	0.0	0.0	47.0
39.0	7.0	0.0	1.0
45.0	2.0	0.0	0.0

#ID = M00041
#Short = V$CREBP1CJUN_01
#Long = ATF2:c-Jun (Activating transcription factor 2 (CRE-binding protein 1):c-Jun heterodimer)
#W = 8
#Factors = c-Jun,ATF-2-xbb4
#Organisms = chick (Gallus gallus),monkey (Cercopithecus aethiops),domestic pig (Sus scrofa),rat (Rattus norvegicus),human (Homo sapiens),cattle (Bos taurus),sheep (Ovis aries),Japanese quail (Coturnix coturnix japonica),rabbit (Oryctolagus cuniculus),dog (Canis familiaris (Canis canis)),hamster (Cricetulus sp),mouse (Mus musculus)
#Interactions = HM0178,HM0185,HM0186,HM0187,HM0194,HM0195,HM0207,HM0208,HM0209,HM0210,HM0211,HM0212,HM0213,HM0220,HM0253,HM0254,HM0255,HM0269,HM0270,HM0279,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0369,HM0370,HM0388,HM0393,HM0394,HM0395,HM0439,HM0440,HM0454,HM0455,HM0484,HM0485,HM0502,HM0503,HM0509,HM0510,HM0512,HM0521,HM0624,HM0625,HM0694,HM0695,HM0770,HM0777,HM0778,HM0779,HM0780,HM0781,HM0800,HM0956,HM0957,HM0958,HM0961,HM0962,HM0964,HM0965,HM0998,HM1018,HM1026,HM1027,HM1028,HM1029,HM1072,HM1073,HM1074,HM1085,HM1086,HM1087,HM1088,HM1095,HM1101,HM1102,HM1103,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1133,HM1134,HM1137,HM1138,HM1140,HM1141,HM1146,HM1147,HM1148,HM1149,HM1188,HM1198,HM1223,HM1224,HM1231,M00001,M00008,M00017,M00032,M00033,M00039,M00040,M00041,M00042,M00051,M00052,M00053,M00054,M00059,M00069,M00074,M00109,M00113,M00114,M00115,M00116,M00117,M00133,M00135,M00136,M00137,M00138,M00148,M00155,M00158,M00159,M00160,M00161,M00162,M00172,M00173,M00174,M00177,M00178,M00179,M00184,M00188,M00190,M00191,M00192,M00194,M00195,M00196,M00199,M00201,M00205,M00208,M00210,M00216,M00223,M00224,M00225,M00236,M00242,M00248,M00249,M00252,M00259,M00260,M00284,M00302,M00311,M00320,M00338,M00339,M00340,M00342,M00396,M00410,M00418,M00447,M00454,M00466,M00471,M00481,M00492,M00495,M00496,M00497,M00498,M00512,M00513,M00514,M00515,M00517,M00518,M00528,M00531,M00539,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0004,MA0004_1,MA0006,MA0006_1,MA0006_2,MA0007,MA0007_1,MA0007_2,MA0007_3,MA0007_4,MA0017,MA0017_1,MA0017_2,MA0017_3,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0027,MA0027_1,MA0027_2,MA0027_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0043,MA0043_1,MA0043_2,MA0043_3,MA0043_4,MA0045,MA0055,MA0061,MA0065,MA0065_1,MA0065_2,MA0065_3,MA0066,MA0066_1,MA0066_2,MA0077,MA0077_1,MA0077_2,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0084,MA0084_1,MA0084_2,MA0087,MA0087_1,MA0087_2,MA0087_3,MA0089,MA0089_1,MA0089_2,MA0089_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0095,MA0095_1,MA0095_2,MA0095_3,MA0095_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0099,MA0099_1,MA0099_2,MA0099_3,MA0099_4,MA0101,MA0101_1,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0105,MA0105_1,MA0105_2,MA0105_3,MA0105_4,MA0107,MA0107_1,MA0108,MA0108_1,MA0108_2,MA0108_3,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0114,MA0114_1,MA0114_2,MA0114_3,MA0114_4,MA0114_5,MA0117,MA0117_1,MA0117_2,MA0117_3,MA0133,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0142,MA0142_1,MA0143,MA0143_1,MA0143_2,MA0143_3,MA0143_4,MA0143_5,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0197,MA0197_1,MA0197_2,MA0197_3,MA0201,MA0201_1,MA0220,MA0220_1,MA0258,MA0258_1,MA0258_2,MA0259,MA0259_1,MA0259_2,MA0386,MA0386_1,MA0386_2,MA0442,MA0442_1,MA0442_2,MA0442_3,MA0462,MA0462_1,MA0462_2,MA0462_3,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0476,MA0476_1,MA0476_2,MA0488,MA0488_1,MA0488_2,MA0489_1,MA0494,MA0494_1,MA0494_2,MA0512,MA0512_1,MA0512_2,MA0517,MA0517_1,MA0517_2,MA0518,MA0518_1,MA0518_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0605,MA0605_1,MA0605_2,MA0605_3,MA0833,MA0833_1,MA0833_2,MA0833_3,MA0940,MA0940_1,MA1106,MA1106_1,MA1106_2,MA1126,MA1126_1,MA1126_2,MA1127,MA1127_1,MA1128,MA1128_1,MA1128_2,MA1129,MA1129_1,MA1130,MA1130_1,MA1130_2,MA1131,MA1131_1,MA1131_2,MA1132,MA1132_1,MA1132_2,MA1133,MA1133_1,MA1133_2,MA1134,MA1134_1,MA1134_2,MA1141,MA1141_1,MA1141_2,MA1484,MA1484_1,MA1484_2,MA1494,MA1494_1,MA1494_2,MA1537,MA1537_1,MA1537_2,MA1538,MA1538_1,MA1633,MA1633_1,MA1633_2,MA1849,MA1849_1,MA1849_2,MA1902,MA1902_1,MA1902_2,MA1911,MA1911_1,MA1911_2,MA1951,MA1951_1,MA1951_2,MA1962,MA1962_1,MA1988,MA1988_1,MA1988_2,MA2168,MA2168_1,MA2193,MA2193_1,MA2264,MA2264_1,MA2279,MA2279_1,MA2338,MA2338_1,MA2388,MA2388_1
#Transfac class = C0008
0.0	1.0	0.0	42.0
2.0	0.0	41.0	0.0
43.0	0.0	0.0	0.0
0.0	43.0	0.0	0.0
2.0	1.0	40.0	0.0
0.0	0.0	0.0	43.0
0.0	20.0	3.0	20.0
40.0	1.0	0.0	2.0

#ID = MA2209
#Short = CrebA
#Long = Cyclic AMP response element-binding protein A
#W = 12
#Class = 1.1.7
#Factors = CrebA
#Organisms = fruit fly (Drosophila melanogaster)
#Alternatives = MA2209_1
#UniProt = P29747
#Jaspar = MA2209.1
#Evidence = SELEX
#PubMed = 21097781
80.0	123.0	111.0	684.0
51.0	10.0	891.0	46.0
165.0	816.0	7.0	10.0
69.0	837.0	36.0	56.0
992.0	2.0	4.0	1.0
2.0	995.0	1.0	1.0
4.0	0.0	994.0	1.0
1.0	8.0	6.0	984.0
58.0	31.0	839.0	70.0
13.0	5.0	806.0	174.0
37.0	888.0	11.0	63.0
682.0	111.0	122.0	84.0

#ID = MA2210
#Short = CrebB
#Long = Cyclic AMP response element-binding protein B
#W = 10
#Class = 1.1.7
#Factors = CrebB
#Organisms = fruit fly (Drosophila melanogaster)
#Alternatives = MA2210_1
#UniProt = Q9VWW0
#Jaspar = MA2210.1
#Evidence = SELEX
#PubMed = 7651429
442.0	111.0	397.0	49.0
6.0	12.0	2.0	977.0
2.0	7.0	830.0	159.0
986.0	4.0	1.0	7.0
3.0	986.0	1.0	8.0
8.0	3.0	987.0	0.0
8.0	7.0	2.0	981.0
152.0	839.0	5.0	2.0
981.0	5.0	10.0	3.0
42.0	396.0	114.0	445.0

#ID = M00346
#Short = V$GATA1_05
#Long = GATA-1 (GATA-binding factor 1)
#W = 10
#Class = 2.2.1.1.1
#Factors = GATA-1B,GATA-1,GATA-1 isoform 1,GATA-1 isoform 2,GATA-1A
#Organisms = human (Homo sapiens),mouse (Mus musculus),clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus)
#Interactions = HM0177,HM0253,HM0254,HM0255,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0439,HM0440,HM0441,HM0442,HM0443,HM0444,HM0454,HM0455,HM0484,HM0485,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1018,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1137,HM1138,HM1140,HM1146,HM1147,HM1148,HM1198,HM1231,M00008,M00075,M00076,M00077,M00109,M00116,M00117,M00121,M00122,M00126,M00127,M00128,M00187,M00191,M00192,M00196,M00203,M00205,M00217,M00223,M00224,M00225,M00259,M00271,M00277,M00278,M00339,M00346,M00347,M00348,M00349,M00350,M00351,M00454,M00492,M00496,M00497,M00531,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0036,MA0036_1,MA0036_2,MA0036_3,MA0036_4,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0055,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0517,MA0517_1,MA0517_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1926,MA1926_1,MA1926_2,MA1931,MA1931_1,MA2279,MA2279_1,MA2290,MA2290_1,MA2312,MA2312_1,MA2388,MA2388_1
#Alternatives = M00075,M00126,M00127,M00128,M00347,HM0439,HM0440,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA2388,MA2388_1
#Transfac class = C0003
3.0	2.0	4.0	1.0
2.0	6.0	1.0	1.0
4.0	2.0	0.0	4.0
0.0	0.0	10.0	0.0
10.0	0.0	0.0	0.0
0.0	0.0	0.0	10.0
10.0	0.0	0.0	0.0
10.0	0.0	0.0	0.0
2.0	6.0	2.0	0.0
6.0	2.0	1.0	1.0

#ID = M00347
#Short = V$GATA1_06
#Long = GATA-1 (GATA-binding factor 1)
#W = 10
#Class = 2.2.1.1.1
#Factors = GATA-1B,GATA-1,GATA-1 isoform 1,GATA-1 isoform 2,GATA-1A
#Organisms = human (Homo sapiens),mouse (Mus musculus),clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus)
#Interactions = HM0177,HM0253,HM0254,HM0255,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0439,HM0440,HM0441,HM0442,HM0443,HM0444,HM0454,HM0455,HM0484,HM0485,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1018,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1137,HM1138,HM1140,HM1146,HM1147,HM1148,HM1198,HM1231,M00008,M00075,M00076,M00077,M00109,M00116,M00117,M00121,M00122,M00126,M00127,M00128,M00187,M00191,M00192,M00196,M00203,M00205,M00217,M00223,M00224,M00225,M00259,M00271,M00277,M00278,M00339,M00346,M00347,M00348,M00349,M00350,M00351,M00454,M00492,M00496,M00497,M00531,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0036,MA0036_1,MA0036_2,MA0036_3,MA0036_4,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0055,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0517,MA0517_1,MA0517_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1926,MA1926_1,MA1926_2,MA1931,MA1931_1,MA2279,MA2279_1,MA2290,MA2290_1,MA2312,MA2312_1,MA2388,MA2388_1
#Alternatives = M00075,M00126,M00127,M00128,M00346,HM0439,HM0440,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA2388,MA2388_1
#Transfac class = C0003
7.0	6.0	1.0	1.0
2.0	4.0	3.0	6.0
11.0	2.0	0.0	2.0
0.0	0.0	15.0	0.0
15.0	0.0	0.0	0.0
0.0	0.0	0.0	15.0
14.0	1.0	0.0	0.0
15.0	0.0	0.0	0.0
3.0	4.0	7.0	1.0
9.0	1.0	5.0	0.0

#ID = HM0440
#Short = GATA1
#Long = Erythroid transcription factor
#W = 10
#Class = 2.2.1.1.1
#Factors = GATA1,ERYF1,GF1,Gf-1,GATA-binding factor 1,GATA-1,NF-E1 DNA-binding protein
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0177,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1146,HM1147,HM1148,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00454,M00469,M00471,M00497,M00517,M00531,M00615,MA0140,MA0140_1,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1931,MA1931_1,MA2312,MA2312_1
#Alternatives = M00075,M00126,M00127,M00128,M00346,M00347,HM0439,HM1146,HM1147,HM1148,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091,MA0091_1,MA0091_2,MA0140,MA0140_1,MA0140_2,MA0140_3,MA2388,MA2388_1
#HOCOMOCOv13 = GATA1.H13CORE.1.PSM.A
#UniProt = P15976,P17679
#HGNC = 4170
#GeneCards = GATA1
#HMQuality = A
#Evidence = ChIP-Seq,HT-SELEX,Methyl-HT-SELEX
#Subtype = 1
#MGI = 95661
#Entrez = 2623,14460
303.0	188.0	327.0	188.0
138.0	444.0	305.0	119.0
629.0	38.0	9.0	330.0
0.0	1.0	1003.0	2.0
997.0	4.0	1.0	4.0
5.0	7.0	6.0	988.0
956.0	5.0	5.0	40.0
891.0	8.0	89.0	18.0
127.0	158.0	671.0	50.0
333.0	233.0	386.0	54.0

#ID = M00203
#Short = V$GATA_C
#Long = GATA-X (GATA binding site)
#W = 11
#Class = 2.2.1.1.3
#Factors = GATA-3 isoform-1,GATA-1B,GATA-3,GATA-1,GATA-1 isoform 1,GATA-3 isoform-2,GATA-1 isoform 2,GATA-2,GATA-1A
#Organisms = human (Homo sapiens),cattle (Bos taurus),mouse (Mus musculus),clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus),cat (Felis silvestris catus)
#Interactions = HM0253,HM0254,HM0255,HM0279,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0439,HM0440,HM0441,HM0442,HM0443,HM0444,HM0454,HM0455,HM0484,HM0485,HM0777,HM0778,HM0779,HM0780,HM0781,HM1018,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1137,HM1138,HM1140,HM1146,HM1147,HM1148,HM1198,HM1231,M00008,M00039,M00075,M00076,M00077,M00109,M00113,M00114,M00115,M00116,M00117,M00121,M00122,M00126,M00127,M00128,M00159,M00177,M00178,M00187,M00190,M00191,M00192,M00196,M00201,M00203,M00205,M00217,M00223,M00224,M00225,M00249,M00259,M00271,M00277,M00278,M00302,M00339,M00346,M00347,M00348,M00349,M00350,M00351,M00454,M00492,M00496,M00497,M00531,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0018,MA0018_1,MA0018_2,MA0018_3,MA0018_4,MA0018_5,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0036,MA0036_1,MA0036_2,MA0036_3,MA0036_4,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0055,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0152,MA0152_1,MA0152_2,MA0152_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0201,MA0201_1,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0517,MA0517_1,MA0517_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1849,MA1849_1,MA1849_2,MA1926,MA1926_1,MA1926_2,MA2279,MA2279_1,MA2290,MA2290_1,MA2388,MA2388_1
#Transfac class = C0003
6.39	0.0	4.0	4.4
0.0	0.0	16.31	0.0
16.31	0.0	0.0	0.0
0.0	0.82	0.0	15.49
16.31	0.0	0.0	0.0
10.8	1.4	2.62	0.91
4.32	0.84	10.31	0.84
4.04	2.95	5.08	4.25
5.74	6.76	2.29	1.52
4.46	7.12	0.68	4.05
4.78	4.08	1.63	5.82

#ID = M00126
#Short = V$GATA1_02
#Long = GATA-1 (GATA-binding factor 1)
#W = 14
#Class = 2.2.1.1.1
#Factors = GATA-1B,GATA-1,GATA-1 isoform 1,GATA-1 isoform 2,GATA-1A
#Organisms = human (Homo sapiens),mouse (Mus musculus),clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus)
#Interactions = HM0177,HM0253,HM0254,HM0255,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0439,HM0440,HM0441,HM0442,HM0443,HM0444,HM0454,HM0455,HM0484,HM0485,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1018,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1137,HM1138,HM1140,HM1146,HM1147,HM1148,HM1198,HM1231,M00008,M00075,M00076,M00077,M00109,M00116,M00117,M00121,M00122,M00126,M00127,M00128,M00187,M00191,M00192,M00196,M00203,M00205,M00217,M00223,M00224,M00225,M00259,M00271,M00277,M00278,M00339,M00346,M00347,M00348,M00349,M00350,M00351,M00454,M00492,M00496,M00497,M00531,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0036,MA0036_1,MA0036_2,MA0036_3,MA0036_4,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0055,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0517,MA0517_1,MA0517_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1926,MA1926_1,MA1926_2,MA1931,MA1931_1,MA2279,MA2279_1,MA2290,MA2290_1,MA2312,MA2312_1,MA2388,MA2388_1
#Alternatives = M00075,M00127,M00128,M00346,M00347,HM0439,HM0440,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA2388,MA2388_1
#Transfac class = C0003
3.0	3.0	7.0	6.0
5.0	4.0	2.0	8.0
8.0	5.0	4.0	2.0
5.0	4.0	5.0	5.0
9.0	4.0	1.0	5.0
0.0	0.0	20.0	0.0
20.0	0.0	0.0	0.0
0.0	0.0	0.0	20.0
20.0	0.0	0.0	0.0
6.0	4.0	9.0	1.0
2.0	1.0	11.0	6.0
4.0	3.0	11.0	2.0
2.0	4.0	10.0	4.0
6.0	4.0	4.0	6.0

#ID = M00127
#Short = V$GATA1_03
#Long = GATA-1 (GATA-binding factor 1)
#W = 14
#Class = 2.2.1.1.1
#Factors = GATA-1B,GATA-1,GATA-1 isoform 1,GATA-1 isoform 2,GATA-1A
#Organisms = human (Homo sapiens),mouse (Mus musculus),clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus)
#Interactions = HM0177,HM0253,HM0254,HM0255,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0439,HM0440,HM0441,HM0442,HM0443,HM0444,HM0454,HM0455,HM0484,HM0485,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1018,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1137,HM1138,HM1140,HM1146,HM1147,HM1148,HM1198,HM1231,M00008,M00075,M00076,M00077,M00109,M00116,M00117,M00121,M00122,M00126,M00127,M00128,M00187,M00191,M00192,M00196,M00203,M00205,M00217,M00223,M00224,M00225,M00259,M00271,M00277,M00278,M00339,M00346,M00347,M00348,M00349,M00350,M00351,M00454,M00492,M00496,M00497,M00531,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0036,MA0036_1,MA0036_2,MA0036_3,MA0036_4,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0055,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0517,MA0517_1,MA0517_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1926,MA1926_1,MA1926_2,MA1931,MA1931_1,MA2279,MA2279_1,MA2290,MA2290_1,MA2312,MA2312_1,MA2388,MA2388_1
#Alternatives = M00075,M00126,M00128,M00346,M00347,HM0439,HM0440,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA2388,MA2388_1
#Transfac class = C0003
4.0	1.0	2.0	0.0
1.0	1.0	3.0	2.0
1.0	2.0	4.0	0.0
2.0	2.0	2.0	1.0
3.0	0.0	2.0	2.0
0.0	0.0	12.0	0.0
12.0	0.0	0.0	0.0
0.0	0.0	0.0	12.0
0.0	0.0	0.0	12.0
8.0	1.0	3.0	0.0
1.0	4.0	4.0	3.0
3.0	4.0	3.0	2.0
3.0	1.0	7.0	1.0
2.0	4.0	4.0	2.0

#ID = M00128
#Short = V$GATA1_04
#Long = GATA-1 (GATA-binding factor 1)
#W = 13
#Class = 2.2.1.1.1
#Factors = GATA-1B,GATA-1,GATA-1 isoform 1,GATA-1 isoform 2,GATA-1A
#Organisms = human (Homo sapiens),mouse (Mus musculus),clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus)
#Interactions = HM0177,HM0253,HM0254,HM0255,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0439,HM0440,HM0441,HM0442,HM0443,HM0444,HM0454,HM0455,HM0484,HM0485,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1018,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1137,HM1138,HM1140,HM1146,HM1147,HM1148,HM1198,HM1231,M00008,M00075,M00076,M00077,M00109,M00116,M00117,M00121,M00122,M00126,M00127,M00128,M00187,M00191,M00192,M00196,M00203,M00205,M00217,M00223,M00224,M00225,M00259,M00271,M00277,M00278,M00339,M00346,M00347,M00348,M00349,M00350,M00351,M00454,M00492,M00496,M00497,M00531,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0036,MA0036_1,MA0036_2,MA0036_3,MA0036_4,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0055,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0517,MA0517_1,MA0517_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1926,MA1926_1,MA1926_2,MA1931,MA1931_1,MA2279,MA2279_1,MA2290,MA2290_1,MA2312,MA2312_1,MA2388,MA2388_1
#Alternatives = M00075,M00126,M00127,M00346,M00347,HM0439,HM0440,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA2388,MA2388_1
#Transfac class = C0003
15.0	1.0	11.0	10.0
10.0	11.0	12.0	15.0
11.0	25.0	9.0	3.0
25.0	2.0	2.0	19.0
0.0	0.0	48.0	0.0
48.0	0.0	0.0	0.0
0.0	0.0	0.0	48.0
48.0	0.0	0.0	0.0
27.0	1.0	16.0	4.0
11.0	8.0	24.0	5.0
12.0	8.0	18.0	10.0
15.0	13.0	16.0	4.0
8.0	13.0	14.0	12.0

#ID = HM0439
#Short = GATA1
#Long = Erythroid transcription factor
#W = 18
#Class = 2.2.1.1.1
#Factors = GATA1,ERYF1,GF1,Gf-1,GATA-binding factor 1,GATA-1,NF-E1 DNA-binding protein
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0177,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1146,HM1147,HM1148,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00454,M00469,M00471,M00497,M00517,M00531,M00615,MA0140,MA0140_1,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1931,MA1931_1,MA2312,MA2312_1
#Alternatives = M00075,M00126,M00127,M00128,M00346,M00347,HM0440,HM1146,HM1147,HM1148,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091,MA0091_1,MA0091_2,MA0140,MA0140_1,MA0140_2,MA0140_3,MA2388,MA2388_1
#HOCOMOCOv13 = GATA1.H13CORE.0.P.B
#UniProt = P15976,P17679
#HGNC = 4170
#GeneCards = GATA1
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 95661
#Entrez = 2623,14460
135.0	231.0	224.0	410.0
90.0	164.0	514.0	232.0
125.0	279.0	440.0	156.0
169.0	282.0	313.0	236.0
188.0	309.0	354.0	149.0
188.0	250.0	429.0	133.0
182.0	263.0	418.0	137.0
206.0	303.0	359.0	132.0
286.0	178.0	362.0	174.0
95.0	506.0	320.0	79.0
640.0	57.0	3.0	300.0
0.0	0.0	1000.0	0.0
1000.0	0.0	0.0	0.0
2.0	2.0	5.0	991.0
941.0	7.0	4.0	48.0
849.0	14.0	118.0	19.0
99.0	175.0	685.0	41.0
281.0	205.0	458.0	56.0

#ID = MA2388
#Short = GATA1
#Long = GATA transcription factor 1
#W = 10
#Class = 2.2.1.1.1
#Factors = GATA1
#Organisms = thale cress (Arabidopsis thaliana)
#Interactions = HM0177,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1146,HM1147,HM1148,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00454,M00469,M00471,M00497,M00517,M00531,M00615,MA0140,MA0140_1,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1931,MA1931_1,MA2312,MA2312_1
#Alternatives = M00075,M00126,M00127,M00128,M00346,M00347,HM0439,HM0440,HM1146,HM1147,HM1148,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091,MA0091_1,MA0091_2,MA0140,MA0140_1,MA0140_2,MA0140_3,MA2388_1
#UniProt = Q8LAU9
#Jaspar = MA2388.1
#Evidence = DAP-seq
#PubMed = 12504119
805.0	55.0	116.0	21.0
1.0	0.0	998.0	0.0
1000.0	0.0	0.0	0.0
0.0	0.0	0.0	1000.0
0.0	988.0	0.0	11.0
0.0	297.0	96.0	605.0
470.0	28.0	500.0	0.0
531.0	32.0	360.0	76.0
483.0	60.0	25.0	429.0
45.0	292.0	72.0	588.0

#ID = MA0035
#Short = GATA1
#Long = Erythroid transcription factor
#W = 7
#Class = 2.2.1.1.1
#Factors = GATA1
#Organisms = human (Homo sapiens)
#Interactions = HM0177,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1146,HM1147,HM1148,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00454,M00469,M00471,M00497,M00517,M00531,M00615,MA0140,MA0140_1,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1931,MA1931_1,MA2312,MA2312_1
#Alternatives = M00075,M00126,M00127,M00128,M00346,M00347,HM0439,HM0440,HM1146,HM1147,HM1148,MA0035_5,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0091,MA0091_1,MA0091_2,MA0140,MA0140_1,MA0140_2,MA0140_3,MA2388,MA2388_1
#UniProt = P15976
#Jaspar = MA0035.5
#Evidence = ChIP-seq
#PubMed = 23142663
3953.0	62419.0	2712.0	2744.0
1314.0	595.0	652.0	69267.0
49692.0	710.0	856.0	20570.0
67550.0	1292.0	988.0	1998.0
2206.0	1238.0	618.0	67766.0
2567.0	65937.0	1471.0	1853.0
7397.0	3025.0	765.0	60641.0

#ID = M00075
#Short = V$GATA1_01
#Long = GATA-1 (GATA-binding factor 1)
#W = 10
#Class = 2.2.1.1.1
#Factors = GATA-1B,GATA-1,GATA-1 isoform 1,GATA-1 isoform 2,GATA-1A
#Organisms = clawed frog (Xenopus laevis),chick (Gallus gallus),rat (Rattus norvegicus),human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0177,HM0253,HM0254,HM0255,HM0361,HM0362,HM0363,HM0364,HM0367,HM0368,HM0388,HM0439,HM0440,HM0441,HM0442,HM0443,HM0444,HM0454,HM0455,HM0484,HM0485,HM0539,HM0540,HM0635,HM0636,HM0771,HM0772,HM0924,HM0925,HM1018,HM1104,HM1105,HM1106,HM1122,HM1123,HM1124,HM1125,HM1126,HM1137,HM1138,HM1140,HM1146,HM1147,HM1148,HM1198,HM1231,M00008,M00075,M00076,M00077,M00109,M00116,M00117,M00121,M00122,M00126,M00127,M00128,M00187,M00191,M00192,M00196,M00203,M00205,M00217,M00223,M00224,M00225,M00259,M00271,M00277,M00278,M00339,M00346,M00347,M00348,M00349,M00350,M00351,M00454,M00492,M00496,M00497,M00531,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0036,MA0036_1,MA0036_2,MA0036_3,MA0036_4,MA0037,MA0037_1,MA0037_2,MA0037_3,MA0037_4,MA0037_5,MA0055,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0080,MA0080_1,MA0080_2,MA0080_3,MA0080_4,MA0080_5,MA0080_6,MA0080_7,MA0081,MA0081_1,MA0081_2,MA0081_3,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0102,MA0102_1,MA0102_2,MA0102_3,MA0102_4,MA0102_5,MA0112,MA0112_1,MA0112_2,MA0112_3,MA0112_4,MA0113,MA0113_1,MA0113_2,MA0113_3,MA0113_4,MA0137,MA0137_1,MA0137_2,MA0137_3,MA0137_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0144,MA0144_1,MA0144_2,MA0144_3,MA0150,MA0150_1,MA0150_2,MA0150_3,MA0156,MA0156_1,MA0156_2,MA0156_3,MA0156_4,MA0258,MA0258_1,MA0258_2,MA0466,MA0466_1,MA0466_2,MA0466_3,MA0466_4,MA0517,MA0517_1,MA0517_2,MA0522,MA0522_2,MA0522_3,MA0522_4,MA0682,MA0682_1,MA0682_2,MA0682_3,MA1495,MA1495_1,MA1495_2,MA1512,MA1512_1,MA1512_2,MA1926,MA1926_1,MA1926_2,MA1931,MA1931_1,MA2279,MA2279_1,MA2290,MA2290_1,MA2312,MA2312_1,MA2388,MA2388_1
#Alternatives = M00126,M00127,M00128,M00346,M00347,HM0439,HM0440,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA2388,MA2388_1
#Transfac class = C0003
5.0	22.0	20.0	6.0
11.0	17.0	20.0	5.0
11.0	15.0	10.0	17.0
0.0	0.0	53.0	0.0
50.0	1.0	0.0	2.0
1.0	1.0	1.0	50.0
18.0	6.0	18.0	11.0
6.0	14.0	24.0	9.0
6.0	14.0	18.0	14.0
7.0	11.0	19.0	15.0

#ID = MA0091
#Short = TAL1::TCF3
#Long = Transcription factor E2-alpha::T-cell acute lymphocytic leukemia protein 1
#W = 10
#Class = 1.2.1.0.1
#Factors = TFE2,TAL1,TCF3
#Organisms = human (Homo sapiens)
#Part = Dimer
#Interactions = HM0201,HM0367,HM0368,HM0419,HM0484,HM0485,HM0538,HM0621,HM0622,HM0746,HM0758,HM0759,HM1018,HM1146,HM1147,HM1148,HM1198,HM1219,HM1220,HM1221,HM1222,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00339,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00469,M00471,M00497,M00517,M00615,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0091,MA0091_1,MA0091_2,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0100,MA0100_1,MA0100_2,MA0100_3,MA0100_4,MA0140_2,MA0140_3,MA0479,MA0479_1,MA0479_2,MA0499,MA0499_1,MA0499_2,MA0499_3,MA0521,MA0521_1,MA0521_2,MA0521_3,MA0522,MA0522_1,MA0522_2,MA0522_3,MA0522_4,MA0633,MA0633_1,MA0633_2,MA0633_3,MA0830,MA0830_1,MA0830_2,MA0830_3,MA1100,MA1100_1,MA1100_2,MA1100_3,MA1123,MA1123_1,MA1123_2,MA1123_3,MA1631,MA1631_1,MA1631_2,MA1648,MA1648_1,MA1648_2,MA2123,MA2123_1
#Alternatives = HM0439,HM0440,HM0484,HM0485,HM1146,HM1147,HM1148,HM1198,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091_2,MA0091_1,MA0092,MA0092_1,MA0092_2,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA2388,MA2388_1
#UniProt = P15923,P17542
#Jaspar = MA0091.2
#DimerClass = 1.2.3.1.1
#Evidence = SELEX
#PubMed = 8289805
39.0	0.0	3.0	2.0
20.0	24.0	0.0	0.0
0.0	43.0	1.0	0.0
44.0	0.0	0.0	0.0
0.0	1.0	11.0	32.0
12.0	32.0	0.0	0.0
0.0	0.0	0.0	44.0
0.0	0.0	43.0	1.0
0.0	3.0	20.0	21.0
4.0	4.0	2.0	34.0

#ID = M00070
#Short = V$TAL1BETAITF2_01
#Long = Tal-1beta:ITF-2 (Tal-1beta:ITF-2 heterodimer) (TAL-1=T-cell acute lymphocytic leukemia protein 1, ITF=immunoglobulin transcription factor)
#W = 16
#Class = 1.2.1.0.2
#Factors = ITF-2,SEF2-1B,Tal1-PP22
#Organisms = human (Homo sapiens)
#Interactions = HM0439,HM0440,HM0484,HM0485,HM1146,HM1147,HM1148,HM1198,HM1231,M00001,M00002,M00065,M00066,M00070,M00071,M00184,M00222,M00454,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0055,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA2388,MA2388_1
#Transfac class = C0010
10.0	32.0	43.0	15.0
12.0	28.0	35.0	25.0
19.0	23.0	37.0	21.0
74.0	0.0	14.0	12.0
72.0	21.0	5.0	2.0
0.0	100.0	0.0	0.0
100.0	0.0	0.0	0.0
0.0	0.0	98.0	2.0
95.0	2.0	3.0	0.0
0.0	0.0	0.0	100.0
0.0	0.0	100.0	0.0
0.0	3.0	63.0	34.0
0.0	30.0	0.0	70.0
17.0	39.0	20.0	24.0
25.0	21.0	14.0	40.0
16.0	35.0	26.0	23.0

#ID = HM1146
#Short = TAL1
#Long = T-cell acute lymphocytic leukemia protein 1
#W = 19
#Class = 1.2.3.1.1
#Factors = TAL1,BHLHA17,SCL,TCL5,Tal-1,Class A basic helix-loop-helix protein 17,Stem cell protein,T-cell leukemia/lymphoma protein 5
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0367,HM0368,HM0439,HM0440,HM0538,HM0621,HM0622,HM0746,HM1018,HM1198,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00339,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00469,M00471,M00497,M00517,M00615,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0100,MA0100_1,MA0100_2,MA0100_3,MA0100_4,MA0140,MA0140_1,MA0521,MA0521_1,MA0521_2,MA0521_3,MA0522,MA0522_1,MA0522_2,MA0522_3,MA0522_4,MA0830,MA0830_1,MA0830_2,MA0830_3,MA1648,MA1648_1,MA1648_2,MA2388,MA2388_1
#Alternatives = HM0439,HM0440,HM0484,HM0485,HM1147,HM1148,HM1198,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA2388,MA2388_1
#HOCOMOCOv13 = TAL1.H13CORE.0.P.B
#UniProt = P17542,P22091
#HGNC = 11556
#GeneCards = TAL1
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 0
#MGI = 98480
#Entrez = 6886,21349
87.0	499.0	241.0	174.0
65.0	207.0	154.0	575.0
31.0	57.0	632.0	281.0
84.0	218.0	505.0	194.0
179.0	253.0	309.0	260.0
213.0	234.0	297.0	257.0
208.0	259.0	357.0	177.0
209.0	277.0	312.0	203.0
210.0	281.0	278.0	232.0
335.0	172.0	347.0	147.0
153.0	426.0	322.0	100.0
663.0	13.0	17.0	308.0
2.0	0.0	999.0	0.0
991.0	4.0	2.0	4.0
2.0	15.0	6.0	978.0
942.0	5.0	8.0	46.0
852.0	16.0	117.0	16.0
121.0	229.0	593.0	58.0
342.0	227.0	390.0	42.0

#ID = HM1148
#Short = TAL1
#Long = T-cell acute lymphocytic leukemia protein 1
#W = 14
#Class = 1.2.3.1.1
#Factors = TAL1,BHLHA17,SCL,TCL5,Tal-1,Class A basic helix-loop-helix protein 17,Stem cell protein,T-cell leukemia/lymphoma protein 5
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0367,HM0368,HM0439,HM0440,HM0538,HM0621,HM0622,HM0746,HM1018,HM1198,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00339,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00469,M00471,M00497,M00517,M00615,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0100,MA0100_1,MA0100_2,MA0100_3,MA0100_4,MA0140,MA0140_1,MA0521,MA0521_1,MA0521_2,MA0521_3,MA0522,MA0522_1,MA0522_2,MA0522_3,MA0522_4,MA0830,MA0830_1,MA0830_2,MA0830_3,MA1648,MA1648_1,MA1648_2,MA2388,MA2388_1
#Alternatives = HM0439,HM0440,HM0484,HM0485,HM1146,HM1147,HM1198,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA2388,MA2388_1
#HOCOMOCOv13 = TAL1.H13CORE.1.P.B
#UniProt = P17542,P22091
#HGNC = 11556
#GeneCards = TAL1
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 1
#MGI = 98480
#Entrez = 6886,21349
347.0	89.0	404.0	175.0
206.0	249.0	458.0	102.0
467.0	192.0	153.0	203.0
397.0	116.0	314.0	188.0
409.0	102.0	417.0	87.0
78.0	730.0	198.0	9.0
803.0	4.0	11.0	197.0
1.0	37.0	969.0	8.0
560.0	312.0	136.0	7.0
289.0	32.0	9.0	685.0
429.0	36.0	527.0	23.0
442.0	48.0	284.0	241.0
117.0	198.0	497.0	203.0
408.0	210.0	288.0	109.0

#ID = HM1147
#Short = TAL1
#Long = T-cell acute lymphocytic leukemia protein 1
#W = 14
#Class = 1.2.3.1.1
#Factors = TAL1,BHLHA17,SCL,TCL5,Tal-1,Class A basic helix-loop-helix protein 17,Stem cell protein,T-cell leukemia/lymphoma protein 5
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0367,HM0368,HM0439,HM0440,HM0538,HM0621,HM0622,HM0746,HM1018,HM1198,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00339,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00469,M00471,M00497,M00517,M00615,MA0002,MA0002_1,MA0002_2,MA0002_3,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0098,MA0098_1,MA0098_2,MA0098_3,MA0098_4,MA0100,MA0100_1,MA0100_2,MA0100_3,MA0100_4,MA0140,MA0140_1,MA0521,MA0521_1,MA0521_2,MA0521_3,MA0522,MA0522_1,MA0522_2,MA0522_3,MA0522_4,MA0830,MA0830_1,MA0830_2,MA0830_3,MA1648,MA1648_1,MA1648_2,MA2388,MA2388_1
#Alternatives = HM0439,HM0440,HM0484,HM0485,HM1146,HM1148,HM1198,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA2388,MA2388_1
#HOCOMOCOv13 = TAL1.H13CORE.2.P.B
#UniProt = P17542,P22091
#HGNC = 11556
#GeneCards = TAL1
#HMQuality = B
#Evidence = ChIP-Seq
#Subtype = 2
#MGI = 98480
#Entrez = 6886,21349
277.0	452.0	190.0	101.0
604.0	128.0	128.0	160.0
210.0	67.0	660.0	83.0
295.0	178.0	519.0	28.0
606.0	139.0	116.0	159.0
687.0	75.0	169.0	89.0
496.0	103.0	393.0	28.0
16.0	971.0	21.0	12.0
969.0	10.0	10.0	31.0
22.0	116.0	811.0	71.0
372.0	441.0	164.0	43.0
90.0	35.0	48.0	847.0
73.0	29.0	817.0	101.0
86.0	241.0	370.0	323.0

#ID = M00277
#Short = V$LMO2COM_01
#Long = Lmo2 complex (complex of Lmo2 bound to Tal-1, E2A proteins, and GATA-1, half-site 1)
#W = 12
#Factors = RBTN2,RBTN2-isoform1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0439,HM0440,HM0441,HM0442,HM0484,HM0485,HM0489,HM1104,HM1105,HM1106,HM1146,HM1147,HM1148,HM1198,HM1231,M00008,M00058,M00066,M00068,M00075,M00076,M00126,M00127,M00128,M00196,M00203,M00346,M00347,M00348,M00349,M00454,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0036,MA0036_1,MA0036_2,MA0036_3,MA0036_4,MA0048,MA0048_1,MA0048_2,MA0048_3,MA0055,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1938,MA1938_1,MA1938_2,MA2279,MA2279_1,MA2388,MA2388_1
#Alternatives = M00278
#Transfac class = C0028
3.0	16.0	8.0	3.0
4.0	10.0	11.0	6.0
6.0	12.0	10.0	3.0
0.0	31.0	0.0	0.0
31.0	0.0	0.0	0.0
2.0	0.0	24.0	5.0
2.0	8.0	21.0	0.0
0.0	0.0	0.0	31.0
0.0	0.0	31.0	0.0
0.0	14.0	8.0	9.0
10.0	5.0	4.0	10.0
3.0	8.0	14.0	6.0

#ID = M00278
#Short = V$LMO2COM_02
#Long = Lmo2 complex (complex of Lmo2 bound to Tal-1, E2A proteins, and GATA-1, half-site 2)
#W = 9
#Factors = RBTN2,RBTN2-isoform1
#Organisms = human (Homo sapiens),mouse (Mus musculus)
#Interactions = HM0439,HM0440,HM0441,HM0442,HM0484,HM0485,HM0489,HM1104,HM1105,HM1106,HM1146,HM1147,HM1148,HM1198,HM1231,M00008,M00058,M00066,M00068,M00075,M00076,M00126,M00127,M00128,M00196,M00203,M00346,M00347,M00348,M00349,M00454,MA0035,MA0035_1,MA0035_2,MA0035_3,MA0035_4,MA0035_5,MA0036,MA0036_1,MA0036_2,MA0036_3,MA0036_4,MA0048,MA0048_1,MA0048_2,MA0048_3,MA0055,MA0079,MA0079_1,MA0079_2,MA0079_3,MA0079_4,MA0079_5,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0093,MA0093_1,MA0093_2,MA0093_3,MA0093_4,MA0140,MA0140_1,MA0140_2,MA0140_3,MA0522,MA0522_2,MA0522_3,MA0522_4,MA1938,MA1938_1,MA1938_2,MA2279,MA2279_1,MA2388,MA2388_1
#Alternatives = M00277
#Transfac class = C0028
5.0	14.0	6.0	5.0
14.0	11.0	0.0	6.0
0.0	0.0	31.0	0.0
31.0	0.0	0.0	0.0
0.0	0.0	0.0	31.0
31.0	0.0	0.0	0.0
10.0	7.0	11.0	3.0
1.0	11.0	15.0	4.0
3.0	8.0	19.0	1.0

#ID = MA1923
#Short = Tcf3-4-12
#Long = E2A
#W = 6
#Class = 1.2.1
#Factors = Tcf3-4-12
#Organisms = vase tunicate (Ciona intestinalis)
#Alternatives = MA1923_2,MA1923_1
#Jaspar = MA1923.2
#Evidence = SELEX
#PubMed = 26684323
28.0	959.0	4.0	9.0
968.0	10.0	13.0	8.0
21.0	758.0	132.0	89.0
53.0	853.0	82.0	12.0
18.0	26.0	29.0	927.0
27.0	16.0	896.0	62.0

#ID = MA0522
#Short = TCF3
#Long = Transcription factor E2-alpha
#W = 7
#Class = 1.2.1.0.1
#Factors = TCF3,TFE2
#Organisms = human (Homo sapiens)
#Interactions = HM0201,HM0419,HM0484,HM0485,HM0758,HM0759,HM1146,HM1147,HM1148,HM1219,HM1220,HM1221,HM1222,M00001,M00002,M00004,M00005,M00006,M00008,M00033,M00041,M00050,M00055,M00058,M00059,M00065,M00066,M00068,M00069,M00070,M00071,M00075,M00076,M00109,M00114,M00115,M00117,M00118,M00119,M00121,M00122,M00123,M00126,M00127,M00128,M00148,M00155,M00160,M00172,M00175,M00176,M00183,M00184,M00185,M00187,M00189,M00191,M00192,M00196,M00203,M00205,M00209,M00216,M00217,M00222,M00223,M00225,M00231,M00232,M00233,M00252,M00271,M00277,M00278,M00322,M00341,M00346,M00347,M00348,M00349,M00350,M00351,M00403,M00405,M00406,M00407,M00436,M00444,M00469,M00471,M00497,M00517,M00615,MA0091,MA0091_1,MA0091_2,MA0140_2,MA0140_3,MA0479,MA0479_1,MA0479_2,MA0499,MA0499_1,MA0499_2,MA0499_3,MA0633,MA0633_1,MA0633_2,MA0633_3,MA1100,MA1100_1,MA1100_2,MA1100_3,MA1123,MA1123_1,MA1123_2,MA1123_3,MA1631,MA1631_1,MA1631_2,MA2123,MA2123_1
#Alternatives = HM0484,HM0485,HM1146,HM1147,HM1148,HM1198,MA0091,MA0091_1,MA0091_2,MA0092,MA0092_1,MA0092_2,MA0140,MA0140_2,MA0140_3,MA0522_4,MA0522_1,MA0522_2,MA0522_3
#UniProt = P15923
#Jaspar = MA0522.4
#Evidence = ChIP-seq
#PubMed = 10594029
469.0	29379.0	708.0	705.0
28916.0	396.0	1574.0	375.0
309.0	28640.0	1362.0	950.0
1127.0	27199.0	2652.0	283.0
380.0	2003.0	1339.0	27539.0
1089.0	1038.0	28642.0	492.0
295.0	28742.0	987.0	1237.0

